/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.common.ability.api.UccElectronicExportInfoService;
import com.tydic.commodity.common.ability.bo.ElectronicExportInBO;
import com.tydic.commodity.common.ability.bo.UccElectronicExportInfoReqBO;
import com.tydic.commodity.common.ability.bo.UccElectronicExportInfoRspBO;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.QryDiscountCatalogListImportPO;
import com.tydic.commodity.po.UccSkuPo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccElectronicExportInfoService"})
public class UccElectronicExportInfoServiceImpl
implements UccElectronicExportInfoService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;

    @PostMapping(value={"queryElectronicExport"})
    public UccElectronicExportInfoRspBO queryElectronicExport(@RequestBody UccElectronicExportInfoReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            throw new ZTBusinessException("\u53c2\u6570\u5f02\u5e38");
        }
        List uccSkuPos = this.uccSkuMapper.queryExtExportSku(reqBO.getSkuIds());
        List couponList = this.uccEMdmCatalogMapper.queryElectronicExport(uccSkuPos.stream().map(UccSkuPo::getCommodityTypeId).distinct().collect(Collectors.toList()));
        Map catalogMap = couponList.stream().collect(Collectors.toMap(QryDiscountCatalogListImportPO::getCommodityTypeId, Function.identity()));
        List bos = uccSkuPos.stream().map(x -> {
            ElectronicExportInBO bo = new ElectronicExportInBO();
            bo.setSkuId(x.getSkuId());
            bo.setExtSkuId(x.getExtSkuId());
            bo.setBrandName(x.getBrandName());
            QryDiscountCatalogListImportPO catabo = (QryDiscountCatalogListImportPO)catalogMap.get(x.getCommodityTypeId());
            if (Objects.nonNull(catabo)) {
                bo.setL1catalogCode(catabo.getCatalogCode1());
                bo.setL1catalogName(catabo.getCatalogName1());
                bo.setL2catalogCode(catabo.getCatalogCode2());
                bo.setL2catalogName(catabo.getCatalogName2());
                bo.setL3catalogCode(catabo.getCatalogCode3());
                bo.setL3catalogName(catabo.getCatalogName3());
            }
            return bo;
        }).collect(Collectors.toList());
        UccElectronicExportInfoRspBO res = new UccElectronicExportInfoRspBO();
        res.setExportInfos(bos);
        res.setRespCode("0000");
        res.setRespDesc("0000");
        return res;
    }
}

