/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.api.SyncSceneStandardCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.bo.SyncSceneStandardCommodityToEsReqBO;
import com.tydic.commodity.common.ability.api.UccStandardComInfoAddAbilityService;
import com.tydic.commodity.common.ability.bo.UccStandardComInfoAddAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccStandardComInfoAddAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccStandardComInfoAddBusiService;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccStandardComInfoAddAbilityService"})
public class UccStandardComInfoAddAbilityServiceImpl
implements UccStandardComInfoAddAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccStandardComInfoAddAbilityServiceImpl.class);
    @Autowired
    private UccStandardComInfoAddBusiService uccStandardComInfoAddBusiService;
    @Autowired
    private SyncSceneStandardCommodityToEsAtomService syncSceneStandardCommodityToEsAtomService;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Autowired
    private CacheClient cacheService;

    @PostMapping(value={"dealStandardComInfoAdd"})
    public UccStandardComInfoAddAbilityRspBO dealStandardComInfoAdd(@RequestBody UccStandardComInfoAddAbilityReqBO reqBO) {
        log.info("\u6807\u54c1\u5904\u7406\u5f00\u59cb {}", (Object)JSON.toJSONString((Object)reqBO));
        this.validateReq(reqBO);
        this.checkStandId(reqBO);
        UccStandardComInfoAddAbilityRspBO rspBO = this.uccStandardComInfoAddBusiService.dealStandardComInfoAdd(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            CompletableFuture.runAsync(() -> {
                this.syncEsStandard(rspBO.getStandardId());
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                List<Long> skuIds = Arrays.asList(reqBO.getSkuId());
                syncSceneCommodityToEsReqBO.setSkuIds(skuIds);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(0);
                try {
                    this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u540c\u6b65es\u6570\u636e\u5931\u8d25");
                }
            });
        }
        return rspBO;
    }

    private void checkStandId(UccStandardComInfoAddAbilityReqBO reqBO) {
        if (!StringUtils.isEmpty((Object)reqBO.getStandardComId())) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                String reqMd = Hex.encodeHexString((byte[])md.digest(reqBO.getStandardComId().getBytes(StandardCharsets.UTF_8)));
                Long myKey = null;
                try {
                    myKey = this.cacheService.setnx(reqMd, (Object)reqMd);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (myKey != null && !myKey.equals(1L)) {
                    try {
                        Long expireTime = this.cacheService.getExpireTimeByKey(reqMd);
                        if (expireTime <= 0L) {
                            myKey = null;
                        }
                    }
                    catch (Exception e) {
                        log.error("\u83b7\u53d6\u5f53\u524dkey\u8fc7\u671f\u65f6\u95f4\u5931\u8d25,key" + reqMd);
                    }
                }
                if (myKey == null || !myKey.equals(1L)) {
                    log.info("\u5916\u90e8\u6807\u54c1id\u7684\u552f\u4e00redis\u6821\u9a8c\u5982\u679c\u5df2\u7ecf\u88ab\u5360\u7528\uff0c\u5219\u5f53\u524d\u7ebf\u7a0b\u7761\u772030\u79d2");
                    Thread.sleep(30000L);
                } else if (null != reqMd) {
                    try {
                        this.cacheService.set(reqMd, (Object)"", 30);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void validateReq(UccStandardComInfoAddAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getSkuId()) || ObjectUtil.isEmpty((Object)reqBO.getStandardComId())) {
            throw new RuntimeException("\u53c2\u6570\u5f02\u5e38");
        }
    }

    private void syncEsStandard(Long standardId) {
        SyncSceneStandardCommodityToEsReqBO commodityToEsReqBO = new SyncSceneStandardCommodityToEsReqBO();
        commodityToEsReqBO.setStandardId(standardId);
        commodityToEsReqBO.setSyncType(UccConstants.StandardSyncEsType.add);
        this.syncSceneStandardCommodityToEsAtomService.syncSceneCommodityToEs(commodityToEsReqBO);
    }
}

