/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.ability.api.UccWarehouseAddressCheckAbilityService;
import com.tydic.commodity.common.ability.bo.UccEnterpriseWarehouseBO;
import com.tydic.commodity.common.ability.bo.UccWarehouseAddressCheckAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccWarehouseAddressCheckAbilityRspBO;
import com.tydic.commodity.dao.UccEnterpriseWarehouseMapper;
import com.tydic.commodity.dao.UccWarehouseAddressMapper;
import com.tydic.commodity.po.UccEnterpriseWarehousePO;
import com.tydic.commodity.po.UccWarehouseAddressPO;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccWarehouseAddressCheckAbilityService"})
public class UccWarehouseAddressCheckAbilityServiceImpl
implements UccWarehouseAddressCheckAbilityService {
    @Autowired
    private UccWarehouseAddressMapper uccWarehouseAddressMapper;
    @Autowired
    private UccEnterpriseWarehouseMapper uccEnterpriseWarehouseMapper;

    @PostMapping(value={"checkWarehouseAddress"})
    public UccWarehouseAddressCheckAbilityRspBO checkWarehouseAddress(@RequestBody UccWarehouseAddressCheckAbilityReqBO reqBO) {
        UccWarehouseAddressCheckAbilityRspBO rspBO = new UccWarehouseAddressCheckAbilityRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getSupplierId())) {
            throw new ZTBusinessException("\u5165\u53c2[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getProvince())) {
            throw new ZTBusinessException("\u5165\u53c2[province]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<String> areaList = new ArrayList<String>();
        areaList.add(reqBO.getProvince());
        if (!StringUtils.isEmpty((Object)reqBO.getCity())) {
            areaList.add(reqBO.getCity());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getCounty())) {
            areaList.add(reqBO.getCounty());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getTown())) {
            areaList.add(reqBO.getTown());
        }
        String area = String.join((CharSequence)"/", areaList);
        if (!StringUtils.isEmpty((Object)reqBO.getAddress())) {
            areaList.add(reqBO.getAddress());
        }
        String fullArea = String.join((CharSequence)"/", areaList);
        UccWarehouseAddressPO uccWarehouseAddressPO = new UccWarehouseAddressPO();
        uccWarehouseAddressPO.setArea(area);
        uccWarehouseAddressPO.setAddressType(UccConstants.AddressType.CURRENT);
        uccWarehouseAddressPO.setSupplierId(reqBO.getSupplierId());
        Long warehouseId = this.uccWarehouseAddressMapper.getByAddress(uccWarehouseAddressPO);
        if (warehouseId == null) {
            uccWarehouseAddressPO.setArea(fullArea);
            uccWarehouseAddressPO.setAddressType(UccConstants.AddressType.SUPPLEMENT);
            warehouseId = this.uccWarehouseAddressMapper.getByAddress(uccWarehouseAddressPO);
        }
        if (warehouseId != null) {
            uccWarehouseAddressPO.setArea(fullArea);
            uccWarehouseAddressPO.setAddressType(UccConstants.AddressType.EXCLUSE);
            Long excluseId = this.uccWarehouseAddressMapper.getByAddress(uccWarehouseAddressPO);
            if (excluseId == null) {
                UccEnterpriseWarehousePO uccEnterpriseWarehousePO = new UccEnterpriseWarehousePO();
                uccEnterpriseWarehousePO.setWarehouseId(warehouseId);
                uccEnterpriseWarehousePO = this.uccEnterpriseWarehouseMapper.getModelBy(uccEnterpriseWarehousePO);
                if (uccEnterpriseWarehousePO != null) {
                    rspBO.setUccEnterpriseWarehouseBO((UccEnterpriseWarehouseBO)JSON.parseObject((String)JSONObject.toJSONString((Object)uccEnterpriseWarehousePO), UccEnterpriseWarehouseBO.class));
                }
            }
        }
        return rspBO;
    }
}

