/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.SmartContainerBO;
import com.tydic.commodity.common.ability.bo.SmartContainerReqBO;
import com.tydic.commodity.common.ability.bo.SmartContainerRspBO;
import com.tydic.commodity.common.busi.api.SmartContainerBusiService;
import com.tydic.commodity.dao.SmartContainerImportMapper;
import com.tydic.commodity.dao.SmartContainerMapper;
import com.tydic.commodity.po.SmartContainerImportPO;
import com.tydic.commodity.po.SmartContainerPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SmartContainerBusiServiceImpl
implements SmartContainerBusiService {
    private static final Logger log = LoggerFactory.getLogger(SmartContainerBusiServiceImpl.class);
    @Autowired
    private SmartContainerMapper smartContainerMapper;
    @Autowired
    private SmartContainerImportMapper smartContainerImportMapper;

    @Override
    public SmartContainerRspBO qrySmartList(SmartContainerReqBO reqBO) {
        SmartContainerPO smartContainerPO = new SmartContainerPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)smartContainerPO);
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo());
        page.setPageSize(reqBO.getPageSize());
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getPageSize() * (reqBO.getPageNo() - 1));
        List list = this.smartContainerMapper.getListPage(smartContainerPO, page);
        SmartContainerRspBO rspBO = new SmartContainerRspBO();
        if (CollectionUtils.isEmpty((Collection)list)) {
            rspBO.setTotal(0);
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(0);
            rspBO.setRows(new ArrayList());
        } else {
            int i = 1;
            ArrayList<SmartContainerBO> rows = new ArrayList<SmartContainerBO>();
            for (SmartContainerPO containerPO : list) {
                SmartContainerBO bo = new SmartContainerBO();
                BeanUtils.copyProperties((Object)containerPO, (Object)bo);
                bo.setOrder(Integer.valueOf(reqBO.getPageSize() * (reqBO.getPageNo() - 1) + i));
                ++i;
                bo.setStateStr(bo.getState() == 1 ? "\u542f\u7528" : "\u505c\u7528");
                rows.add(bo);
            }
            rspBO.setRows(rows);
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setTotal(page.getTotalPages());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public SmartContainerRspBO dealCreateSmart(SmartContainerReqBO reqBO) {
        SmartContainerRspBO rspBO = new SmartContainerRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Long id = Sequence.getInstance().nextId();
        SmartContainerPO smartContainerPO = new SmartContainerPO();
        smartContainerPO.setId(id);
        smartContainerPO.setScCode(reqBO.getScCode());
        smartContainerPO.setScName(reqBO.getScName());
        smartContainerPO.setCreateName(reqBO.getName());
        smartContainerPO.setCreateOrgCode(reqBO.getOrgCodeIn());
        smartContainerPO.setCreateOrgId(reqBO.getOrgId() + "");
        smartContainerPO.setCreateTime(new Date());
        smartContainerPO.setCreateUserId(reqBO.getUserId() + "");
        smartContainerPO.setCreateUserName(reqBO.getUsername());
        smartContainerPO.setUpdateName(reqBO.getName());
        smartContainerPO.setUpdateTime(new Date());
        smartContainerPO.setUpdateUserId(reqBO.getUserId() + "");
        smartContainerPO.setUpdateUserName(reqBO.getUsername());
        smartContainerPO.setState(Integer.valueOf(1));
        this.smartContainerMapper.insert(smartContainerPO);
        return rspBO;
    }

    @Override
    public SmartContainerRspBO dealUpdateSmart(SmartContainerReqBO reqBO) {
        if (reqBO.getId() == null) {
            throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u5165\u53c2ID");
        }
        SmartContainerRspBO rspBO = new SmartContainerRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        SmartContainerPO smartContainerPO = new SmartContainerPO();
        smartContainerPO.setId(reqBO.getId());
        smartContainerPO.setScName(reqBO.getScName());
        smartContainerPO.setScCode(reqBO.getScCode());
        smartContainerPO.setState(reqBO.getState());
        smartContainerPO.setUpdateName(reqBO.getName());
        smartContainerPO.setUpdateTime(new Date());
        smartContainerPO.setUpdateUserId(reqBO.getUserId() + "");
        smartContainerPO.setUpdateUserName(reqBO.getUsername());
        this.smartContainerMapper.update(smartContainerPO);
        return rspBO;
    }

    @Override
    public SmartContainerRspBO getImportLog(SmartContainerReqBO reqBO) {
        SmartContainerImportPO smartContainerPO = new SmartContainerImportPO();
        smartContainerPO.setScId(reqBO.getId());
        smartContainerPO.setState(reqBO.getState());
        smartContainerPO.setImportType(reqBO.getImportType());
        smartContainerPO.setTempId(reqBO.getTempId());
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo());
        page.setPageSize(reqBO.getPageSize());
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getPageSize() * (reqBO.getPageNo() - 1));
        List list = this.smartContainerImportMapper.getListPage(smartContainerPO, page);
        SmartContainerRspBO rspBO = new SmartContainerRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setSuccessCount(Integer.valueOf(0));
        rspBO.setFailCount(Integer.valueOf(0));
        if (CollectionUtils.isEmpty((Collection)list)) {
            rspBO.setTotal(0);
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(0);
            rspBO.setRows(new ArrayList());
        } else {
            int i = 1;
            ArrayList<SmartContainerBO> rows = new ArrayList<SmartContainerBO>();
            for (SmartContainerImportPO containerPO : list) {
                SmartContainerBO bo = new SmartContainerBO();
                BeanUtils.copyProperties((Object)containerPO, (Object)bo);
                bo.setOrder(Integer.valueOf(reqBO.getPageSize() * (reqBO.getPageNo() - 1) + i));
                ++i;
                bo.setStateStr(bo.getState() == 1 ? "\u6210\u529f" : "\u5931\u8d25");
                rows.add(bo);
            }
            rspBO.setRows(rows);
            List temp = this.smartContainerImportMapper.getTemp(smartContainerPO);
            log.debug(JSONObject.toJSONString((Object)temp));
            for (SmartContainerImportPO po : temp) {
                if (po.getState() == 1) {
                    rspBO.setSuccessCount(po.getImportType());
                } else {
                    rspBO.setFailCount(po.getImportType());
                }
                rspBO.setCreateTime(po.getCreateTime());
            }
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRecordsTotal(page.getTotalCount());
        }
        return rspBO;
    }

    @Override
    public SmartContainerRspBO qrySmartBySku(SmartContainerReqBO reqBO) {
        SmartContainerPO smartContainerPO = new SmartContainerPO();
        smartContainerPO.setSkuIds(reqBO.getSkuIds());
        List list = this.smartContainerMapper.qrySmartBySku(smartContainerPO);
        SmartContainerRspBO rspBO = new SmartContainerRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)list)) {
            rspBO.setRows(new ArrayList());
        } else {
            rspBO.setRows(JSONArray.parseArray((String)JSONObject.toJSONString((Object)list), SmartContainerBO.class));
        }
        return rspBO;
    }

    @Override
    public SmartContainerRspBO checkSmartBySku(SmartContainerReqBO reqBO) {
        SmartContainerPO smartContainerPO = new SmartContainerPO();
        smartContainerPO.setSkuIds(reqBO.getSkuIds());
        smartContainerPO.setWorkNo(reqBO.getWorkNo());
        List list = this.smartContainerMapper.checkSmartBySku(smartContainerPO);
        SmartContainerRspBO rspBO = new SmartContainerRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)list)) {
            rspBO.setSkuIds(reqBO.getSkuIds());
        } else {
            Map<Long, SmartContainerPO> map = list.stream().collect(Collectors.toMap(SmartContainerPO::getSkuId, i -> i));
            ArrayList<Long> not = new ArrayList<Long>();
            for (Long sku : reqBO.getSkuIds()) {
                if (map.get(sku) != null) continue;
                not.add(sku);
            }
            rspBO.setSkuIds(not);
        }
        return rspBO;
    }
}

