/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.enumType.Brand;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSyncBrandToDGAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSyncBrandToDGAtomReqBo;
import com.tydic.commodity.common.ability.bo.UccBrandUpdateReqBO;
import com.tydic.commodity.common.ability.bo.UccBrandUpdateRspBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.api.UccBrandUpdateBusiService;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccRelCatalogBrandVendorMapper;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccRelCatalogBrandVendorPO;
import com.tydic.commodity.utils.DateUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccBrandUpdateBusiServiceImpl
implements UccBrandUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccBrandUpdateBusiServiceImpl.class);
    private UccBrandDealMapper uccBrandDealMapper;
    private UccDictionaryAtomService uccDictionaryAtomService;
    private UccRelCatalogBrandVendorMapper uccRelCatalogBrandVendorMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccBrandUpdateBusiServiceImpl.class);
    @Autowired
    private UccSyncBrandToDGAtomService uccSyncBrandToDGAtomService;

    @Override
    public UccBrandUpdateRspBO updateBrand(UccBrandUpdateReqBO reqBO) {
        UccBrandUpdateRspBO rspBO = new UccBrandUpdateRspBO();
        String msg = this.judge(reqBO);
        if (!StringUtils.isEmpty((CharSequence)msg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(msg);
            return rspBO;
        }
        UccBrandDealPO uccBrandDealPo = new UccBrandDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccBrandDealPo);
        uccBrandDealPo.setUpdateOperId(reqBO.getUsername());
        uccBrandDealPo.setUpdateOperName(reqBO.getName());
        uccBrandDealPo.setUpdateTime(new Date());
        UccBrandUpdateBusiServiceImpl.transStringToDate(reqBO, uccBrandDealPo);
        try {
            if (uccBrandDealPo.getBrandStatus() != null) {
                UccBrandDealPO temp;
                Date time = new Date(System.currentTimeMillis());
                if (uccBrandDealPo.getBrandStatus() == 1) {
                    if (uccBrandDealPo.getEffTime() != null && uccBrandDealPo.getExpTime() != null) {
                        if (uccBrandDealPo.getEffTime().getTime() >= time.getTime() || time.getTime() >= uccBrandDealPo.getExpTime().getTime()) {
                            uccBrandDealPo.setExpTime(null);
                            uccBrandDealPo.setEffTime(null);
                        }
                    } else {
                        temp = new UccBrandDealPO();
                        temp.setBrandId(reqBO.getBrandId());
                        UccBrandDealPO uccBrandDealPO = this.uccBrandDealMapper.selectById(temp);
                        if (uccBrandDealPO.getExpTime() != null && uccBrandDealPO.getEffTime() != null && (uccBrandDealPO.getEffTime().getTime() >= time.getTime() || time.getTime() >= uccBrandDealPO.getExpTime().getTime())) {
                            try {
                                this.uccBrandDealMapper.updateBrandTime(temp.getBrandId());
                            }
                            catch (Exception e) {
                                throw new BusinessException("8888", "\u6e05\u9664\u751f\u5931\u6548\u65f6\u95f4\u5931\u8d25\uff1a" + e.getMessage());
                            }
                        }
                    }
                }
                if (uccBrandDealPo.getBrandStatus() == 0) {
                    if (uccBrandDealPo.getEffTime() != null && uccBrandDealPo.getExpTime() != null) {
                        if (uccBrandDealPo.getEffTime().getTime() < time.getTime() && time.getTime() < uccBrandDealPo.getExpTime().getTime()) {
                            uccBrandDealPo.setExpTime(null);
                            uccBrandDealPo.setEffTime(null);
                        }
                    } else {
                        temp = new UccBrandDealPO();
                        temp.setBrandId(reqBO.getBrandId());
                        UccBrandDealPO uccBrandPo = this.uccBrandDealMapper.selectById(temp);
                        if (uccBrandPo.getExpTime() != null && uccBrandPo.getEffTime() != null && uccBrandPo.getEffTime().getTime() < time.getTime() && time.getTime() < uccBrandPo.getExpTime().getTime()) {
                            try {
                                this.uccBrandDealMapper.updateBrandTime(temp.getBrandId());
                            }
                            catch (Exception e) {
                                throw new BusinessException("8888", "\u6e05\u9664\u751f\u5931\u6548\u65f6\u95f4\u5931\u8d25\uff1a" + e.getMessage());
                            }
                        }
                    }
                }
            }
            this.uccBrandDealMapper.updateBrand(uccBrandDealPo);
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u54c1\u724c\u5f02\u5e38{}", (Object)e.getMessage());
            throw new BusinessException("8888", "\u66f4\u65b0\u54c1\u724c\u4fe1\u606f\u5931\u8d25");
        }
        try {
            UccSyncBrandToDGAtomReqBo uccSyncBrandToDGAtomReqBo = new UccSyncBrandToDGAtomReqBo();
            uccSyncBrandToDGAtomReqBo.setBrandIds((List)Lists.newArrayList((Object[])new Long[]{reqBO.getBrandId()}));
            this.uccSyncBrandToDGAtomService.dealSyncBrandToDG(uccSyncBrandToDGAtomReqBo);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u6570\u636e\u6cbb\u7406\u5931\u8d25\uff1a" + e.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u66f4\u65b0\u54c1\u724c\u4fe1\u606f\u6210\u529f");
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        if (list.contains(uccBrandDealPo.getAppRange()) || uccBrandDealPo.getBrandStatus() == 0) {
            rspBO.setSyncFlag(true);
        }
        return rspBO;
    }

    public String judge(UccBrandUpdateReqBO reqBO) {
        Map<String, String> map;
        long result1;
        Date expTime;
        SimpleDateFormat str;
        String msg = "";
        if (reqBO.getBrandId() == null) {
            msg = "\u54c1\u724cID\u4e0d\u80fd\u4e3a\u7a7a";
            return msg;
        }
        if (reqBO.getBelongOrg() == null) {
            msg = "\u54c1\u724c\u6240\u5c5e\u4f01\u4e1a\u4e0d\u80fd\u4e3a\u7a7a";
            return msg;
        }
        UccBrandDealPO po = new UccBrandDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        UccBrandDealPO uccBrandDealP0 = this.uccBrandDealMapper.selectById(po);
        if (uccBrandDealP0 == null) {
            msg = "\u54c1\u724cID\u4e0d\u5b58\u5728";
            return msg;
        }
        String rs = this.checkBrandNameExistAndOtherParam(reqBO, uccBrandDealP0);
        if (!StringUtils.isEmpty((CharSequence)rs)) {
            return rs;
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getExpTime()) && !StringUtil.isEmpty((String)reqBO.getEffTime())) {
            str = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                expTime = str.parse(reqBO.getExpTime());
                if (expTime.getTime() < new Date(System.currentTimeMillis()).getTime()) {
                    msg = "\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4";
                    return msg;
                }
                UccBrandDealPO bo = new UccBrandDealPO();
                BeanUtils.copyProperties((Object)reqBO, (Object)bo);
                UccBrandDealPO result = this.uccBrandDealMapper.selectById(bo);
                if (result != null && result.getEffTime() != null && result.getExpTime() != null && (result1 = result.getEffTime().getTime() - result.getExpTime().getTime()) > 0L) {
                    msg = "\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65f6\u95f4";
                    return msg;
                }
            }
            catch (ParseException e) {
                msg = "\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9";
                return msg;
            }
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getEffTime()) && !StringUtils.isEmpty((CharSequence)reqBO.getExpTime())) {
            str = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            UccBrandDealPO bo = new UccBrandDealPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)bo);
            UccBrandDealPO result = null;
            try {
                result = this.uccBrandDealMapper.selectById(bo);
                Date effTime = DateUtils.strToDate((String)reqBO.getEffTime());
                if (result != null && result.getExpTime() != null && (result1 = effTime.getTime() - result.getExpTime().getTime()) > 0L) {
                    msg = "\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65f6\u95f4";
                    return msg;
                }
            }
            catch (Exception e) {
                msg = "\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9";
                return msg;
            }
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getExpTime()) && !StringUtils.isEmpty((CharSequence)reqBO.getEffTime())) {
            str = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                expTime = str.parse(reqBO.getExpTime());
                Date effTime = str.parse(reqBO.getEffTime());
                long result = effTime.getTime() - expTime.getTime();
                if (result > 0L) {
                    msg = "\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65f6\u95f4";
                    return msg;
                }
            }
            catch (ParseException e) {
                msg = "\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9";
                return msg;
            }
        }
        if (reqBO.getBrandStatus() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(Brand.BRAND_STATUS.toString())).containsKey(String.valueOf(reqBO.getBrandStatus()))) {
            msg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u72b6\u6001";
            return msg;
        }
        return msg;
    }

    private String checkBrandNameExistAndOtherParam(UccBrandUpdateReqBO reqBO, UccBrandDealPO uccBrandDealPo) {
        boolean ifExists;
        String msg = "";
        UccBrandDealPO queryPo = new UccBrandDealPO();
        queryPo.setBrandName(reqBO.getBrandName());
        queryPo.setBelongOrg(reqBO.getBelongOrg());
        List uccBrandDealList = this.uccBrandDealMapper.selectBy(queryPo);
        boolean bl = ifExists = uccBrandDealList.size() > 1 || uccBrandDealList.size() == 1 && !reqBO.getBrandId().equals(((UccBrandDealPO)uccBrandDealList.get(0)).getBrandId());
        if (ifExists) {
            msg = "\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u54c1\u724c\u540d\u79f0\u3001\u54c1\u724c\u6240\u5c5e\u4f01\u4e1a\u7684\u54c1\u724c\u4e86\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\uff01";
            return msg;
        }
        if (!uccBrandDealPo.getAppRange().equals(reqBO.getAppRange()) && reqBO.getAppRange() != 0) {
            UccRelCatalogBrandVendorPO uccRelCatalogBrandVendorPo = new UccRelCatalogBrandVendorPO();
            uccRelCatalogBrandVendorPo.setBrandId(reqBO.getBrandId());
            uccRelCatalogBrandVendorPo.setStatus(Integer.valueOf(1));
            uccRelCatalogBrandVendorPo.setDiscountFlag(Integer.valueOf(0));
            List list = this.uccRelCatalogBrandVendorMapper.getList(uccRelCatalogBrandVendorPo);
            if (uccBrandDealPo.getAppRange() == 1) {
                if (list.size() > 0) {
                    msg = "\u8be5\u54c1\u724c\u5df2\u7ecf\u4e0e\u7269\u8d44\u5206\u7c7b\u8fdb\u884c\u4e86\u5173\u8054\uff0c\u5982\u9700\u8fdb\u884c\u53d8\u66f4\uff0c\u8bf7\u5148\u5c06\u7269\u8d44\u5206\u7c7b\u4e0e\u54c1\u724c\u7684\u5173\u8054\u5173\u7cfb\u505c\u7528\u6216\u9650\u5236\u4e4b\u540e\u518d\u8fdb\u884c\u53d8\u66f4\uff01";
                    return msg;
                }
            } else if (uccBrandDealPo.getAppRange() == 0 && list.size() > 0 && reqBO.getAppRange() != 1) {
                msg = "\u8be5\u54c1\u724c\u5df2\u7ecf\u4e0e\u7269\u8d44\u5206\u7c7b\u8fdb\u884c\u4e86\u5173\u8054\uff0c\u5982\u9700\u8fdb\u884c\u53d8\u66f4\uff0c\u8bf7\u5148\u5c06\u7269\u8d44\u5206\u7c7b\u4e0e\u54c1\u724c\u7684\u5173\u8054\u5173\u7cfb\u505c\u7528\u6216\u9650\u5236\u4e4b\u540e\u518d\u8fdb\u884c\u53d8\u66f4\uff01";
                return msg;
            }
        }
        return msg;
    }

    public static void transStringToDate(UccBrandUpdateReqBO reqBO, UccBrandDealPO brandDealPO) {
        String effTime = reqBO.getEffTime();
        String expTime = reqBO.getExpTime();
        Date effTime1 = null;
        Date expTime1 = null;
        try {
            if (StringUtils.isNotEmpty((CharSequence)effTime)) {
                effTime1 = DateUtils.strToDate((String)effTime);
            }
            if (StringUtils.isNotEmpty((CharSequence)expTime)) {
                expTime1 = DateUtils.strToDate((String)expTime);
            }
            brandDealPO.setEffTime(effTime1);
            brandDealPO.setExpTime(expTime1);
        }
        catch (Exception e) {
            LOGGER.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u9519\u8bef");
            throw new ZTBusinessException(e.getMessage());
        }
    }

    @Autowired
    public void setUccBrandDealMapper(UccBrandDealMapper uccBrandDealMapper) {
        this.uccBrandDealMapper = uccBrandDealMapper;
    }

    @Autowired
    public void setUccDictionaryAtomService(UccDictionaryAtomService uccDictionaryAtomService) {
        this.uccDictionaryAtomService = uccDictionaryAtomService;
    }

    @Autowired
    public void setUccRelCatalogBrandVendorMapper(UccRelCatalogBrandVendorMapper uccRelCatalogBrandVendorMapper) {
        this.uccRelCatalogBrandVendorMapper = uccRelCatalogBrandVendorMapper;
    }
}

