/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccCommIteminbulkforrecoveryAbilityService;
import com.tydic.commodity.common.ability.bo.UccCommIteminbulkforrecoveryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccCommIteminbulkforrecoveryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccExtStandardComBO;
import com.tydic.commodity.common.ability.bo.UccExtStandardComResultBO;
import com.tydic.commodity.common.ability.bo.UccExtStandardPrpBO;
import com.tydic.commodity.common.ability.bo.UccStandardComInfoAddAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccStandardComInfoAddAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccStandardComInfoAddBusiService;
import com.tydic.commodity.dao.UccExtRecoveryShelveGoveryRecordMapper;
import com.tydic.commodity.dao.UccQryStandardGovernLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccStandardComInfoMapper;
import com.tydic.commodity.dao.UccStandardComPropMapper;
import com.tydic.commodity.po.UccExtRecoveryShelveGoveryRecordPO;
import com.tydic.commodity.po.UccQryStandardGovernLogPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccStandardComInfoPO;
import com.tydic.commodity.po.UccStandardComPropPO;
import com.tydic.commodity.utils.ESBParamUtil;
import com.tydic.commodity.utils.HSHttpHelper;
import com.tydic.commodity.utils.HSNHttpHeader;
import com.tydic.commodity.utils.HttpRetBean;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@Transactional(propagation=Propagation.REQUIRES_NEW)
public class UccStandardComInfoAddBusiServiceImpl
implements UccStandardComInfoAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccStandardComInfoAddBusiServiceImpl.class);
    @Autowired
    private UccStandardComInfoMapper uccStandardComInfoMapper;
    @Autowired
    private UccStandardComPropMapper uccStandardComPropMapper;
    @Autowired
    private UccExtRecoveryShelveGoveryRecordMapper uccExtRecoveryShelveGoveryRecordMapper;
    @Autowired
    private UccCommIteminbulkforrecoveryAbilityService uccCommIteminbulkforrecoveryAbilityService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Value(value="${ESB_STANDARD_DETAIL_URL:${ESB_ACCESS_IP}/OSN/api/standardQryGovern/v1}")
    private String ESB_STANDARD_DETAIL_URL;
    @Autowired
    private UccQryStandardGovernLogMapper uccQryStandardGovernLogMapper;

    @Override
    public UccStandardComInfoAddAbilityRspBO dealStandardComInfoAdd(UccStandardComInfoAddAbilityReqBO reqBO) {
        Date time = new Date();
        UccStandardComInfoAddAbilityRspBO rspBO = new UccStandardComInfoAddAbilityRspBO();
        rspBO.setRespCode("0000");
        UccStandardComInfoPO comInfoPO = new UccStandardComInfoPO();
        try {
            comInfoPO.setExtStandardComId(reqBO.getStandardComId());
            comInfoPO.setDelTag(Integer.valueOf(0));
            UccStandardComInfoPO modelBy = this.uccStandardComInfoMapper.getModelBy(comInfoPO);
            UccSkuPo skuPo = this.getSkuInfo(reqBO);
            if (ObjectUtil.isEmpty((Object)skuPo)) {
                return rspBO;
            }
            if (!ObjectUtil.isEmpty((Object)modelBy)) {
                UccExtStandardComBO standardComInfo;
                if (StringUtils.isEmpty((Object)modelBy.getStandardComCode()) && !StringUtils.isEmpty((Object)(standardComInfo = this.getStandardComInfoBy(reqBO)).getSpuCode())) {
                    UccStandardComInfoPO updateStandard = new UccStandardComInfoPO();
                    updateStandard.setStandardComId(modelBy.getStandardComId());
                    updateStandard.setStandardComCode(standardComInfo.getSpuCode());
                    this.uccStandardComInfoMapper.updateById(updateStandard);
                    modelBy.setStandardComCode(standardComInfo.getSpuCode());
                }
                UccExtRecoveryShelveGoveryRecordPO recordPO = new UccExtRecoveryShelveGoveryRecordPO();
                recordPO.setSkuId(reqBO.getSkuId());
                recordPO.setStandardComId(modelBy.getStandardComId());
                recordPO.setDelTag(Integer.valueOf(0));
                recordPO.setHandleState(UccConstants.StandardReOnShelveStatus.wait);
                UccExtRecoveryShelveGoveryRecordPO mapperModelBy = this.uccExtRecoveryShelveGoveryRecordMapper.getModelBy(recordPO);
                if (!ObjectUtil.isEmpty((Object)mapperModelBy)) {
                    if (reqBO.getResult() == 1) {
                        UccCommIteminbulkforrecoveryAbilityRspBO uccCommIteminbulkforrecoveryAbilityRspBO = this.extractRestore(reqBO, mapperModelBy, skuPo);
                        UccExtRecoveryShelveGoveryRecordPO set = new UccExtRecoveryShelveGoveryRecordPO();
                        set.setRspJson(uccCommIteminbulkforrecoveryAbilityRspBO.getRespDesc());
                        set.setHandleState(UccConstants.StandardReOnShelveStatus.pass);
                        if (!"0000".equals(uccCommIteminbulkforrecoveryAbilityRspBO.getRespCode())) {
                            set.setHandleState(UccConstants.StandardReOnShelveStatus.fail);
                        }
                        set.setUpdateTime(time);
                        this.uccExtRecoveryShelveGoveryRecordMapper.updateBy(set, recordPO);
                    } else {
                        UccExtRecoveryShelveGoveryRecordPO set = new UccExtRecoveryShelveGoveryRecordPO();
                        set.setHandleState(UccConstants.StandardReOnShelveStatus.reject);
                        set.setUpdateTime(time);
                        this.uccExtRecoveryShelveGoveryRecordMapper.updateBy(set, recordPO);
                    }
                }
                UccSkuPo uccSkuPo = new UccSkuPo();
                uccSkuPo.setSkuId(reqBO.getSkuId());
                uccSkuPo.setStandardComId(modelBy.getStandardComId());
                uccSkuPo.setStandardComCode(modelBy.getStandardComCode());
                uccSkuPo.setExtStandardComId(modelBy.getExtStandardComId());
                this.uccSkuMapper.updateSkuStandard(uccSkuPo);
            } else {
                UccExtStandardComBO standardComInfo = this.getStandardComInfoBy(reqBO);
                UccStandardComInfoPO standardComInfoPO = (UccStandardComInfoPO)JSONObject.parseObject((String)JSON.toJSONString((Object)standardComInfo), UccStandardComInfoPO.class);
                standardComInfoPO.setExt1(skuPo.getCatalogCode());
                standardComInfoPO.setExt2(standardComInfo.getMaterialDesc());
                standardComInfoPO.setStandardComId(Long.valueOf(Sequence.getInstance().nextId()));
                standardComInfoPO.setDelTag(Integer.valueOf(0));
                standardComInfoPO.setMeasureName(standardComInfo.getMeasureName());
                standardComInfoPO.setCreateTime(time);
                standardComInfoPO.setCreateName("\u7cfb\u7edf");
                standardComInfoPO.setBrandName(standardComInfo.getBrandName());
                standardComInfoPO.setOnShelveCount(Integer.valueOf(0));
                standardComInfoPO.setExtStandardComId(standardComInfo.getSpuId());
                standardComInfoPO.setStandardComName(standardComInfo.getSpuName());
                standardComInfoPO.setStandardComCode(standardComInfo.getSpuCode());
                standardComInfoPO.setStandardComStatus(UccConstants.StandardStatus.OFF_SHELVE_STATE);
                standardComInfoPO.setMaterialCode(standardComInfo.getMaterialCode());
                standardComInfoPO.setMaterialName(standardComInfoPO.getMaterialName());
                standardComInfoPO.setCatalogCode(skuPo.getCatalogCode());
                standardComInfoPO.setCatalogName(skuPo.getCatalogName());
                if (!CollectionUtils.isEmpty((Collection)standardComInfo.getSkuProps())) {
                    List propPOS = standardComInfo.getSkuProps().stream().map(e -> {
                        UccStandardComPropPO standardComPropPO = (UccStandardComPropPO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccStandardComPropPO.class);
                        standardComPropPO.setStandardComId(standardComInfoPO.getStandardComId());
                        standardComPropPO.setStandardComCode(standardComInfoPO.getStandardComCode());
                        standardComPropPO.setCreateTime(time);
                        standardComPropPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                        return standardComPropPO;
                    }).collect(Collectors.toList());
                    this.uccStandardComInfoMapper.insert(standardComInfoPO);
                    this.uccStandardComPropMapper.insertBatch(propPOS);
                    UccSkuPo uccSkuPo = new UccSkuPo();
                    uccSkuPo.setSkuId(reqBO.getSkuId());
                    uccSkuPo.setStandardComId(standardComInfoPO.getStandardComId());
                    uccSkuPo.setStandardComCode(standardComInfoPO.getStandardComCode());
                    uccSkuPo.setExtStandardComId(standardComInfoPO.getExtStandardComId());
                    this.uccSkuMapper.updateSkuStandard(uccSkuPo);
                }
                rspBO.setStandardId(standardComInfoPO.getStandardComId());
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("\u5904\u7406\u5f02\u5e38 " + e2.getMessage());
        }
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private UccCommIteminbulkforrecoveryAbilityRspBO extractRestore(UccStandardComInfoAddAbilityReqBO reqBO, UccExtRecoveryShelveGoveryRecordPO mapperModelBy, UccSkuPo skuPo) {
        UccCommIteminbulkforrecoveryAbilityReqBO abilityReqBO = (UccCommIteminbulkforrecoveryAbilityReqBO)JSONObject.parseObject((String)mapperModelBy.getReqJson(), UccCommIteminbulkforrecoveryAbilityReqBO.class);
        UccBatchSkuBO skuBO = new UccBatchSkuBO();
        skuBO.setSkuId(reqBO.getSkuId());
        skuBO.setSupplierShopId(skuPo.getSupplierShopId());
        abilityReqBO.setSameLevel(Integer.valueOf(0));
        abilityReqBO.setBatchSkuList(Collections.singletonList(skuBO));
        log.info("\u6570\u636e\u6cbb\u7406\u56de\u4f20\u6062\u590d\u4e0a\u67b6\u5165\u53c2\uff1a" + JSON.toJSONString((Object)abilityReqBO));
        UccCommIteminbulkforrecoveryAbilityRspBO uccCommIteminbulkforrecoveryAbilityRspBO = new UccCommIteminbulkforrecoveryAbilityRspBO();
        try {
            uccCommIteminbulkforrecoveryAbilityRspBO = this.uccCommIteminbulkforrecoveryAbilityService.dealCommIteminbulkforrecovery(abilityReqBO);
        }
        catch (Exception e) {
            log.error("\u6062\u590d\u4e0a\u67b6\u7533\u8bf7\u5931\u8d25");
        }
        log.info("\u6570\u636e\u6cbb\u7406\u56de\u4f20\u6062\u590d\u4e0a\u67b6\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uccCommIteminbulkforrecoveryAbilityRspBO));
        return uccCommIteminbulkforrecoveryAbilityRspBO;
    }

    private UccSkuPo getSkuInfo(UccStandardComInfoAddAbilityReqBO reqBO) {
        UccSkuPo skuPo = this.uccSkuMapper.getSkuInfoByStandardAdd(reqBO.getSkuId());
        if (ObjectUtil.isEmpty((Object)skuPo)) {
            log.error("\u67e5\u8be2\u5355\u54c1\u5fc5\u8981\u6570\u636e\u5f02\u5e38,\u5df2\u5173\u8054\u5355\u54c1\u4e0d\u5b58\u5728");
        }
        return skuPo;
    }

    private UccExtStandardComBO getStandardComInfoBy(UccStandardComInfoAddAbilityReqBO reqBO) {
        String serialNumber;
        try {
            serialNumber = ESBParamUtil.getSerialNumber();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u5e8f\u5217\u53f7\u83b7\u53d6\u5931\u8d25");
        }
        JSONObject data = new JSONObject();
        data.put("serialNo", (Object)serialNumber);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("spuId", (Object)reqBO.getStandardComId());
        data.put("data", (Object)jsonObject);
        String reqStr = JSON.toJSONString((Object)data);
        HttpRetBean httpRetBean = null;
        UccQryStandardGovernLogPO standardGovernLogPO = new UccQryStandardGovernLogPO();
        standardGovernLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        standardGovernLogPO.setExtComStandardId(reqBO.getStandardComId());
        standardGovernLogPO.setType(UccConstants.StandardGovernLogType.QRY_DETAIL);
        standardGovernLogPO.setQryTime(new Date());
        standardGovernLogPO.setQryStr(reqStr);
        try {
            log.info("\u67e5\u8be2\u6807\u54c1\u5165\u53c2{}", (Object)reqStr);
            httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.ESB_STANDARD_DETAIL_URL), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            log.info("\u67e5\u8be2\u6807\u54c1\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)httpRetBean));
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u67e5\u8be2\u6570\u636e\u6cbb\u7406\u6807\u54c1\u8be6\u60c5\u5931\u8d25\uff0c\u94fe\u63a5\u672a\u54cd\u5e94");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u67e5\u8be2\u6570\u636e\u6cbb\u7406\u6807\u54c1\u8be6\u60c5\u5931\u8d25-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            if (!"0000".equals(rspJsonObject.get((Object)"respCode"))) {
                standardGovernLogPO.setStatus(Integer.valueOf(0));
            } else {
                standardGovernLogPO.setStatus(Integer.valueOf(1));
            }
            standardGovernLogPO.setRspStr(returnString);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            standardGovernLogPO.setStatus(Integer.valueOf(0));
            standardGovernLogPO.setRspStr(e.getMessage());
        }
        try {
            this.uccQryStandardGovernLogMapper.insert(standardGovernLogPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u65b0\u589e\u65e5\u5fd7\u5f02\u5e38" + e.getMessage());
        }
        UccExtStandardComResultBO uccExtStandardComResultBO = (UccExtStandardComResultBO)JSONObject.parseObject((String)httpRetBean.getStr(), UccExtStandardComResultBO.class);
        UccExtStandardComBO result = uccExtStandardComResultBO.getResult();
        if (!CollectionUtils.isEmpty((Collection)result.getSkuProps())) {
            for (UccExtStandardPrpBO skuProp : result.getSkuProps()) {
                if (!"\u8ba1\u91cf\u5355\u4f4d".equals(skuProp.getPropName())) continue;
                result.setMeasureName(skuProp.getPropValue());
                break;
            }
        }
        return result;
    }
}

