/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.common.ability.api.UccCommonAbilityService;
import com.tydic.commodity.common.ability.bo.UccPublicReqBO;
import com.tydic.commodity.common.ability.bo.UccPublicRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccCommonAbilityService"})
public class UccCommonAbilityServiceImpl
implements UccCommonAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccCommonAbilityServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    private Map<String, Long> supplierId;

    public UccCommonAbilityServiceImpl() {
        if (ObjectUtils.isEmpty(this.supplierId)) {
            this.supplierId = Stream.of({"100057", 20000L}, {"428806", 20000L}, {"437922", 20000L}, {"100056", 40000L}, {"100058", 40000L}, {"398173", 40000L}, {"437456", 40000L}, {"100060", 40000L}, {"20230900720", 40000L}, {"100055", 50000L}, {"100059", 50000L}).collect(Collectors.toMap(data -> (String)data[0], data -> (Long)data[1]));
        }
    }

    @PostMapping(value={"selectShopLimitVerify"})
    public UccPublicRspBO selectShopLimitVerify(@RequestBody UccPublicReqBO reqBO) {
        UccPublicRspBO rspBO = new UccPublicRspBO();
        ArrayList<String> str = new ArrayList<String>();
        try {
            List skuIds = (List)reqBO.getT();
            List uccSkuPos = this.uccSkuMapper.selectShopLimitVerify(skuIds);
            if (!ObjectUtils.isEmpty((Object)uccSkuPos)) {
                for (UccSkuPo po : uccSkuPos) {
                    Long price = this.supplierId.get(po.getSupplierShopId() + "");
                    if (ObjectUtils.isEmpty((Object)price) || po.getSkuPrice() <= price) continue;
                    str.add(po.getShopName() + "\u5df2\u8d85\u8fc7" + price / 10000L + "\u4e07\u5546\u54c1\u9650\u91cf");
                }
            }
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.toString());
        }
        if (str.size() > 0) {
            throw new ZTBusinessException(String.join((CharSequence)",", str));
        }
        log.info("^^^^^^^^^^^^^^^^^^^^rspBOrspBO^^{}^^^^str.sizestr.sizestr.size^{}", JSON.toJSON((Object)rspBO), (Object)str.size());
        return rspBO;
    }
}

