/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.api.SyncSceneStandardCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.bo.SyncSceneStandardCommodityToEsReqBO;
import com.tydic.commodity.common.ability.api.UccDealDataStandardUnbindAbilityService;
import com.tydic.commodity.common.ability.bo.UccDealDataStandardUnbindAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccDealDataStandardUnbindAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccDealDataStandardUnbindBusiService;
import com.tydic.commodity.common.busi.bo.UccDealDataStandardUnbindBusiReqBo;
import com.tydic.commodity.common.busi.bo.UccDealDataStandardUnbindBusiRspBo;
import com.tydic.commodity.dao.UccQryStandardGovernLogMapper;
import com.tydic.commodity.po.UccSkuPo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccDealDataStandardUnbindAbilityService"})
public class UccDealDataStandardUnbindAbilityServiceImpl
implements UccDealDataStandardUnbindAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccDealDataStandardUnbindAbilityServiceImpl.class);
    @Autowired
    private UccQryStandardGovernLogMapper uccQryStandardGovernLogMapper;
    @Autowired
    private UccDealDataStandardUnbindBusiService uccDealDataStandardUnbindBusiService;
    @Autowired
    private SyncSceneStandardCommodityToEsAtomService syncSceneStandardCommodityToEsAtomService;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;

    @PostMapping(value={"dealDataStandardUnbind"})
    public UccDealDataStandardUnbindAbilityRspBO dealDataStandardUnbind(@RequestBody UccDealDataStandardUnbindAbilityReqBO reqBO) {
        UccDealDataStandardUnbindAbilityServiceImpl.check(reqBO);
        UccDealDataStandardUnbindBusiReqBo busiReqBo = new UccDealDataStandardUnbindBusiReqBo();
        BeanUtils.copyProperties((Object)reqBO, (Object)busiReqBo);
        UccDealDataStandardUnbindBusiRspBo busiRspBo = this.uccDealDataStandardUnbindBusiService.dealDataStandardUnbind(busiReqBo);
        if (!"0000".equals(busiRspBo.getRespCode())) {
            throw new BusinessException("8888", busiRspBo.getRespDesc());
        }
        this.syncData(busiRspBo);
        UccDealDataStandardUnbindAbilityRspBO rspBO = new UccDealDataStandardUnbindAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void syncData(UccDealDataStandardUnbindBusiRspBo busiRspBo) {
        List standardComIds;
        Map<Long, List<UccSkuPo>> uccSkuMap = busiRspBo.getUccSkuPos().stream().filter(e -> e.getSupplierShopId() != null).collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        if (MapUtil.isNotEmpty(uccSkuMap)) {
            for (Long supplierShopId : uccSkuMap.keySet()) {
                List<UccSkuPo> uccSkuPos = uccSkuMap.get(supplierShopId);
                if (CollectionUtils.isEmpty(uccSkuPos)) continue;
                List skuIds = uccSkuPos.stream().map(UccSkuPo::getSkuId).filter(Objects::nonNull).collect(Collectors.toList());
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds(skuIds);
                syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                try {
                    this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
                }
                catch (Exception e2) {
                    log.error("\u540c\u6b65\u5355\u54c1\u4fe1\u606f\u5931\u8d25:{},{}", (Object)JSONObject.toJSONString((Object)syncSceneCommodityToEsReqBO), (Object)e2.getMessage());
                    throw new BusinessException("8888", "\u540c\u6b65\u5355\u54c1\u4fe1\u606f\u5931\u8d25:" + e2.getMessage());
                }
            }
        }
        if (!CollectionUtils.isEmpty(standardComIds = busiRspBo.getUccSkuPos().stream().map(UccSkuPo::getStandardComId).filter(Objects::nonNull).collect(Collectors.toList()))) {
            SyncSceneStandardCommodityToEsReqBO commodityToEsReqBO = new SyncSceneStandardCommodityToEsReqBO();
            commodityToEsReqBO.setStandardIdLList(standardComIds);
            commodityToEsReqBO.setSyncType(UccConstants.StandardSyncEsType.add);
            try {
                this.syncSceneStandardCommodityToEsAtomService.syncSceneCommodityToEs(commodityToEsReqBO);
            }
            catch (Exception e3) {
                log.error("\u540c\u6b65\u5355\u54c1\u6807\u54c1\u4fe1\u606f\u5931\u8d25\uff1a{}\uff0c{}", (Object)JSONObject.toJSONString((Object)commodityToEsReqBO), (Object)e3.getMessage());
                throw new BusinessException("8888", e3.getMessage());
            }
        }
    }

    private static void check(UccDealDataStandardUnbindAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getData() == null) {
            throw new BusinessException("8888", "\u5165\u53c2[data]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty((Collection)reqBO.getData().getSkuIds())) {
            throw new BusinessException("8888", "\u5165\u53c2[skuIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

