/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.busibase.comb.bo.SearchEsRspBo;
import com.tydic.commodity.common.ability.api.UccMaterialSearchService;
import com.tydic.commodity.common.ability.bo.DycSyncMaterialEsBo;
import com.tydic.commodity.common.ability.bo.UccMaterialSearchReqBo;
import com.tydic.commodity.common.ability.bo.UccMaterialSearchRspBo;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class UccMaterialSearchServiceImpl
implements UccMaterialSearchService {
    private static final Logger log = LoggerFactory.getLogger(UccMaterialSearchServiceImpl.class);
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Value(value="${GENERAL_MATERIAL_CODE:000000}")
    private String generalMaterialCode;

    public UccMaterialSearchRspBo searchMaterial(UccMaterialSearchReqBo reqBo) {
        UccMaterialSearchRspBo uccMaterialSearchRspBo = this.excuteSql(this.buildEsQuerySql(reqBo), new Page(reqBo.getPageNo(), reqBo.getPageSize()));
        uccMaterialSearchRspBo.setPageNo(reqBo.getPageNo());
        int size = reqBo.getPageSize();
        int totalPage = 0;
        int add = 0;
        totalPage = uccMaterialSearchRspBo.getRecordsTotal() / size;
        add = uccMaterialSearchRspBo.getRecordsTotal() % size == 0 ? 0 : 1;
        uccMaterialSearchRspBo.setRespCode("0000");
        uccMaterialSearchRspBo.setRespDesc("\u6210\u529f");
        uccMaterialSearchRspBo.setTotal(totalPage + add);
        return uccMaterialSearchRspBo;
    }

    private BoolQueryBuilder buildEsQuerySql(UccMaterialSearchReqBo reqBo) {
        WildcardQueryBuilder queryBuilder1;
        BoolQueryBuilder extBoolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((Object)reqBo.getQryString())) {
            BoolQueryBuilder inMust = QueryBuilders.boolQuery();
            WildcardQueryBuilder queryBuilder12 = QueryBuilders.wildcardQuery((String)"materialName.keyword", (String)("*" + reqBo.getQryString() + "*"));
            WildcardQueryBuilder queryBuilder2 = QueryBuilders.wildcardQuery((String)"longDesc.keyword", (String)("*" + reqBo.getQryString() + "*"));
            WildcardQueryBuilder queryBuilder3 = QueryBuilders.wildcardQuery((String)"model.keyword", (String)("*" + reqBo.getQryString() + "*"));
            WildcardQueryBuilder queryBuilder4 = QueryBuilders.wildcardQuery((String)"materialCode.keyword", (String)("*" + reqBo.getQryString() + "*"));
            extBoolQueryBuilder.must((QueryBuilder)inMust.should((QueryBuilder)queryBuilder12).should((QueryBuilder)queryBuilder2).should((QueryBuilder)queryBuilder3).should((QueryBuilder)queryBuilder4));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getMaterialCodesPenetrate())) {
            BoolQueryBuilder categoryCodeBuilder2 = QueryBuilders.boolQuery();
            for (String materialPermission : reqBo.getMaterialCodesPenetrate()) {
                WildcardQueryBuilder queryBuilder13 = QueryBuilders.wildcardQuery((String)"catalogCode.keyword", (String)(materialPermission + "*"));
                categoryCodeBuilder2.should((QueryBuilder)queryBuilder13);
            }
            extBoolQueryBuilder.should((QueryBuilder)categoryCodeBuilder2);
        }
        if (reqBo.getIsQryGeneralMaterialCodeFlag() != null && reqBo.getIsQryGeneralMaterialCodeFlag() == 1) {
            queryBuilder1 = QueryBuilders.wildcardQuery((String)"materialCode.keyword", (String)("*" + this.generalMaterialCode));
            extBoolQueryBuilder.must((QueryBuilder)queryBuilder1);
        }
        if (reqBo.getIsExcludeGeneral() != null && reqBo.getIsExcludeGeneral() == 1) {
            queryBuilder1 = QueryBuilders.wildcardQuery((String)"materialCode.keyword", (String)("*" + this.generalMaterialCode));
            extBoolQueryBuilder.mustNot((QueryBuilder)queryBuilder1);
        }
        if (reqBo.getCatalogId() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"catalogId", (Object)reqBo.getCatalogId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCatalogCode())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"catalogCode", (String)reqBo.getCatalogCode()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getMaterialIds())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"materialId", (Collection)reqBo.getMaterialIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getErpCodes())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"erpCodes.keyword", (Collection)reqBo.getErpCodes()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialCode())) {
            if (!CollectionUtils.isEmpty((Collection)reqBo.getLikeFields()) && reqBo.getLikeFields().contains("materialCode")) {
                queryBuilder1 = QueryBuilders.wildcardQuery((String)"materialCode.keyword", (String)("*" + reqBo.getMaterialCode() + "*"));
                extBoolQueryBuilder.must((QueryBuilder)queryBuilder1);
            } else {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"materialCode.keyword", (String)reqBo.getMaterialCode()));
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialName())) {
            if (!CollectionUtils.isEmpty((Collection)reqBo.getLikeFields()) && reqBo.getLikeFields().contains("materialName")) {
                queryBuilder1 = QueryBuilders.wildcardQuery((String)"materialName.keyword", (String)("*" + reqBo.getMaterialName() + "*"));
                extBoolQueryBuilder.must((QueryBuilder)queryBuilder1);
            } else {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"materialName.keyword", (String)reqBo.getMaterialName()));
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSpec())) {
            if (!CollectionUtils.isEmpty((Collection)reqBo.getLikeFields()) && reqBo.getLikeFields().contains("spec")) {
                queryBuilder1 = QueryBuilders.wildcardQuery((String)"spec.keyword", (String)("*" + reqBo.getSpec() + "*"));
                extBoolQueryBuilder.must((QueryBuilder)queryBuilder1);
            } else {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"spec.keyword", (String)reqBo.getSpec()));
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getModel())) {
            if (!CollectionUtils.isEmpty((Collection)reqBo.getLikeFields()) && reqBo.getLikeFields().contains("model")) {
                queryBuilder1 = QueryBuilders.wildcardQuery((String)"model.keyword", (String)("*" + reqBo.getModel() + "*"));
                extBoolQueryBuilder.must((QueryBuilder)queryBuilder1);
            } else {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"model", (String)reqBo.getModel()));
            }
        }
        if (reqBo.getIsDelete() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"isDelete", (Object)reqBo.getIsDelete()));
        }
        if (reqBo.getFreezeFlag() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"freezeFlag", (Object)reqBo.getFreezeFlag()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getMaterialCodes())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"materialCode.keyword", (Collection)reqBo.getMaterialCodes()));
        }
        if (!ObjectUtils.isEmpty((Object)reqBo.getIsAll()) && reqBo.getIsAll().equals(1)) {
            extBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.wildcardQuery((String)"materialCode.keyword", (String)"*000000"));
        }
        return extBoolQueryBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UccMaterialSearchRspBo excuteSql(BoolQueryBuilder boolQueryBuilder, Page page) {
        UccMaterialSearchRspBo rspBo = new UccMaterialSearchRspBo();
        String endPoint = "/" + this.esConfig.getMaterialIndexName() + "/" + this.esConfig.getMaterialEsType() + "/_search";
        String queryString = this.getQueryString(boolQueryBuilder, page);
        log.info("source---->" + queryString);
        try (NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);){
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("result---->" + result);
            List<DycSyncMaterialEsBo> dycSyncMaterialEsBos = this.dealSearchData(result);
            String agss = JSONObject.parseObject((String)result).get((Object)"aggregations").toString();
            JSONObject resultObj = JSONObject.parseObject((String)result);
            JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
            Integer total = hitsObj.getInteger("total");
            rspBo.setRecordsTotal(total.intValue());
            rspBo.setRows(dycSyncMaterialEsBos);
            UccMaterialSearchRspBo uccMaterialSearchRspBo = rspBo;
            return uccMaterialSearchRspBo;
        }
        return rspBo;
    }

    private String getQueryString(BoolQueryBuilder boolQueryBuilder, Page page) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)page.getPageSize());
        queryJson.put("from", (Object)(page.getPageSize() * (page.getPageNo() - 1)));
        String queryString = null;
        queryString = boolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(SortOrder.DESC);
        queryJson.put("sort", (Object)JSONObject.parseObject((String)sortQuery.toString()));
        JSONObject collapse = new JSONObject();
        collapse.put("field", (Object)"materialId");
        queryJson.put("collapse", (Object)collapse);
        JSONObject aggs = new JSONObject();
        JSONObject total = new JSONObject();
        total.put("field", (Object)"materialId");
        JSONObject cardinality = new JSONObject();
        total.put("precision_threshold", (Object)40000);
        cardinality.put("cardinality", (Object)total);
        aggs.put("books_count", (Object)cardinality);
        queryJson.put("aggs", (Object)aggs);
        return queryJson.toString();
    }

    private List<DycSyncMaterialEsBo> dealSearchData(String result) {
        SearchEsRspBo rspBo = new SearchEsRspBo();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        log.info("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        ArrayList<DycSyncMaterialEsBo> dycSyncMaterialEsBos = new ArrayList<DycSyncMaterialEsBo>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                DycSyncMaterialEsBo dycSyncMaterialEsBo = new DycSyncMaterialEsBo();
                try {
                    dycSyncMaterialEsBo = (DycSyncMaterialEsBo)JSON.toJavaObject((JSON)data, DycSyncMaterialEsBo.class);
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                }
                dycSyncMaterialEsBos.add(dycSyncMaterialEsBo);
            }
        }
        return dycSyncMaterialEsBos;
    }
}

