/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.Brand;
import com.tydic.commodity.common.ability.api.UccQryBrandRelApprovePageListAbilityService;
import com.tydic.commodity.common.ability.bo.UccBrandRelApproveBo;
import com.tydic.commodity.common.ability.bo.UccBrandRelCatalogLevelBO;
import com.tydic.commodity.common.ability.bo.UccQryBrandRelApprovePageListAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccQryBrandRelApprovePageListAbilityRspBo;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccBrandRelApproveMapper;
import com.tydic.commodity.po.UccBrandRelApprovePO;
import com.tydic.commodity.po.UccBrandRelCatalogLevelPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccQryBrandRelApprovePageListAbilityService"})
public class UccQryBrandRelApprovePageListAbilityServiceImpl
implements UccQryBrandRelApprovePageListAbilityService {
    public static final Integer TO_BE_CONFIRMED = 1;
    public static final Integer REJECT = 2;
    public static final Integer CONFIRMED = 3;
    @Autowired
    private UccBrandRelApproveMapper uccBrandRelApproveMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;

    @PostMapping(value={"qryBrandRelApprovePageList"})
    public UccQryBrandRelApprovePageListAbilityRspBo qryBrandRelApprovePageList(@RequestBody UccQryBrandRelApprovePageListAbilityReqBo reqBo) {
        ArrayList<Integer> approveStatusList = new ArrayList<Integer>();
        if (TO_BE_CONFIRMED.equals(reqBo.getTabId()) || REJECT.equals(reqBo.getTabId())) {
            approveStatusList.add(UccConstants.UccBrandRelApproveStatus.TO_BE_CONFIRMED);
            approveStatusList.add(UccConstants.UccBrandRelApproveStatus.APPROVAL_REJECTED);
        } else if (CONFIRMED.equals(reqBo.getTabId())) {
            approveStatusList.add(UccConstants.UccBrandRelApproveStatus.CONFIRMED_APPROVED);
            approveStatusList.add(UccConstants.UccBrandRelApproveStatus.APPROVAL_PASS);
            approveStatusList.add(UccConstants.UccBrandRelApproveStatus.CONFIRM_REJECTION);
        }
        UccBrandRelApprovePO qryUccBrandRelApprovePo = new UccBrandRelApprovePO();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryUccBrandRelApprovePo);
        qryUccBrandRelApprovePo.setApproveStatusList(approveStatusList);
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        List uccBrandRelApprovePos = this.uccBrandRelApproveMapper.getListPage(qryUccBrandRelApprovePo, page);
        if (CollectionUtils.isEmpty((Collection)uccBrandRelApprovePos)) {
            UccQryBrandRelApprovePageListAbilityRspBo rspBo = new UccQryBrandRelApprovePageListAbilityRspBo();
            rspBo.setPageNo(reqBo.getPageNo());
            rspBo.setRecordsTotal(page.getTotalCount());
            rspBo.setTotal(page.getTotalPages());
            rspBo.setRows(new ArrayList(0));
            return rspBo;
        }
        List uccBrandRelApproveBos = JSONObject.parseArray((String)JSONObject.toJSONString((Object)uccBrandRelApprovePos), UccBrandRelApproveBo.class);
        this.translation(uccBrandRelApproveBos);
        UccQryBrandRelApprovePageListAbilityRspBo rspBo = new UccQryBrandRelApprovePageListAbilityRspBo();
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRows(uccBrandRelApproveBos);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void translation(List<UccBrandRelApproveBo> uccBrandRelApproveBos) {
        Map<String, String> brandStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap(Brand.BRAND_STATUS.toString());
        Map<String, String> approveStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap(Brand.UCC_BRAND_REL_APPROVE_STATUS_DIC.toString());
        Map<Long, List<UccBrandRelCatalogLevelPo>> brandRelMap = this.collectRelCatalogInfo(uccBrandRelApproveBos);
        for (UccBrandRelApproveBo each : uccBrandRelApproveBos) {
            if (!MapUtil.isEmpty(brandRelMap) && brandRelMap.containsKey(each.getBrandId())) {
                each.setCatalogLevelBOS(JSON.parseArray((String)JSON.toJSONString(brandRelMap.get(each.getBrandId())), UccBrandRelCatalogLevelBO.class));
                each.setCatalogLevelSplitStr(each.getCatalogLevelBOS().stream().map(UccBrandRelCatalogLevelBO::getCatalogLevelNameStr).collect(Collectors.joining(",")));
            }
            if (brandStatusMap != null && each.getBrandStatus() != null && brandStatusMap.containsKey(each.getBrandStatus().toString())) {
                each.setBrandStatusStr(brandStatusMap.get(each.getBrandStatus().toString()));
            }
            if (approveStatusMap == null || each.getApproveStatus() == null || !approveStatusMap.containsKey(each.getApproveStatus().toString())) continue;
            each.setApproveStatusStr(approveStatusMap.get(each.getApproveStatus().toString()));
        }
    }

    private Map<Long, List<UccBrandRelCatalogLevelPo>> collectRelCatalogInfo(List<UccBrandRelApproveBo> getMallBrandDetailGroupList) {
        List brandIds = getMallBrandDetailGroupList.stream().map(UccBrandRelApproveBo::getBrandId).collect(Collectors.toList());
        List catalogLevelList = this.uccBrandDealMapper.queryCatalogTreeList(brandIds);
        if (!CollectionUtils.isEmpty((Collection)catalogLevelList)) {
            return catalogLevelList.stream().collect(Collectors.groupingBy(UccBrandRelCatalogLevelPo::getBrandId));
        }
        return null;
    }
}

