/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.SmartContainerUserBO;
import com.tydic.commodity.common.ability.bo.SmartContainerUserReqBO;
import com.tydic.commodity.common.ability.bo.SmartContainerUserRspBO;
import com.tydic.commodity.common.busi.api.SmartContainerUserBusiService;
import com.tydic.commodity.common.external.util.BatchImportUtils;
import com.tydic.commodity.dao.SmartContainerImportMapper;
import com.tydic.commodity.dao.SmartContainerUserMapper;
import com.tydic.commodity.po.SmartContainerImportPO;
import com.tydic.commodity.po.SmartContainerUserPO;
import com.tydic.umc.general.ability.api.UmcDycMemberQryListPageAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycMemberBO;
import com.tydic.umc.general.ability.bo.UmcDycMemberQryListPageAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDycMemberQryListPageAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SmartContainerUserBusiServiceImpl
implements SmartContainerUserBusiService {
    private static final Logger log = LoggerFactory.getLogger(SmartContainerUserBusiServiceImpl.class);
    @Autowired
    private SmartContainerUserMapper smartContainerUserMapper;
    @Autowired
    private SmartContainerImportMapper smartContainerImportMapper;
    @Autowired
    private UmcDycMemberQryListPageAbilityService umcDycMemberQryListPageAbilityService;

    @Override
    public SmartContainerUserRspBO qryScUserList(SmartContainerUserReqBO reqBO) {
        SmartContainerUserPO containerUserPO = new SmartContainerUserPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)containerUserPO);
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo());
        page.setPageSize(reqBO.getPageSize());
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getPageSize() * (reqBO.getPageNo() - 1));
        List list = this.smartContainerUserMapper.getListPage(containerUserPO, page);
        SmartContainerUserRspBO rspBO = new SmartContainerUserRspBO();
        if (CollectionUtils.isEmpty((Collection)list)) {
            rspBO.setTotal(0);
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(0);
            rspBO.setRows(new ArrayList());
        } else {
            int i = 1;
            ArrayList<SmartContainerUserBO> rows = new ArrayList<SmartContainerUserBO>();
            for (SmartContainerUserPO containerPO : list) {
                SmartContainerUserBO bo = new SmartContainerUserBO();
                BeanUtils.copyProperties((Object)containerPO, (Object)bo);
                bo.setOrder(Integer.valueOf(reqBO.getPageSize() * (reqBO.getPageNo() - 1) + i));
                ++i;
                bo.setStateStr(bo.getState() == 1 ? "\u542f\u7528" : "\u505c\u7528");
                rows.add(bo);
            }
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRows(rows);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public SmartContainerUserRspBO dealAddScUser(SmartContainerUserReqBO reqBO) {
        SmartContainerUserRspBO rspBO = new SmartContainerUserRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ArrayList<SmartContainerUserPO> list = new ArrayList<SmartContainerUserPO>();
        for (SmartContainerUserBO smartContainerUserBO : reqBO.getUserList()) {
            Long id = Sequence.getInstance().nextId();
            SmartContainerUserPO containerUserPO = new SmartContainerUserPO();
            BeanUtils.copyProperties((Object)smartContainerUserBO, (Object)containerUserPO);
            containerUserPO.setId(id);
            containerUserPO.setScId(reqBO.getScId());
            containerUserPO.setCreateName(reqBO.getName());
            containerUserPO.setCreateTime(new Date());
            containerUserPO.setCreateUserId(reqBO.getUserId() + "");
            containerUserPO.setCreateUserName(reqBO.getUsername());
            containerUserPO.setUpdateName(reqBO.getName());
            containerUserPO.setUpdateTime(new Date());
            containerUserPO.setUpdateUserId(reqBO.getUserId() + "");
            containerUserPO.setUpdateUserName(reqBO.getUsername());
            containerUserPO.setState(Integer.valueOf(1));
            list.add(containerUserPO);
        }
        this.smartContainerUserMapper.insertBatch(list);
        return rspBO;
    }

    @Override
    public SmartContainerUserRspBO dealUpdateUser(SmartContainerUserReqBO reqBO) {
        if (reqBO.getId() == null) {
            throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u5165\u53c2ID");
        }
        SmartContainerUserRspBO rspBO = new SmartContainerUserRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        SmartContainerUserPO userPO = new SmartContainerUserPO();
        userPO.setId(reqBO.getId());
        userPO.setState(reqBO.getState());
        userPO.setUpdateUserName(reqBO.getUsername());
        userPO.setUpdateUserId(reqBO.getUserId() + "");
        userPO.setUpdateName(reqBO.getName());
        userPO.setUpdateTime(new Date());
        this.smartContainerUserMapper.update(userPO);
        return rspBO;
    }

    @Override
    public SmartContainerUserRspBO dealImportSmartUser(SmartContainerUserReqBO reqBO) {
        List<Map<String, Object>> importDataMap;
        SmartContainerUserRspBO rspBO = new SmartContainerUserRspBO();
        ArrayList<String> title = new ArrayList<String>();
        title.add("\u4e3b\u952eID");
        title.add("\u5458\u5de5\u7f16\u53f7");
        title.add("\u59d3\u540d");
        title.add("\u505c\u7528/\u542f\u7528");
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            BatchImportUtils<SmartContainerUserBO> batchImportUtils = new BatchImportUtils<SmartContainerUserBO>(title, data, SmartContainerUserBO.class);
            batchImportUtils.batchImport(reqBO.getUrl(), 0, 1, -1);
            importDataMap = batchImportUtils.getImportDataMaps();
        }
        catch (Exception e) {
            log.error("\u5217\u8868\u5bfc\u5165\u5931\u8d25\uff1a" + e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.toString());
            return rspBO;
        }
        if (CollectionUtils.isEmpty(importDataMap)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a");
            return rspBO;
        }
        ArrayList<Object> insertImp = new ArrayList<Object>();
        ArrayList<SmartContainerUserPO> insertUser = new ArrayList<SmartContainerUserPO>();
        Long tempId = Sequence.getInstance().nextId();
        rspBO.setTempId(tempId);
        List list = JSONArray.parseArray((String)JSON.toJSONString(importDataMap), SmartContainerUserBO.class);
        System.out.printf("\u5bfc\u5165\u6570\u636e" + JSON.toJSONString((Object)list), new Object[0]);
        ArrayList<String> codes = new ArrayList<String>();
        for (SmartContainerUserBO bo : list) {
            if (bo.getId() != null) {
                SmartContainerImportPO importPO = new SmartContainerImportPO();
                importPO.setImportType(Integer.valueOf(2));
                importPO.setCreateUserId(reqBO.getUserId() + "");
                importPO.setScId(reqBO.getScId());
                importPO.setCreateName(reqBO.getCreateName());
                importPO.setCreateUserName(reqBO.getUsername());
                importPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                importPO.setWorkNo(bo.getWorkNo());
                importPO.setWorkName(bo.getCreateName());
                importPO.setCreateTime(new Date());
                importPO.setState(Integer.valueOf(1));
                importPO.setTempId(tempId);
                insertImp.add(importPO);
                SmartContainerUserPO catalogPO = new SmartContainerUserPO();
                catalogPO.setId(bo.getId());
                if (StringUtils.isNotBlank((CharSequence)bo.getStateStr())) {
                    if ("\u505c\u7528".equals(bo.getStateStr())) {
                        catalogPO.setState(Integer.valueOf(0));
                    } else {
                        catalogPO.setState(Integer.valueOf(1));
                    }
                } else {
                    catalogPO.setState(Integer.valueOf(1));
                }
                catalogPO.setUpdateTime(new Date());
                catalogPO.setUpdateName(reqBO.getName());
                catalogPO.setUpdateUserId(reqBO.getUserId() + "");
                catalogPO.setUpdateUserName(reqBO.getUsername());
                this.smartContainerUserMapper.update(catalogPO);
                continue;
            }
            codes.add(bo.getWorkNo());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty(codes)) {
            if (insertImp.size() > 0) {
                this.smartContainerImportMapper.insertBatch(insertImp);
            }
            return rspBO;
        }
        UmcDycMemberQryListPageAbilityReqBO abilityReqBO = new UmcDycMemberQryListPageAbilityReqBO();
        abilityReqBO.setRegAccounts(codes);
        UmcDycMemberQryListPageAbilityRspBO pageAbilityRspBO = this.umcDycMemberQryListPageAbilityService.qryMemberByRegAccount(abilityReqBO);
        if (CollectionUtils.isEmpty((Collection)pageAbilityRspBO.getRows())) {
            for (SmartContainerUserBO bo : list) {
                SmartContainerImportPO importPO = new SmartContainerImportPO();
                importPO.setImportType(Integer.valueOf(2));
                importPO.setCreateUserId(reqBO.getUserId() + "");
                importPO.setScId(reqBO.getScId());
                importPO.setCreateName(reqBO.getCreateName());
                importPO.setCreateUserName(reqBO.getUsername());
                importPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                importPO.setWorkNo(bo.getWorkNo());
                importPO.setWorkName(bo.getCreateName());
                importPO.setCreateTime(new Date());
                importPO.setState(Integer.valueOf(0));
                importPO.setFailCentent("\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
                importPO.setTempId(tempId);
                insertImp.add(importPO);
            }
        } else {
            Map<String, UmcDycMemberBO> map = pageAbilityRspBO.getRows().stream().collect(Collectors.toMap(UmcDycMemberBO::getRegAccount, i -> i));
            for (SmartContainerUserBO bo : list) {
                System.out.printf("\u7528\u6237" + bo.getCreateName(), new Object[0]);
                if (bo.getId() != null) continue;
                UmcDycMemberBO umcDycMemberBO = map.get(bo.getWorkNo());
                SmartContainerImportPO importPO = new SmartContainerImportPO();
                importPO.setImportType(Integer.valueOf(2));
                importPO.setScId(reqBO.getScId());
                importPO.setCreateUserId(reqBO.getUserId() + "");
                importPO.setCreateName(reqBO.getCreateName());
                importPO.setCreateUserName(reqBO.getUsername());
                importPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                importPO.setWorkName(bo.getCreateName());
                importPO.setWorkNo(bo.getWorkNo());
                importPO.setCreateTime(new Date());
                importPO.setTempId(tempId);
                if (umcDycMemberBO == null) {
                    importPO.setState(Integer.valueOf(0));
                    importPO.setFailCentent("\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
                    insertImp.add(importPO);
                    continue;
                }
                if (!umcDycMemberBO.getMemName2().equals(bo.getCreateName())) {
                    importPO.setState(Integer.valueOf(0));
                    importPO.setFailCentent("\u5458\u5de5\u7f16\u7801\u548c\u59d3\u540d\u4e0d\u5339\u914d");
                    insertImp.add(importPO);
                    continue;
                }
                importPO.setState(Integer.valueOf(1));
                insertImp.add(importPO);
                SmartContainerUserPO containerUserPO = new SmartContainerUserPO();
                containerUserPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                containerUserPO.setScId(reqBO.getScId());
                containerUserPO.setCreateName(reqBO.getName());
                containerUserPO.setCreateTime(new Date());
                containerUserPO.setCreateUserId(reqBO.getUserId() + "");
                containerUserPO.setCreateUserName(reqBO.getUsername());
                containerUserPO.setUpdateName(reqBO.getName());
                containerUserPO.setUpdateTime(new Date());
                containerUserPO.setUpdateUserId(reqBO.getUserId() + "");
                containerUserPO.setUpdateUserName(reqBO.getUsername());
                if ("\u505c\u7528".equals(bo.getStateStr())) {
                    containerUserPO.setState(Integer.valueOf(0));
                } else {
                    containerUserPO.setState(Integer.valueOf(1));
                }
                containerUserPO.setWorkId(umcDycMemberBO.getMemId() + "");
                containerUserPO.setWorkNo(umcDycMemberBO.getRegAccount());
                containerUserPO.setWorkName(umcDycMemberBO.getMemName2());
                containerUserPO.setMobile(umcDycMemberBO.getRegMobile());
                containerUserPO.setWorkOrgCode(umcDycMemberBO.getOrgCode());
                containerUserPO.setWorkOrgName(umcDycMemberBO.getOrgName());
                insertUser.add(containerUserPO);
            }
        }
        if (insertImp.size() > 0) {
            this.smartContainerImportMapper.insertBatch(insertImp);
        }
        if (insertUser.size() > 0) {
            this.smartContainerUserMapper.insertBatch(insertUser);
        }
        return rspBO;
    }

    public static void main(String[] args) throws Exception {
        List<Map<String, Object>> importDataMap;
        ArrayList<String> title = new ArrayList<String>();
        title.add("\u4e3b\u952eID");
        title.add("\u5458\u5de5\u7f16\u53f7");
        title.add("\u59d3\u540d");
        title.add("\u505c\u7528/\u542f\u7528");
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            BatchImportUtils<SmartContainerUserBO> batchImportUtils = new BatchImportUtils<SmartContainerUserBO>(title, data, SmartContainerUserBO.class);
            batchImportUtils.batchImport("http://172.16.8.99/group1/M00/01/4E/rBAIUWSK0gqAbhMWAAAi5hlmqCc24.xlsx", 0, 1, -1);
            importDataMap = batchImportUtils.getImportDataMaps();
        }
        catch (Exception e) {
            log.error("\u5217\u8868\u5bfc\u5165\u5931\u8d25\uff1a" + e);
            return;
        }
        if (CollectionUtils.isEmpty(importDataMap)) {
            return;
        }
        ArrayList insertImp = new ArrayList();
        ArrayList insertUser = new ArrayList();
        List list = JSONArray.parseArray((String)JSON.toJSONString(importDataMap), SmartContainerUserBO.class);
        ArrayList codes = new ArrayList();
    }
}

