/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccSkuOperationLogRecordAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityBO;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityReqBO;
import com.tydic.commodity.common.busi.api.UccDealDataStandardUnbindBusiService;
import com.tydic.commodity.common.busi.bo.UccDealDataStandardUnbindBusiReqBo;
import com.tydic.commodity.common.busi.bo.UccDealDataStandardUnbindBusiRspBo;
import com.tydic.commodity.dao.SkuDataGovernPriceMapper;
import com.tydic.commodity.dao.SkuDataGovernSamePriceMapper;
import com.tydic.commodity.dao.UccExtRecoveryShelveGoveryRecordMapper;
import com.tydic.commodity.dao.UccSkuLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.SkuDataGovernPricePO;
import com.tydic.commodity.po.SkuDataGovernSamePricePO;
import com.tydic.commodity.po.UccExtRecoveryShelveGoveryRecordPO;
import com.tydic.commodity.po.UccSkuLogPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.task.TaskTodoWaitService;
import com.tydic.commodity.task.bo.TodoUccWaitAbilityReqBO;
import com.tydic.uac.ability.UacNoTaskAuditCancelAbilityService;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelRspBO;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccDealDataStandardUnbindBusiServiceImpl
implements UccDealDataStandardUnbindBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccDealDataStandardUnbindBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuLogMapper uccSkuLogMapper;
    @Autowired
    private UccSkuOperationLogRecordAbilityService uccSkuOperationLogRecordAbilityService;
    @Autowired
    private UacNoTaskAuditCancelAbilityService uacNoTaskAuditCancelAbilityService;
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private SkuDataGovernPriceMapper skuDataGovernPriceMapper;
    @Autowired
    private SkuDataGovernSamePriceMapper skuDataGovernSamePriceMapper;
    @Autowired
    private UccExtRecoveryShelveGoveryRecordMapper uccExtRecoveryShelveGoveryRecordMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();

    @Override
    public UccDealDataStandardUnbindBusiRspBo dealDataStandardUnbind(UccDealDataStandardUnbindBusiReqBo reqBo) {
        List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(reqBo.getData().getSkuIds());
        if (CollectionUtil.isEmpty((Collection)uccSkuPos)) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5355\u54c1\u4fe1\u606f");
        }
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSkuStatus(SkuStatusEnum.DATA_GOVERN.getStatus());
        uccSkuPo.setSkuIds(reqBo.getData().getSkuIds());
        uccSkuPo.setUpdateTime(new Date());
        uccSkuPo.setUpdateOperName("\u7cfb\u7edf");
        try {
            int n = this.uccSkuMapper.updateDataStandardUnbindSku(uccSkuPo);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5355\u54c1\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new BusinessException("8888", "\u4fee\u6539\u5355\u54c1\u4fe1\u606f\u5931\u8d25:" + e.getMessage());
        }
        UccExtRecoveryShelveGoveryRecordPO UccExtRecoveryShelveGoveryRecordPoSet = new UccExtRecoveryShelveGoveryRecordPO();
        UccExtRecoveryShelveGoveryRecordPoSet.setDelTag(Integer.valueOf(1));
        UccExtRecoveryShelveGoveryRecordPO UccExtRecoveryShelveGoveryRecordPoWhere = new UccExtRecoveryShelveGoveryRecordPO();
        UccExtRecoveryShelveGoveryRecordPoWhere.setSkuIds(reqBo.getData().getSkuIds());
        this.uccExtRecoveryShelveGoveryRecordMapper.updateBy(UccExtRecoveryShelveGoveryRecordPoSet, UccExtRecoveryShelveGoveryRecordPoWhere);
        SkuDataGovernPricePO priceDeletePo = new SkuDataGovernPricePO();
        priceDeletePo.setSkuIds(reqBo.getData().getSkuIds());
        this.skuDataGovernPriceMapper.deleteBy(priceDeletePo);
        SkuDataGovernSamePricePO somePriceDeletePo = new SkuDataGovernSamePricePO();
        somePriceDeletePo.setSkuIds(reqBo.getData().getSkuIds());
        this.skuDataGovernSamePriceMapper.deleteBy(somePriceDeletePo);
        this.dealElcSku(uccSkuPos);
        this.processUpdateSkuAndLog(uccSkuPos);
        UccDealDataStandardUnbindBusiRspBo rspBo = new UccDealDataStandardUnbindBusiRspBo();
        rspBo.setUccSkuPos(uccSkuPos);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void dealElcSku(List<UccSkuPo> uccSkuPos) {
        try {
            for (UccSkuPo uccSkuPo : uccSkuPos) {
                if (uccSkuPo.getApprovalStatus() == null) continue;
                switch (uccSkuPo.getApprovalStatus()) {
                    case 21: {
                        this.cancelWaitDone(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF, "2012", "\u7533\u8bf7\u4e0a\u67b6\u5f85\u5ba1\u6279");
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF);
                        break;
                    }
                    case 31: {
                        this.cancelWaitDone(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF, "2008", "\u65e0\u534f\u8bae\u5546\u54c1\u7f16\u8f91");
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_EDIT);
                        break;
                    }
                    case 41: {
                        this.cancelWaitDone(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF, "2002", "\u7535\u5546\u5546\u54c1\u4e0b\u67b6");
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN);
                        break;
                    }
                    case 51: {
                        this.cancelWaitDone(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF, "2003", "\u7535\u5546\u5546\u54c1\u6062\u590d\u4e0a\u67b6");
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_RECOVER);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88\u5f85\u529e\u548c\u5ba1\u6279\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    private void cancelWaitDone(Long skuId, Integer objType, String busiCode, String busiName) {
        try {
            UacQryAuditLogReqBO reqStationBO = new UacQryAuditLogReqBO();
            reqStationBO.setObjType(objType);
            reqStationBO.setObjId(skuId + "");
            UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLastLog(reqStationBO);
            if (!"0000".equals(uacQryAuditLogRspBO.getRespCode())) {
                throw new BusinessException("8888", "\u67e5\u8be2\u5f85\u529e\u4e0b\u4e00\u5ba1\u6279\u4eba\u5c97\u4f4d\u4e3a\u7a7a\uff01");
            }
            try {
                TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO = new TodoUccWaitAbilityReqBO();
                todoUccWaitAbilityReqBO.setBusiCode(busiCode);
                todoUccWaitAbilityReqBO.setBusiName(busiName);
                todoUccWaitAbilityReqBO.setCenterCode("commodity");
                todoUccWaitAbilityReqBO.setOperatorType("2");
                todoUccWaitAbilityReqBO.setObjId(skuId);
                todoUccWaitAbilityReqBO.setStationId(uacQryAuditLogRspBO.getLogInfo().getNextStationId());
                this.taskTodoWaitService.productApplyHandler(todoUccWaitAbilityReqBO);
            }
            catch (Exception e) {
                log.error("taskTodoWaitService error:{}", (Throwable)e);
            }
        }
        catch (Exception ex) {
            log.error("\u6570\u636e\u6cbb\u7406\u89e3\u7ed1\u53d6\u6d88\u5f85\u529e\u5931\u8d25\uff1a" + ex.getMessage());
        }
    }

    private void cancelAudit(Long skuId, Integer objType) {
        try {
            UacNoTaskAuditCancelReqBO uacNoTaskAuditCancelReqBO = new UacNoTaskAuditCancelReqBO();
            uacNoTaskAuditCancelReqBO.setObjId(skuId.toString());
            uacNoTaskAuditCancelReqBO.setObjType(objType);
            uacNoTaskAuditCancelReqBO.setOperDept("sys-mgc");
            uacNoTaskAuditCancelReqBO.setOperId("sys-mgc");
            uacNoTaskAuditCancelReqBO.setCancelOperId("sys-mgc");
            uacNoTaskAuditCancelReqBO.setCancelReason("\u6807\u54c1\u89e3\u7ed1\u53d6\u6d88");
            UacNoTaskAuditCancelRspBO uacNoTaskAuditCancelRspBO = this.uacNoTaskAuditCancelAbilityService.auditCancel(uacNoTaskAuditCancelReqBO);
            if ("0000".equals(uacNoTaskAuditCancelRspBO.getRespCode())) {
                throw new BusinessException("8888", uacNoTaskAuditCancelRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u6cbb\u7406\u89e3\u7ed1\u53d6\u6d88\u5ba1\u6279\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private void processUpdateSkuAndLog(List<UccSkuPo> uccSkuPos) {
        ArrayList<UccSkuLogPo> uccSkuLogPos = new ArrayList<UccSkuLogPo>();
        ArrayList<UccSkuOperationLogRecordAbilityBO> recordAbilityBOS = new ArrayList<UccSkuOperationLogRecordAbilityBO>();
        for (UccSkuPo each : uccSkuPos) {
            UccSkuLogPo uccSkuLogPo = new UccSkuLogPo();
            BeanUtils.copyProperties((Object)each, (Object)uccSkuLogPo);
            uccSkuLogPo.setBatchId(Long.valueOf(this.uccBatchSequence.nextId()));
            uccSkuLogPo.setUpdateTime(new Date());
            uccSkuLogPo.setUpdateOperName("\u7cfb\u7edf");
            uccSkuLogPos.add(uccSkuLogPo);
            UccSkuOperationLogRecordAbilityBO uccSkuOperationLogRecordAbilityBO = new UccSkuOperationLogRecordAbilityBO();
            uccSkuOperationLogRecordAbilityBO.setSkuId(each.getSkuId());
            uccSkuOperationLogRecordAbilityBO.setCreateOperId("\u6570\u636e\u6cbb\u7406");
            uccSkuOperationLogRecordAbilityBO.setCommodityId(each.getCommodityId());
            uccSkuOperationLogRecordAbilityBO.setCreateTime(new Date());
            uccSkuOperationLogRecordAbilityBO.setOperationType(Integer.valueOf(22));
            uccSkuOperationLogRecordAbilityBO.setRemark("\u6570\u636e\u6cbb\u7406\u89e3\u7ed1");
            recordAbilityBOS.add(uccSkuOperationLogRecordAbilityBO);
        }
        this.uccSkuLogMapper.addSkuLog(uccSkuLogPos);
        UccSkuOperationLogRecordAbilityReqBO skuOperationLogRecordAbilityReqBO = new UccSkuOperationLogRecordAbilityReqBO();
        skuOperationLogRecordAbilityReqBO.setRecordAbilityBOS(recordAbilityBOS);
        this.uccSkuOperationLogRecordAbilityService.recordUccSkuOperationLog(skuOperationLogRecordAbilityReqBO);
    }
}

