/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.busi.api.UccWarehouseAddressUpdateBusiService;
import com.tydic.commodity.common.busi.bo.UccWarehouseAddressUpdateBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccWarehouseAddressUpdateBusiRspBO;
import com.tydic.commodity.dao.UccWarehouseAddressMapper;
import com.tydic.commodity.po.UccWarehouseAddressPO;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccWarehouseAddressUpdateBusiServiceImpl
implements UccWarehouseAddressUpdateBusiService {
    @Autowired
    private UccWarehouseAddressMapper uccWarehouseAddressMapper;

    @Override
    public UccWarehouseAddressUpdateBusiRspBO updateWarehouseAddress(UccWarehouseAddressUpdateBusiReqBO reqBO) {
        UccWarehouseAddressPO uccWarehouseAddressPO = new UccWarehouseAddressPO();
        uccWarehouseAddressPO.setId(reqBO.getId());
        uccWarehouseAddressPO.setAddressType(reqBO.getAddressType());
        uccWarehouseAddressPO = this.uccWarehouseAddressMapper.getModelBy(uccWarehouseAddressPO);
        if (uccWarehouseAddressPO == null) {
            throw new BusinessException(RspConstantEnums.WAREHOUSE_ADDRESS_UPDATE_FAIL.code(), "\u672a\u67e5\u8be2\u5230\u4f01\u914d\u4ed3\u4fe1\u606f");
        }
        if (reqBO.getStatus() != null) {
            if (UccConstants.WarehouseState.INVALID.equals(reqBO.getStatus())) {
                if (!UccConstants.WarehouseState.VALID.equals(uccWarehouseAddressPO.getStatus())) {
                    throw new BusinessException(RspConstantEnums.WAREHOUSE_ADDRESS_UPDATE_FAIL.code(), "\u4e0d\u5728\u542f\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u505c\u7528");
                }
            } else if (!UccConstants.WarehouseState.INVALID.equals(uccWarehouseAddressPO.getStatus())) {
                throw new BusinessException(RspConstantEnums.WAREHOUSE_ADDRESS_UPDATE_FAIL.code(), "\u4e0d\u5728\u505c\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u542f\u7528");
            }
            UccWarehouseAddressPO warehouseAddressPO = new UccWarehouseAddressPO();
            warehouseAddressPO.setWarehouseId(reqBO.getWarehouseId());
            warehouseAddressPO.setId(reqBO.getId());
            warehouseAddressPO.setStatus(reqBO.getStatus());
            this.uccWarehouseAddressMapper.updateById(warehouseAddressPO);
        } else {
            if (!(uccWarehouseAddressPO.getProvinceCode().equals(reqBO.getProvinceCode()) && uccWarehouseAddressPO.getCityCode().equals(reqBO.getCityCode()) && uccWarehouseAddressPO.getCountyCode().equals(reqBO.getCountyCode()) && uccWarehouseAddressPO.getTownCode().equals(reqBO.getTownCode()) || !UccConstants.AddressType.CURRENT.equals(reqBO.getAddressType()))) {
                UccWarehouseAddressPO checkByPO = new UccWarehouseAddressPO();
                checkByPO.setAddressType(reqBO.getAddressType());
                checkByPO.setProvinceCode(reqBO.getProvinceCode());
                checkByPO.setCityCode(reqBO.getCityCode());
                checkByPO.setCountyCode(reqBO.getCountyCode());
                checkByPO.setTownCode(reqBO.getTownCode());
                int i = this.uccWarehouseAddressMapper.getCheckBy(checkByPO);
                if (i > 0) {
                    throw new BusinessException(RspConstantEnums.WAREHOUSE_ADDRESS_UPDATE_FAIL.code(), "\u4f01\u914d\u4ed3\u5730\u533a\u4fe1\u606f\u5df2\u5b58\u5728\uff01");
                }
            }
            ArrayList<String> areaList = new ArrayList<String>();
            areaList.add(!StringUtils.isEmpty((Object)reqBO.getProvince()) ? reqBO.getProvince() : null);
            areaList.add(!StringUtils.isEmpty((Object)reqBO.getCity()) ? reqBO.getCity() : null);
            areaList.add(!StringUtils.isEmpty((Object)reqBO.getCounty()) ? reqBO.getCounty() : null);
            areaList.add(!StringUtils.isEmpty((Object)reqBO.getTown()) ? reqBO.getTown() : null);
            String area = String.join((CharSequence)"/", areaList);
            UccWarehouseAddressPO warehouseAddressPO = (UccWarehouseAddressPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), UccWarehouseAddressPO.class);
            warehouseAddressPO.setArea(area);
            warehouseAddressPO.setUpdateTime(new Date());
            warehouseAddressPO.setUpdateUserName(reqBO.getName());
            warehouseAddressPO.setUpdateUserId(reqBO.getUserId());
            warehouseAddressPO.setUpdateUserAccount(reqBO.getUsername());
            this.uccWarehouseAddressMapper.updateAreaById(warehouseAddressPO);
        }
        UccWarehouseAddressUpdateBusiRspBO rspBO = new UccWarehouseAddressUpdateBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

