/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.common.ability.api.UccAddCatalogRelBrandAbilityService;
import com.tydic.commodity.common.ability.bo.UccAddCatalogRelBrandAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccAddCatalogRelBrandAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccBrandBatchDownSkuEsReqBO;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccRelCatalogBrandMapper;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccRelCatalogBrandPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccAddCatalogRelBrandAbilityService"})
public class UccAddCatalogRelBrandAbilityServiceImpl
implements UccAddCatalogRelBrandAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAddCatalogRelBrandAbilityServiceImpl.class);
    @Autowired
    private UccRelCatalogBrandMapper uccRelCatalogBrandMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Resource(name="brandSkuDownProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${BRAND_SKU_DOWN_TOPIC:BRAND_SKU_DOWN_TOPIC}")
    private String topic;

    @PostMapping(value={"addCatalogRelBrand"})
    public UccAddCatalogRelBrandAbilityRspBO addCatalogRelBrand(@RequestBody UccAddCatalogRelBrandAbilityReqBO reqBO) {
        UccAddCatalogRelBrandAbilityRspBO rspBO = new UccAddCatalogRelBrandAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getCatalogId() == null || CollectionUtils.isEmpty((Collection)reqBO.getBrandIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        UccEMdmCatalogPO uccEMdmCatalogPO = this.uccEMdmCatalogMapper.queryByCatId(reqBO.getCatalogId());
        if (uccEMdmCatalogPO == null || uccEMdmCatalogPO.getCatalogLevel() != 3) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u53ea\u6709\u7b2c\u4e09\u7ea7\u7269\u6599\u5206\u7c7b\u624d\u80fd\u5173\u8054\u54c1\u724c");
            return rspBO;
        }
        List uccBrandDealPOS = this.uccBrandDealMapper.queryBrandByIds(reqBO.getBrandIds());
        if (!CollectionUtils.isEmpty((Collection)uccBrandDealPOS)) {
            Set collect = uccBrandDealPOS.stream().filter(e -> e.getAppRange() != 0 && e.getAppRange() != 1).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(collect)) {
                List failBrandNames = collect.stream().map(UccBrandDealPO::getBrandName).collect(Collectors.toList());
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u53ea\u6709\u5e94\u7528\u8303\u56f4\u4e3a\u5168\u5e73\u53f0\u548c\u7535\u5546\u7684\u54c1\u724c\u624d\u80fd\u5173\u8054\uff0c\u5931\u8d25\u7684\u540d\u79f0\u540d\u79f0\uff1a" + failBrandNames);
                return rspBO;
            }
            UccRelCatalogBrandPO seachPO = new UccRelCatalogBrandPO();
            seachPO.setCatalogId(reqBO.getCatalogId());
            List alreadyPOs = this.uccRelCatalogBrandMapper.getList(seachPO);
            if (!CollectionUtils.isEmpty((Collection)alreadyPOs)) {
                List alreadyBrandIds = alreadyPOs.stream().filter(e -> e.getBrandId() != null).map(UccRelCatalogBrandPO::getBrandId).collect(Collectors.toList());
                reqBO.getBrandIds().removeAll(alreadyBrandIds);
            }
            if (!CollectionUtils.isEmpty((Collection)reqBO.getBrandIds())) {
                ArrayList<UccRelCatalogBrandPO> insertBOS = new ArrayList<UccRelCatalogBrandPO>();
                Date now = new Date();
                for (Long brandId : reqBO.getBrandIds()) {
                    UccRelCatalogBrandPO brandPO = new UccRelCatalogBrandPO();
                    brandPO.setId(Long.valueOf(this.uccBatchSequence.nextId()));
                    brandPO.setCatalogId(reqBO.getCatalogId());
                    brandPO.setBrandId(brandId);
                    brandPO.setStatus(Integer.valueOf(1));
                    brandPO.setCreateTime(now);
                    brandPO.setCreateOperId(reqBO.getUsername());
                    brandPO.setCreateOperName(reqBO.getName());
                    insertBOS.add(brandPO);
                }
                this.uccRelCatalogBrandMapper.insertBatch(insertBOS);
                for (Long brandId : reqBO.getBrandIds()) {
                    UccBrandBatchDownSkuEsReqBO esReqBO = new UccBrandBatchDownSkuEsReqBO();
                    esReqBO.setBrandId(brandId);
                    esReqBO.setCatalogId(reqBO.getCatalogId());
                    try {
                        this.proxyMessageProducer.send(new ProxyMessage(this.topic, "*", JSON.toJSONString((Object)esReqBO)));
                    }
                    catch (Exception e2) {
                        log.error("\u540c\u6b65ES{}MQ\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Object)"\u54c1\u724c\u5bf9\u5e94\u5546\u54c1\u6279\u91cf\u4e0b\u67b6");
                    }
                }
            }
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5173\u8054\u7684\u54c1\u724c\u4e0d\u5b58\u5728");
            return rspBO;
        }
        return rspBO;
    }
}

