/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.busibase.busi.api.UccUpAndOffApplyBusiService;
import com.tydic.commodity.busibase.busi.bo.ExtReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApplyAbilityReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApplyAbilityRspBO;
import com.tydic.commodity.common.ability.api.UccAutoPutOnShelfAbilityService;
import com.tydic.commodity.common.ability.api.UccSkuOperationLogRecordAbilityService;
import com.tydic.commodity.common.ability.api.UccSpuSubcheckBatchApprovalAbilityService;
import com.tydic.commodity.common.ability.bo.UccAutoPutOnShelfAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccAutoPutOnShelfAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccBatchIdBO;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityBO;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuSubcheckBatchApprovalAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuSubcheckBatchApprovalAbilityRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccAutoPutOnShelfAbilityService"})
public class UccAutoPutOnShelfAbilityServiceImpl
implements UccAutoPutOnShelfAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAutoPutOnShelfAbilityServiceImpl.class);
    @Autowired
    private UccSpuSubcheckBatchApprovalAbilityService uccSpuSubcheckBatchApprovalAbilityService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Value(value="ARG_ON_SHELF_PROCESS")
    private String agrProcess;
    @Value(value="SELF_ON_SHELF_PROCESS")
    private String selfProcess;
    @Autowired
    private UccUpAndOffApplyBusiService uccUpAndOffApplyBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Resource(name="uccNotificationMqServiceProvider")
    private ProxyMessageProducer uccNotificationMqServiceProvider;
    @Value(value="${es.UCC_NOTIFICATION_TOPIC:UCC_NOTIFICATION_TOPIC}")
    private String uccNotificationTopic;
    @Value(value="${es.UCC_NOTIFICATION_TAG:UCC_NOTIFICATION_TAG}")
    private String uccNotificationTag;
    @Autowired
    private UccSkuOperationLogRecordAbilityService uccSkuOperationLogRecordAbilityService;

    @PostMapping(value={"dealAutoPutOnShelf"})
    public UccAutoPutOnShelfAbilityRspBO dealAutoPutOnShelf(@RequestBody UccAutoPutOnShelfAbilityReqBO reqBO) {
        UccAutoPutOnShelfAbilityRspBO rspBO = new UccAutoPutOnShelfAbilityRspBO();
        List uccSkuPos = this.uccSkuMapper.selectSkuPutCir();
        ArrayList<UccSkuPo> unAgrList = new ArrayList<UccSkuPo>();
        ArrayList<UccSkuPo> supermarketAgrList = new ArrayList<UccSkuPo>();
        ArrayList<UccSkuPo> tradeModeAgrList = new ArrayList<UccSkuPo>();
        ArrayList<UccSkuPo> otherAgrList = new ArrayList<UccSkuPo>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)uccSkuPos)) {
            ArrayList<UccSkuOperationLogRecordAbilityBO> recordAbilityBOS = new ArrayList<UccSkuOperationLogRecordAbilityBO>();
            for (UccSkuPo uccSkuPo : uccSkuPos) {
                UccSkuOperationLogRecordAbilityBO logRecordAbilityBO = new UccSkuOperationLogRecordAbilityBO();
                logRecordAbilityBO.setSkuId(uccSkuPo.getSkuId());
                logRecordAbilityBO.setCreateOperId("\u7cfb\u7edf");
                logRecordAbilityBO.setCommodityId(uccSkuPo.getCommodityId());
                logRecordAbilityBO.setCreateTime(new Date());
                logRecordAbilityBO.setExtField1("\u5546\u54c1\u81ea\u52a8\u4e0a\u67b6\u5b9a\u65f6\u4efb\u52a1");
                logRecordAbilityBO.setOperationType(Integer.valueOf(17));
                logRecordAbilityBO.setRemark("\u5546\u54c1\u4e0a\u67b6-\u81ea\u52a8\u4e0a\u67b6");
                recordAbilityBOS.add(logRecordAbilityBO);
                if (uccSkuPo.getSkuSource() == 1) {
                    unAgrList.add(uccSkuPo);
                    continue;
                }
                if (uccSkuPo.getIsSupermarketStaff() != null && uccSkuPo.getIsSupermarketStaff() == 1) {
                    supermarketAgrList.add(uccSkuPo);
                    continue;
                }
                if (uccSkuPo.getTradeMode() != null && uccSkuPo.getTradeMode() == 2) {
                    tradeModeAgrList.add(uccSkuPo);
                    continue;
                }
                otherAgrList.add(uccSkuPo);
            }
            try {
                if (!CollectionUtils.isEmpty(recordAbilityBOS)) {
                    UccSkuOperationLogRecordAbilityReqBO skuOperationLogRecordAbilityReqBO = new UccSkuOperationLogRecordAbilityReqBO();
                    skuOperationLogRecordAbilityReqBO.setRecordAbilityBOS(recordAbilityBOS);
                    this.uccSkuOperationLogRecordAbilityService.recordUccSkuOperationLog(skuOperationLogRecordAbilityReqBO);
                }
            }
            catch (Exception e) {
                log.error("\u5546\u54c1\u4e0a\u67b6-\u81ea\u52a8\u4e0a\u67b6" + e.getMessage());
            }
            this.dealSkuPutUp(unAgrList, this.selfProcess);
            this.dealSkuPutUp(supermarketAgrList, "M001006");
            this.dealSkuPutUp(tradeModeAgrList, "M001010");
            this.dealSkuPutUp(otherAgrList, this.agrProcess);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealSkuPutUp(List<UccSkuPo> uccSkuPos, String reqAgrProcess) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(uccSkuPos)) {
            return;
        }
        Map<Integer, List<UccSkuPo>> map = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSkuSource));
        for (Integer source : map.keySet()) {
            ArrayList<UccBatchSkuBO> batchSkuBOList = new ArrayList<UccBatchSkuBO>();
            ArrayList batchIdList = new ArrayList();
            map.get(source).forEach(a -> {
                UccBatchIdBO idBO = new UccBatchIdBO();
                idBO.setId(a.getSkuId());
                idBO.setSupplierShopId(a.getSupplierShopId());
                batchIdList.add(idBO);
            });
            UccUpAndOffApplyAbilityReqBO busiReqBO = new UccUpAndOffApplyAbilityReqBO();
            busiReqBO.setUserId(Long.valueOf(1L));
            busiReqBO.setUsername("admin");
            busiReqBO.setOrgId(Long.valueOf(1L));
            busiReqBO.setOrgIdIn(Long.valueOf(1L));
            busiReqBO.setOrgName("admin");
            ExtReqBO extReqBO = new ExtReqBO();
            extReqBO.setProcess(reqAgrProcess);
            extReqBO.setAuditObjType(ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF);
            ArrayList<Integer> oldStatus = new ArrayList<Integer>();
            oldStatus.add(SkuStatusEnum.PENDING_SHELF_STATUS.getStatus());
            extReqBO.setStatusOld(oldStatus);
            extReqBO.setStatusApproval(SkuStatusEnum.ON_SHELVES_STATUS.getStatus());
            extReqBO.setStatusApply(SkuStatusEnum.PENDING_SHELF_STATUS.getStatus());
            extReqBO.setAuditStatusApply(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_ON_SHELF_GO.toString());
            extReqBO.setRemark("\u81ea\u52a8\u4e0a\u67b6");
            extReqBO.setOperate(Integer.valueOf(2));
            UccSpuSubcheckBatchApprovalAbilityReqBO uccSpuSubcheckBatchApprovalAbilityReqBO = new UccSpuSubcheckBatchApprovalAbilityReqBO();
            uccSpuSubcheckBatchApprovalAbilityReqBO.setBatchIdList(batchIdList);
            uccSpuSubcheckBatchApprovalAbilityReqBO.setType(Integer.valueOf(2));
            ArrayList<Integer> ids = new ArrayList<Integer>();
            ids.add(2);
            uccSpuSubcheckBatchApprovalAbilityReqBO.setStatus(ids);
            UccSpuSubcheckBatchApprovalAbilityRspBO uccSpuSubcheckBatchApprovalAbilityRspBO = this.uccSpuSubcheckBatchApprovalAbilityService.dealbatchEdit(uccSpuSubcheckBatchApprovalAbilityReqBO);
            if (!"0000".equals(uccSpuSubcheckBatchApprovalAbilityRspBO.getRespCode())) {
                return;
            }
            List batchIdList1 = uccSpuSubcheckBatchApprovalAbilityRspBO.getBatchIdList();
            for (UccBatchIdBO bo : batchIdList1) {
                UccBatchSkuBO skuBO = new UccBatchSkuBO();
                skuBO.setSkuId(bo.getId());
                skuBO.setSupplierShopId(bo.getSupplierShopId());
                batchSkuBOList.add(skuBO);
            }
            busiReqBO.setBatchSkuList(batchSkuBOList);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)busiReqBO.getBatchSkuList())) continue;
            UccUpAndOffApplyAbilityRspBO busiRspBO = new UccUpAndOffApplyAbilityRspBO();
            try {
                busiRspBO = this.uccUpAndOffApplyBusiService.dealUpAndOffApply(busiReqBO, extReqBO);
            }
            catch (Exception e) {
                return;
            }
            try {
                if ("0000".equals(busiRspBO.getRespCode()) && null != busiRspBO.getUccSendNotificationExtAtomReqBO() && !CollectionUtils.isEmpty((Collection)busiRspBO.getUccSendNotificationExtAtomReqBO().getObjIds())) {
                    this.uccNotificationMqServiceProvider.send(new ProxyMessage(this.uccNotificationTopic, this.uccNotificationTag, JSONObject.toJSONString((Object)busiRspBO.getUccSendNotificationExtAtomReqBO())));
                }
            }
            catch (Exception e) {
                log.info("\u4ee3\u529e\u901a\u77e5\u53d1\u9001\u5931\u8d25" + e);
            }
            Map<Long, List<UccBatchSkuBO>> mapSku = batchSkuBOList.stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
            for (Long supplierShopId : mapSku.keySet()) {
                List skus = mapSku.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skus));
                syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                }
            }
        }
    }
}

