/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.tydic.commodity.common.ability.api.UccBrandSkuOnCheckAbilityService;
import com.tydic.commodity.common.ability.bo.UccBrandSkuOnCheckAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccBrandSkuOnCheckAbilityRspBo;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccRelCatalogBrandMapper;
import com.tydic.commodity.dao.UccRelCatalogBrandVendorMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccRelCatalogBrandVendorPO;
import com.tydic.commodity.po.UccSkuBrandPo;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccBrandSkuOnCheckAbilityService"})
public class UccBrandSkuOnCheckAbilityServiceImpl
implements UccBrandSkuOnCheckAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccBrandSkuOnCheckAbilityServiceImpl.class);
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccRelCatalogBrandMapper uccRelCatalogBrandMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccRelCatalogBrandVendorMapper uccRelCatalogBrandVendorMapper;

    @PostMapping(value={"checkSkuOn"})
    public UccBrandSkuOnCheckAbilityRspBo checkSkuOn(@RequestBody UccBrandSkuOnCheckAbilityReqBo reqBo) {
        UccBrandSkuOnCheckAbilityRspBo rspBo = new UccBrandSkuOnCheckAbilityRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)reqBo.getSkuIds())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u4f20\u5165\u5355\u54c1ID");
            return rspBo;
        }
        List uccSkuPos = this.uccSkuMapper.batchQrySku(reqBo.getSkuIds(), null);
        if (!CollectionUtils.isEmpty((Collection)uccSkuPos)) {
            List typeIds = uccSkuPos.stream().map(a -> a.getCommodityTypeId()).distinct().collect(Collectors.toList());
            List uccCommodityTypePos = this.uccCommodityTypeMapper.batchQryInType(typeIds);
            Map<Object, Object> typeAndCat = new HashMap();
            Map<Object, Object> typeAndbrandVerify = new HashMap();
            Map<Long, String> skuIdExtSkuIdMap = uccSkuPos.stream().collect(Collectors.toMap(UccSkuPo::getSkuId, UccSkuPo::getSkuCode));
            if (!CollectionUtils.isEmpty((Collection)uccCommodityTypePos)) {
                typeAndCat = uccCommodityTypePos.stream().collect(Collectors.toMap(a -> a.getCommodityTypeId(), b -> b.getCatalogId(), (first, second) -> first));
                List catalogIds = uccCommodityTypePos.stream().map(a -> a.getCatalogId()).collect(Collectors.toList());
                List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.selectByCatalogIds(catalogIds);
                if (!CollectionUtils.isEmpty((Collection)uccEMdmCatalogPOS)) {
                    Map<Long, Integer> catalogBrandMap = uccEMdmCatalogPOS.stream().filter(a -> a.getBrandVerify() != null).collect(Collectors.toMap(a -> a.getCatalogId(), b -> b.getBrandVerify(), (first, second) -> first));
                    for (UccCommodityTypePo uccCommodityTypePo : uccCommodityTypePos) {
                        if (!catalogBrandMap.containsKey(uccCommodityTypePo.getCatalogId())) continue;
                        uccCommodityTypePo.setBrandVerify(catalogBrandMap.get(uccCommodityTypePo.getCatalogId()));
                    }
                    typeAndbrandVerify = uccCommodityTypePos.stream().filter(a -> a.getBrandVerify() != null).collect(Collectors.toMap(a -> a.getCommodityTypeId(), b -> b.getBrandVerify(), (first, second) -> first));
                }
            }
            Map<Long, List<UccSkuPo>> typeMap = uccSkuPos.stream().collect(Collectors.groupingBy(a -> a.getCommodityTypeId()));
            Map<Integer, List<UccSkuPo>> sourceMap = uccSkuPos.stream().collect(Collectors.groupingBy(a -> a.getSkuSource()));
            for (Map.Entry<Long, List<UccSkuPo>> eachType : typeMap.entrySet()) {
                if (!typeAndbrandVerify.containsKey(eachType.getKey()) || (Integer)typeAndbrandVerify.get(eachType.getKey()) != 1) continue;
                for (Map.Entry<Integer, List<UccSkuPo>> each : sourceMap.entrySet()) {
                    if (2 != each.getKey()) continue;
                    List elcSkuIds = each.getValue().stream().map(a -> a.getSkuId()).collect(Collectors.toList());
                    List uccSkuBrandPos = this.uccBrandDealMapper.querySkuMallBrand(elcSkuIds);
                    if (CollectionUtils.isEmpty((Collection)uccSkuBrandPos)) {
                        rspBo.setRespCode("8888");
                        ArrayList<String> failSkuCodes = new ArrayList<String>();
                        for (Long skuId : reqBo.getSkuIds()) {
                            if (!skuIdExtSkuIdMap.containsKey(skuId)) continue;
                            failSkuCodes.add(skuIdExtSkuIdMap.get(skuId));
                        }
                        rspBo.setRespDesc("\u8be5\u5546\u54c1" + failSkuCodes + "\u6240\u5173\u8054\u54c1\u724c\u5e76\u672a\u4e0e\u5e73\u53f0\u54c1\u724c\u8fdb\u884c\u5173\u8054\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8fdb\u884c\u5173\u8054\u4e4b\u540e\u518d\u63d0\u4ea4\u5546\u54c1\u4e0a\u67b6\uff01");
                        return rspBo;
                    }
                    Map<Long, UccSkuBrandPo> skuAndMallBrandMap = uccSkuBrandPos.stream().filter(a -> a.getBrandId() != null).collect(Collectors.toMap(a -> a.getSkuId(), b -> b, (first, second) -> first));
                    for (Long skuId : reqBo.getSkuIds()) {
                        if (skuAndMallBrandMap.containsKey(skuId)) continue;
                        rspBo.setRespCode("8888");
                        rspBo.setRespDesc("\u8be5\u5546\u54c1" + skuIdExtSkuIdMap.get(skuId) + "\u6240\u5173\u8054\u54c1\u724c\u5e76\u672a\u4e0e\u5e73\u53f0\u54c1\u724c\u8fdb\u884c\u5173\u8054\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8fdb\u884c\u5173\u8054\u4e4b\u540e\u518d\u63d0\u4ea4\u5546\u54c1\u4e0a\u67b6\uff01");
                        return rspBo;
                    }
                    for (UccSkuPo uccSkuPo : each.getValue()) {
                        Long mallBrandId = skuAndMallBrandMap.get(uccSkuPo.getSkuId()).getBrandId();
                        if (skuAndMallBrandMap.get(uccSkuPo.getSkuId()).getBrandStatus() != 1) {
                            rspBo.setRespCode("8888");
                            rspBo.setRespDesc("\u8be5\u5546\u54c1" + skuIdExtSkuIdMap.get(uccSkuPo.getSkuId()) + "\u6240\u5173\u8054\u5e73\u53f0\u54c1\u724c\u72b6\u6001\u4e0d\u4e3a\u542f\u7528\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8fdb\u884c\u542f\u7528\u4e4b\u540e\u518d\u63d0\u4ea4\u5546\u54c1\u4e0a\u67b6\uff01");
                            return rspBo;
                        }
                        if (skuAndMallBrandMap.get(uccSkuPo.getSkuId()).getAppRange() == 2) {
                            rspBo.setRespCode("8888");
                            rspBo.setRespDesc("\u8be5\u7535\u5546\u5546\u54c1" + skuIdExtSkuIdMap.get(uccSkuPo.getSkuId()) + "\u6240\u5173\u8054\u5e73\u53f0\u54c1\u724c\u5e94\u7528\u8303\u56f4\u4e3a\u975e\u7535\u5546\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8fdb\u884c\u66f4\u6539\u5e94\u7528\u8303\u56f4\u4e4b\u540e\u518d\u63d0\u4ea4\u5546\u54c1\u4e0a\u67b6\uff01");
                            return rspBo;
                        }
                        Long catalogId = (Long)typeAndCat.get(uccSkuPo.getCommodityTypeId());
                        UccRelCatalogBrandVendorPO uccRelCatalogBrandVendorPO = new UccRelCatalogBrandVendorPO();
                        uccRelCatalogBrandVendorPO.setCatalogId(catalogId);
                        uccRelCatalogBrandVendorPO.setBrandId(mallBrandId);
                        uccRelCatalogBrandVendorPO.setVendorId(uccSkuPo.getSupplierShopId());
                        uccRelCatalogBrandVendorPO.setDiscountFlag(Integer.valueOf(0));
                        List uccRelCatalogBrandVendorPOS = this.uccRelCatalogBrandVendorMapper.getList(uccRelCatalogBrandVendorPO);
                        if (CollectionUtils.isEmpty((Collection)uccRelCatalogBrandVendorPOS)) {
                            rspBo.setRespCode("8888");
                            rspBo.setRespDesc("\u8be5\u5546\u54c1" + skuIdExtSkuIdMap.get(uccSkuPo.getSkuId()) + "\u8be5\u4f9b\u5e94\u5546\u6ca1\u6709\u4e0e\u8be5\u7269\u8d44\u5206\u7c7b\u4e0b\u7684\u8be5\u54c1\u724c\u505a\u5173\u8054\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8fdb\u884c\u5173\u8054\u4e4b\u540e\u518d\u63d0\u4ea4\u5546\u54c1\u4e0a\u67b6\uff01");
                            return rspBo;
                        }
                        if (((UccRelCatalogBrandVendorPO)uccRelCatalogBrandVendorPOS.get(0)).getStatus() == 1) continue;
                        rspBo.setRespCode("8888");
                        rspBo.setRespDesc("\u8be5\u5546\u54c1\u6240\u5c5e\u4f9b\u5e94\u5546\u4e0e\u6240\u5c5e\u7269\u8d44\u5206\u7c7b\u4e0b\u6240\u5c5e\u54c1\u724c\u7684\u5173\u8054\u72b6\u6001\u4e0d\u4e3a\u542f\u7528\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u8fdb\u884c\u542f\u7528\u4e4b\u540e\u518d\u63d0\u4ea4\u5546\u54c1\u4e0a\u67b6\uff01");
                        return rspBo;
                    }
                }
            }
        }
        return rspBo;
    }
}

