/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.common.ability.api.UccMdmCatalogPathAbilityService;
import com.tydic.commodity.common.ability.bo.UccMdmCatalogPathAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccMdmCatalogPathAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccMdmCatalogsearchBO;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccMdmCatalogPathAbilityService"})
public class UccMdmCatalogPathAbilityServiceImpl
implements UccMdmCatalogPathAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMdmCatalogPathAbilityServiceImpl.class);
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;

    @PostMapping(value={"getCatalogPath"})
    public UccMdmCatalogPathAbilityRspBO getCatalogPath(@RequestBody UccMdmCatalogPathAbilityReqBO reqBO) {
        UccMdmCatalogPathAbilityRspBO rspBO = new UccMdmCatalogPathAbilityRspBO();
        if (reqBO.getCatalogId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u4f20\u5165\u5206\u7c7bID");
            return rspBO;
        }
        List<UccEMdmCatalogPO> poList = this.findParent(reqBO.getCatalogId());
        if (!CollectionUtils.isEmpty(poList)) {
            Collections.sort(poList, new Comparator<UccEMdmCatalogPO>(){

                @Override
                public int compare(UccEMdmCatalogPO o1, UccEMdmCatalogPO o2) {
                    return o1.getCatalogLevel() - o2.getCatalogLevel();
                }
            });
            StringBuilder sb = new StringBuilder("");
            poList.stream().forEach(a -> {
                if (!"".equals(sb.toString())) {
                    sb.append("/");
                }
                sb.append(a.getCatalogName());
            });
            rspBO.setPath(sb.toString());
            List rows = JSONObject.parseArray((String)JSONObject.toJSONString(poList), UccMdmCatalogsearchBO.class);
            rspBO.setRows(rows);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    List<UccEMdmCatalogPO> findParent(Long catalogId) {
        ArrayList<UccEMdmCatalogPO> poList = new ArrayList<UccEMdmCatalogPO>();
        UccEMdmCatalogPO po = this.uccEMdmCatalogMapper.queryById(catalogId);
        if (po == null) {
            return poList;
        }
        poList.add(po);
        if (po.getCatalogLevel() == 1) {
            return poList;
        }
        List<UccEMdmCatalogPO> parent = this.findParent(po.getParentCatalogId());
        poList.addAll(parent);
        return poList;
    }
}

