/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.EstoreSkuInfoImageBo;
import com.tydic.commodity.base.bo.SkuInfoPriceBo;
import com.tydic.commodity.base.bo.SkuInfoSpecBo;
import com.tydic.commodity.base.bo.SkuPutCirBo;
import com.tydic.commodity.base.bo.UccLadderPriceInfo;
import com.tydic.commodity.base.bo.UccSkuExpandBo;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccConfigurationparametersDetailAbilityService;
import com.tydic.commodity.common.ability.api.UccSkuManagementAbilityService;
import com.tydic.commodity.common.ability.api.UccUpperTaxCatCodeQryAbilityService;
import com.tydic.commodity.common.ability.bo.SkuDataGovernPropBO;
import com.tydic.commodity.common.ability.bo.UccBrandAddPriceAbilityBO;
import com.tydic.commodity.common.ability.bo.UccBrandAddPriceLogBO;
import com.tydic.commodity.common.ability.bo.UccBrandAddPriceLogSkuBO;
import com.tydic.commodity.common.ability.bo.UccConfigurationparametersDetailAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccConfigurationparametersDetailAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccConfigurationparametersQryBO;
import com.tydic.commodity.common.ability.bo.UccPublicReqBO;
import com.tydic.commodity.common.ability.bo.UccPublicRspBO;
import com.tydic.commodity.common.ability.bo.UccSkuItemInfoBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSkuPropBO;
import com.tydic.commodity.common.ability.bo.UccSkuSpecBO;
import com.tydic.commodity.common.ability.bo.UccUpperTaxCatCodeQryAbilityReqBo;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.dao.SkuDataGovernMapper;
import com.tydic.commodity.dao.SkuDataGovernPriceMapper;
import com.tydic.commodity.dao.SkuDataGovernPropMapper;
import com.tydic.commodity.dao.UccAddCoefficientMapper;
import com.tydic.commodity.dao.UccBrandAddPriceLogMapper;
import com.tydic.commodity.dao.UccBrandAddPriceMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSearchWordBlackMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.dao.UccSkuDetailMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.dao.UccSmcsdkSkuStockInfoMapper;
import com.tydic.commodity.dao.UccSpuSpecMapper;
import com.tydic.commodity.mall.ability.api.UccMallCurrentPriceQryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallCurrentPriceQryReqBO;
import com.tydic.commodity.po.SkuDataGovernPO;
import com.tydic.commodity.po.SkuDataGovernPricePO;
import com.tydic.commodity.po.SkuDataGovernPropPO;
import com.tydic.commodity.po.UccAddCoefficientPO;
import com.tydic.commodity.po.UccBrandAddPriceLogPO;
import com.tydic.commodity.po.UccBrandAddPricePO;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccCommodityPropGrpPo;
import com.tydic.commodity.po.UccCommodityTaxTypePO;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccSaleNumPo;
import com.tydic.commodity.po.UccSkuAddCoefficientPO;
import com.tydic.commodity.po.UccSkuDetailPO;
import com.tydic.commodity.po.UccSkuExpandPo;
import com.tydic.commodity.po.UccSkuPicPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UccSkuPutCirPo;
import com.tydic.commodity.po.UccSkuSpecPo;
import com.tydic.commodity.po.UccSmcsdkSkuStockInfoPO;
import com.tydic.commodity.po.UccSpuSpecPo;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuManagementAbilityService"})
public class UccSkuManagementAbilityServiceImpl
implements UccSkuManagementAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuManagementAbilityServiceImpl.class);
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    @Autowired
    private UccSmcsdkSkuStockInfoMapper uccSmcsdkSkuStockInfoMapper;
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    @Autowired
    private UccSpuSpecMapper uccSpuSpecMapper;
    @Autowired
    private UccAddCoefficientMapper uccAddCoefficientMapper;
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccSkuDetailMapper uccSkuDetailMapper;
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccSearchWordBlackMapper uccSearchWordBlackMapper;
    private SkuDataGovernMapper skuDataGovernMapper;
    private SkuDataGovernPropMapper skuDataGovernPropMapper;
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccConfigurationparametersDetailAbilityService uccConfigurationparametersDetailAbilityService;
    @Autowired
    private UccBrandAddPriceMapper uccBrandAddPriceMapper;
    @Autowired
    private UccBrandAddPriceLogMapper uccBrandAddPriceLogMapper;
    @Autowired
    private UccUpperTaxCatCodeQryAbilityService uccUpperTaxCatCodeQryAbilityService;
    @Autowired
    SkuDataGovernPriceMapper skuDataGovernPriceMapper;
    @Autowired
    private UccMallCurrentPriceQryAbilityService uccMallCurrentPriceQryAbilityService;

    @PostMapping(value={"getSkuManagement"})
    public UccSkuManagementAbilityRspBO getSkuManagement(@RequestBody UccSkuManagementAbilityReqBO reqBO) {
        UccCommodityTypePo uccCommodityTypePo;
        UccSkuManagementAbilityRspBO rspBO = new UccSkuManagementAbilityRspBO();
        if (reqBO.getSkuId() == null) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5355\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getSupplierShopId() == null) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSkuId(reqBO.getSkuId());
        uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
        List uccSkuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
        if (uccSkuPoList == null || uccSkuPoList.isEmpty()) {
            rspBO.setRespCode("0002");
            rspBO.setRespDesc("\u5355\u54c1\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        UccSkuItemInfoBO uccSkuItemInfoBO = new UccSkuItemInfoBO();
        BeanUtils.copyProperties(uccSkuPoList.get(0), (Object)uccSkuItemInfoBO);
        UccCommodityPo commodityById = this.uccCommodityMapper.getCommodityById(uccSkuItemInfoBO.getCommodityId());
        if (commodityById != null) {
            uccSkuItemInfoBO.setIsOil(commodityById.getIsOil());
            uccSkuItemInfoBO.setTradeMode(commodityById.getTradeMode());
        }
        if (uccSkuItemInfoBO.getApprovalStatus() != null) {
            uccSkuItemInfoBO.setApprovalStatus(((UccSkuPo)uccSkuPoList.get(0)).getApprovalStatus());
        }
        if (((UccSkuPo)uccSkuPoList.get(0)).getCommodityTypeId() != null && (uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(((UccSkuPo)uccSkuPoList.get(0)).getCommodityTypeId())) != null) {
            uccSkuItemInfoBO.setCommodityTypeName(uccCommodityTypePo.getCommodityTypeName());
            uccSkuItemInfoBO.setCatalogId(uccCommodityTypePo.getCatalogId());
        }
        if (((UccSkuPo)uccSkuPoList.get(0)).getMaterialId() != null && !"".equals(((UccSkuPo)uccSkuPoList.get(0)).getMaterialId())) {
            uccSkuItemInfoBO.setMaterialId(Long.valueOf(Long.parseLong(((UccSkuPo)uccSkuPoList.get(0)).getMaterialId())));
            UccEMdmMaterialPO uccEMdmMaterialPO = this.uccEMdmMaterialMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(((UccSkuPo)uccSkuPoList.get(0)).getMaterialId())));
            if (uccEMdmMaterialPO != null) {
                uccSkuItemInfoBO.setMaterialCode(uccEMdmMaterialPO.getMaterialCode());
                uccSkuItemInfoBO.setMaterialName(uccEMdmMaterialPO.getMaterialName());
                if (uccEMdmMaterialPO.getLongDesc() != null) {
                    uccSkuItemInfoBO.setLongDesc(uccEMdmMaterialPO.getLongDesc());
                }
            }
        }
        UccSkuDetailPO uccSkuDetailPO = new UccSkuDetailPO();
        uccSkuDetailPO.setSkuId(reqBO.getSkuId());
        uccSkuDetailPO.setSupplierShopId(reqBO.getSupplierShopId());
        UccSkuDetailPO skuDetailPO = this.uccSkuDetailMapper.getModelBy(uccSkuDetailPO);
        if (skuDetailPO != null) {
            uccSkuItemInfoBO.setSkuPcDetailUrl(skuDetailPO.getSkuPcDetailUrl());
            uccSkuItemInfoBO.setSkuPcDetailChar(skuDetailPO.getSkuPcDetailChar());
            uccSkuItemInfoBO.setSkuPhoneDetailUrl(skuDetailPO.getSkuPhoneDetailUrl());
            uccSkuItemInfoBO.setSkuPhoneDetailChar(skuDetailPO.getSkuPhoneDetailChar());
        }
        UccSaleNumPo saleNumPo = new UccSaleNumPo();
        saleNumPo.setSkuId(reqBO.getSkuId());
        saleNumPo.setSupplierShopId(reqBO.getSupplierShopId());
        UccSaleNumPo uccSaleNumPo = this.uccSaleNumMapper.querySaleNum(saleNumPo);
        if (uccSaleNumPo != null) {
            uccSkuItemInfoBO.setSoldNumber(uccSaleNumPo.getSoldNumber());
        }
        UccSmcsdkSkuStockInfoPO smcsdkSkuStockInfoPO = new UccSmcsdkSkuStockInfoPO();
        smcsdkSkuStockInfoPO.setSkuId(uccSkuItemInfoBO.getSkuId().toString());
        UccSmcsdkSkuStockInfoPO uccSmcsdkSkuStockInfoPO = this.uccSmcsdkSkuStockInfoMapper.getModelBy(smcsdkSkuStockInfoPO);
        if (uccSmcsdkSkuStockInfoPO != null && uccSmcsdkSkuStockInfoPO.getTotalNum() != null) {
            uccSkuItemInfoBO.setTotalNum(MoneyUtils.haoToYuan((Long)uccSmcsdkSkuStockInfoPO.getTotalNum()));
        }
        ArrayList<UccSkuSpecBO> skuSpec = new ArrayList<UccSkuSpecBO>();
        UccSkuSpecPo uccSkuSpecPo = new UccSkuSpecPo();
        uccSkuSpecPo.setSkuId(reqBO.getSkuId());
        uccSkuSpecPo.setSupplierShopId(reqBO.getSupplierShopId());
        List uccSkuSpecPoList = this.uccSkuSpecMapper.querySpec(uccSkuSpecPo);
        ArrayList<UccSkuSpecPo> skuSpecList = new ArrayList<UccSkuSpecPo>();
        UccSpuSpecPo uccSpuSpecPo = new UccSpuSpecPo();
        uccSpuSpecPo.setCommodityId(uccSkuItemInfoBO.getCommodityId());
        uccSpuSpecPo.setSupplierShopId(uccSkuItemInfoBO.getSupplierShopId());
        List uccSpuSpecPos = this.uccSpuSpecMapper.querySpec(uccSpuSpecPo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)uccSpuSpecPos)) {
            for (Object spuSpecPo : uccSpuSpecPos) {
                UccSkuSpecPo temp = new UccSkuSpecPo();
                BeanUtils.copyProperties((Object)spuSpecPo, (Object)temp);
                skuSpecList.add(temp);
            }
        }
        uccSkuSpecPoList.addAll(skuSpecList);
        if (!uccSkuSpecPoList.isEmpty()) {
            HashSet<String> commodityPropGrpNameSet = new HashSet<String>();
            for (UccSkuSpecPo each : uccSkuSpecPoList) {
                commodityPropGrpNameSet.add(each.getCommodityPropGrpName());
            }
            for (String commodityPropGrpName : commodityPropGrpNameSet) {
                ArrayList skuInfoSpecBoList = new ArrayList();
                Long commodityPropGrpId = null;
                for (UccSkuSpecPo each : uccSkuSpecPoList) {
                    if (!each.getCommodityPropGrpName().equals(commodityPropGrpName)) continue;
                    SkuInfoSpecBo skuInfoSpecBo = new SkuInfoSpecBo();
                    BeanUtils.copyProperties((Object)each, (Object)skuInfoSpecBo);
                    skuInfoSpecBoList.add(skuInfoSpecBo);
                    if (commodityPropGrpId != null) continue;
                    commodityPropGrpId = each.getCommodityPropGrpId();
                }
                UccSkuSpecBO uccSkuSpecBO = new UccSkuSpecBO();
                uccSkuSpecBO.setCommodityPropGrpId(commodityPropGrpId);
                uccSkuSpecBO.setCommodityPropGrpName(commodityPropGrpName);
                uccSkuSpecBO.setSkuSpecs((List)skuInfoSpecBoList);
                skuSpec.add(uccSkuSpecBO);
            }
        }
        uccSkuItemInfoBO.setSkuSpec(skuSpec);
        UccSkuPicPo uccSkuPicPo = new UccSkuPicPo();
        uccSkuPicPo.setSkuId(reqBO.getSkuId());
        uccSkuPicPo.setSupplierShopId(reqBO.getSupplierShopId());
        List uccSkuPicPoList = this.uccSkuPicMapper.qeurySkuPic(uccSkuPicPo);
        ArrayList<EstoreSkuInfoImageBo> skuImags = new ArrayList<EstoreSkuInfoImageBo>();
        for (UccSkuPicPo each : uccSkuPicPoList) {
            EstoreSkuInfoImageBo estoreSkuInfoImageBo = new EstoreSkuInfoImageBo();
            BeanUtils.copyProperties((Object)each, (Object)estoreSkuInfoImageBo);
            skuImags.add(estoreSkuInfoImageBo);
        }
        uccSkuItemInfoBO.setSkuImages(skuImags);
        UccSkuExpandPo uccSkuExpandPo = new UccSkuExpandPo();
        uccSkuExpandPo.setSkuId(reqBO.getSkuId());
        uccSkuExpandPo.setSupplierShopId(reqBO.getSupplierShopId());
        List uccSkuExpandPoList = this.uccSkuExpandMapper.querySkuExpand(uccSkuExpandPo);
        if (uccSkuExpandPoList != null && !uccSkuExpandPoList.isEmpty()) {
            UccSkuExpandBo uccSkuExpandBo = new UccSkuExpandBo();
            BeanUtils.copyProperties(uccSkuExpandPoList.get(0), (Object)uccSkuExpandBo);
            uccSkuItemInfoBO.setSkuExpand(uccSkuExpandBo);
        }
        UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
        uccSkuPricePo.setSkuId(reqBO.getSkuId());
        uccSkuPricePo.setSupplierShopId(reqBO.getSupplierShopId());
        UccSkuPricePo result = this.uccSkuPriceMapper.querySkuPrice(uccSkuPricePo);
        if (result != null) {
            SkuInfoPriceBo skuInfoPriceBo = new SkuInfoPriceBo();
            BeanUtils.copyProperties((Object)result, (Object)skuInfoPriceBo);
            if (result.getMarketPrice() != null) {
                skuInfoPriceBo.setMarketPrice(MoneyUtils.haoToYuan((Long)result.getMarketPrice()));
            }
            if (result.getAgreementPrice() != null) {
                skuInfoPriceBo.setAgreementPrice(MoneyUtils.haoToYuan((Long)result.getAgreementPrice()));
            }
            if (result.getMemberPrice1() != null) {
                skuInfoPriceBo.setMemberPrice1(MoneyUtils.haoToYuan((Long)result.getMemberPrice1()));
            }
            if (result.getMemberPrice2() != null) {
                skuInfoPriceBo.setMemberPrice2(MoneyUtils.haoToYuan((Long)result.getMemberPrice2()));
            }
            if (result.getMemberPrice3() != null) {
                skuInfoPriceBo.setMemberPrice3(MoneyUtils.haoToYuan((Long)result.getMemberPrice3()));
            }
            if (result.getMemberPrice4() != null) {
                skuInfoPriceBo.setMemberPrice4(MoneyUtils.haoToYuan((Long)result.getMemberPrice4()));
            }
            if (result.getMemberPrice5() != null) {
                skuInfoPriceBo.setMemberPrice5(MoneyUtils.haoToYuan((Long)result.getMemberPrice5()));
            }
            if (result.getSalePrice() != null) {
                skuInfoPriceBo.setSalePrice(MoneyUtils.haoToYuan((Long)result.getSalePrice()));
            }
            if (result.getReferencePriceEndSnapshot() != null && result.getReferencePriceStartSnapshot() != null) {
                Long referencePriceStartSnapshot = result.getReferencePriceStartSnapshot();
                Long referencePriceEndSnapshot = result.getReferencePriceEndSnapshot();
                String referenceSnapshotStr = MoneyUtils.haoToYuan((Long)referencePriceStartSnapshot) + "-" + MoneyUtils.haoToYuan((Long)referencePriceEndSnapshot);
                uccSkuItemInfoBO.setReferenceSnapshotStr(referenceSnapshotStr);
                skuInfoPriceBo.setReferenceSnapshotStr(referenceSnapshotStr);
            }
            if (result.getSwitchOn() != null && result.getSwitchOn() == 1) {
                UccLadderPricePO uccLadderPricePO = new UccLadderPricePO();
                uccLadderPricePO.setSkuPriceId(result.getSkuPriceId());
                Integer type = null;
                List uccLadderPricePOList = this.uccLadderPriceMapper.selectByExample(uccLadderPricePO);
                ArrayList<UccLadderPriceInfo> uccLadderPriceInfoList = new ArrayList<UccLadderPriceInfo>();
                if (uccLadderPricePOList != null && !uccLadderPricePOList.isEmpty()) {
                    Iterator iterator = uccLadderPricePOList.iterator();
                    while (iterator.hasNext()) {
                        UccLadderPricePO each = (UccLadderPricePO)iterator.next();
                        UccLadderPriceInfo uccLadderPriceInfo = new UccLadderPriceInfo();
                        BeanUtils.copyProperties((Object)each, (Object)uccLadderPriceInfo);
                        if (each.getType() != null) {
                            type = each.getType();
                        }
                        if (each.getStart() != null) {
                            uccLadderPriceInfo.setStart(MoneyUtils.haoToYuan((Long)each.getStart()));
                        }
                        if (each.getStop() != null) {
                            uccLadderPriceInfo.setStop(MoneyUtils.haoToYuan((Long)each.getStop()));
                        }
                        if (each.getPrice() != null) {
                            uccLadderPriceInfo.setPrice(MoneyUtils.haoToYuan((Long)each.getPrice()));
                        }
                        uccLadderPriceInfoList.add(uccLadderPriceInfo);
                    }
                    skuInfoPriceBo.setType(type);
                    skuInfoPriceBo.setLadderPriceInfo(uccLadderPriceInfoList);
                }
            }
            uccSkuItemInfoBO.setSkuInfoPrice(skuInfoPriceBo);
            if (result.getSalePrice() != null && result.getMarketPrice() != null && result.getMarketPrice() != 0L) {
                uccSkuItemInfoBO.setDiscount(new BigDecimal(result.getSalePrice()).divide(new BigDecimal(result.getMarketPrice()), 2, 4).multiply(new BigDecimal(100)));
            }
        }
        UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
        uccSkuPutCirPo.setSkuId(reqBO.getSkuId());
        uccSkuPutCirPo.setSupplierShopId(reqBO.getSupplierShopId());
        uccSkuPutCirPo.setState(Integer.valueOf(1));
        List uccSkuPutCirPoList = this.uccSkuPutCirMapper.querySkuPutCir(uccSkuPutCirPo);
        ArrayList<SkuPutCirBo> skuPutCir = new ArrayList<SkuPutCirBo>();
        if (uccSkuPutCirPoList != null && !uccSkuPutCirPoList.isEmpty()) {
            for (UccSkuPutCirPo each : uccSkuPutCirPoList) {
                SkuPutCirBo skuPutCirBo = new SkuPutCirBo();
                BeanUtils.copyProperties((Object)each, (Object)skuPutCirBo);
                skuPutCir.add(skuPutCirBo);
            }
        }
        uccSkuItemInfoBO.setSkuPutCir(skuPutCir);
        SkuDataGovernPricePO qrySkuDataGovernPricePo = new SkuDataGovernPricePO();
        qrySkuDataGovernPricePo.setSkuId(uccSkuItemInfoBO.getSkuId());
        SkuDataGovernPricePO skuDataGovernPricePo = this.skuDataGovernPriceMapper.getModelBy(qrySkuDataGovernPricePo);
        if (skuDataGovernPricePo != null) {
            uccSkuItemInfoBO.setReferencePriceStart(skuDataGovernPricePo.getReferencePriceStart());
            uccSkuItemInfoBO.setReferencePricerEnd(skuDataGovernPricePo.getReferencePricerEnd());
            uccSkuItemInfoBO.setAbnormalFloat(skuDataGovernPricePo.getAbnormalFloat());
            uccSkuItemInfoBO.setAbnormalFloatStr(skuDataGovernPricePo.getAbnormalFloatStr());
            uccSkuItemInfoBO.setAbnormalDesc(skuDataGovernPricePo.getAbnormalDesc());
            Map<String, String> expState = this.uccDictionaryAtomService.queryBypCodeBackMap("GOVERN_PRICE_EXP_STATE");
            if (ObjectUtil.isNotEmpty((Object)uccSkuItemInfoBO.getAbnormalDesc())) {
                uccSkuItemInfoBO.setAbnormalDescStr(expState.get(uccSkuItemInfoBO.getAbnormalDesc()));
            }
        }
        Map<String, String> approvalStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap("APPROVAL_STATUS");
        Map<String, String> skuSourceMap = this.uccDictionaryAtomService.queryBypCodeBackMap("SKU_SOURCE");
        Map<String, String> skuStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap("SKU_STATUS");
        Map<String, String> onShelveWayMap = this.uccDictionaryAtomService.queryBypCodeBackMap("SKU_ON_SHELVE_WAY");
        if (uccSkuItemInfoBO.getApprovalStatus() != null && approvalStatusMap != null && approvalStatusMap.containsKey(uccSkuItemInfoBO.getApprovalStatus().toString())) {
            uccSkuItemInfoBO.setApprovalStatusDesc(approvalStatusMap.get(uccSkuItemInfoBO.getApprovalStatus().toString()));
        }
        if (uccSkuItemInfoBO.getSkuSource() != null && skuSourceMap != null && skuSourceMap.containsKey(uccSkuItemInfoBO.getSkuSource().toString())) {
            uccSkuItemInfoBO.setSkuSourceDesc(skuSourceMap.get(uccSkuItemInfoBO.getSkuSource().toString()));
        }
        if (uccSkuItemInfoBO.getSkuStatus() != null && skuStatusMap != null && skuStatusMap.containsKey(uccSkuItemInfoBO.getSkuStatus().toString())) {
            uccSkuItemInfoBO.setSkuStatusDesc(skuStatusMap.get(uccSkuItemInfoBO.getSkuStatus().toString()));
        }
        if (uccSkuItemInfoBO.getOnShelveWay() != null && onShelveWayMap != null && onShelveWayMap.containsKey(uccSkuItemInfoBO.getOnShelveWay().toString())) {
            uccSkuItemInfoBO.setOnShelveWayDec(onShelveWayMap.get(uccSkuItemInfoBO.getOnShelveWay().toString()));
        }
        if (uccSkuItemInfoBO.getSkuSpec() != null && !uccSkuItemInfoBO.getSkuSpec().isEmpty()) {
            ArrayList skuSpecNoGroup = new ArrayList();
            for (UccSkuSpecBO each : uccSkuItemInfoBO.getSkuSpec()) {
                skuSpecNoGroup.addAll(each.getSkuSpecs());
            }
            ArrayList<SkuInfoSpecBo> resultList = new ArrayList<SkuInfoSpecBo>();
            Map<Long, List<SkuInfoSpecBo>> collect1 = skuSpecNoGroup.stream().collect(Collectors.groupingBy(SkuInfoSpecBo::getCommodityPropGrpId));
            for (List<SkuInfoSpecBo> each : collect1.values()) {
                UccCommodityPropGrpPo uccCommodityPropGrpPo = this.uccCommodityPropGrpMapper.queryGroupByGrpId(each.get(0).getCommodityPropGrpId());
                Integer commodityPropGrpType = null;
                if (uccCommodityPropGrpPo != null) {
                    commodityPropGrpType = uccCommodityPropGrpPo.getCommodityPropGrpType();
                }
                Map<Long, List<SkuInfoSpecBo>> collect2 = each.stream().collect(Collectors.groupingBy(SkuInfoSpecBo::getCommodityPropDefId));
                for (List<SkuInfoSpecBo> each2 : collect2.values()) {
                    SkuInfoSpecBo skuInfoSpecBo = new SkuInfoSpecBo();
                    String strEach2 = JSONObject.toJSONString((Object)each2.get(0), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                    skuInfoSpecBo = (SkuInfoSpecBo)JSONObject.parseObject((String)strEach2, SkuInfoSpecBo.class);
                    skuInfoSpecBo.setCommodityPropGrpType(commodityPropGrpType);
                    skuInfoSpecBo.setPropValue("");
                    skuInfoSpecBo.setPropValueListId(null);
                    for (SkuInfoSpecBo skuInfoSpecBo2 : each2) {
                        String i = "\uff0c";
                        if (org.springframework.util.StringUtils.isEmpty((Object)skuInfoSpecBo.getPropValue())) {
                            i = "";
                        }
                        skuInfoSpecBo.setPropValue(skuInfoSpecBo.getPropValue() + i + skuInfoSpecBo2.getPropValue());
                    }
                    resultList.add(skuInfoSpecBo);
                }
            }
            resultList.sort(new Comparator<SkuInfoSpecBo>(){

                @Override
                public int compare(SkuInfoSpecBo o1, SkuInfoSpecBo o2) {
                    return o1.getCommodityPropGrpType() - o2.getCommodityPropGrpType();
                }
            });
            uccSkuItemInfoBO.setSkuSpecNoGroup(resultList);
        }
        ArrayList<Long> skus = new ArrayList<Long>();
        skus.add(uccSkuItemInfoBO.getSkuId());
        List uccSkuAddCoefficientPOList = this.uccSkuAddCoefficientMapper.selectBySkuIds(skus);
        if (!CollectionUtils.isEmpty((Collection)uccSkuAddCoefficientPOList)) {
            uccSkuItemInfoBO.setMarkupRate(((UccSkuAddCoefficientPO)uccSkuAddCoefficientPOList.get(0)).getAddCoefficient());
        } else {
            HashSet<Long> catalogIds = new HashSet<Long>();
            catalogIds.add(uccSkuItemInfoBO.getCatalogId());
            if (!catalogIds.isEmpty()) {
                List addCoefficientPOS = this.uccAddCoefficientMapper.qryCoefficientByCatalogIds(new ArrayList(catalogIds), null);
                if (!CollectionUtils.isEmpty((Collection)addCoefficientPOS)) {
                    uccSkuItemInfoBO.setMarkupRate(((UccAddCoefficientPO)addCoefficientPOS.get(0)).getAddCoefficient());
                } else {
                    UccConfigurationparametersDetailAbilityReqBO parametersDetailAbilityReqBO = new UccConfigurationparametersDetailAbilityReqBO();
                    parametersDetailAbilityReqBO.setParamsCode("ESTORE_DEFAULT_COEFFICIENT");
                    UccConfigurationparametersDetailAbilityRspBO detailAbilityRspBO = this.uccConfigurationparametersDetailAbilityService.getparametersDetail(parametersDetailAbilityReqBO);
                    if ("0000".equals(detailAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)detailAbilityRspBO.getRows())) {
                        uccSkuItemInfoBO.setMarkupRate(new BigDecimal(((UccConfigurationparametersQryBO)detailAbilityRspBO.getRows().get(0)).getRule()));
                    }
                }
            }
        }
        UccCommodityPropGrpPo uccCommodityPropGrpPo = new UccCommodityPropGrpPo();
        uccCommodityPropGrpPo.setCommodityTypeId(uccSkuItemInfoBO.getCommodityTypeId());
        uccCommodityPropGrpPo.setCommodityPropGrpType(Integer.valueOf(2));
        SkuDataGovernPO skuDataGovernPo = new SkuDataGovernPO();
        skuDataGovernPo.setSkuId(reqBO.getSkuId());
        SkuDataGovernPO skuDataGovern = this.skuDataGovernMapper.getModelBy(skuDataGovernPo);
        if (skuDataGovern != null && skuDataGovern.getResult() == 1) {
            uccSkuItemInfoBO.setGovernResult(Integer.valueOf(1));
        } else {
            uccSkuItemInfoBO.setGovernResult(Integer.valueOf(0));
        }
        List uccCommodityPropGrpPos = this.uccCommodityPropGrpMapper.queryGroupByPO(uccCommodityPropGrpPo);
        if (uccCommodityPropGrpPos.size() > 0) {
            UccCommodityPropGrpPo uccCommodityPropGrp = (UccCommodityPropGrpPo)uccCommodityPropGrpPos.get(0);
            UccSkuPropBO uccSkuPropBO = new UccSkuPropBO();
            uccSkuPropBO.setCommodityPropGrpId(uccCommodityPropGrp.getCommodityPropGrpId());
            uccSkuPropBO.setCommodityPropGrpName(uccCommodityPropGrp.getCommodityPropGrpName());
            SkuDataGovernPropPO skuDataGovernPropPo = new SkuDataGovernPropPO();
            skuDataGovernPropPo.setSkuId(reqBO.getSkuId());
            List list = this.skuDataGovernPropMapper.getList(skuDataGovernPropPo);
            List skuDataGovernProps = com.tydic.commodity.base.utils.BeanUtils.copyProperties((List)list, SkuDataGovernPropBO.class);
            uccSkuPropBO.setSkuPropList(skuDataGovernProps);
            uccSkuItemInfoBO.setSkuProps(Stream.of(uccSkuPropBO).collect(Collectors.toList()));
        }
        rspBO.setSkuItem(uccSkuItemInfoBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"checkSpecModel"})
    public UccPublicRspBO checkSpecModel(@RequestBody UccPublicReqBO reqBO) {
        UccPublicRspBO rspBO = new UccPublicRspBO();
        ArrayList<UccSkuPo> rspList = new ArrayList<UccSkuPo>();
        rspBO.setRows(rspList);
        List skuIds = (List)reqBO.getM().get("skuIds");
        List uccSkuList = this.uccSkuMapper.qeryBatchSkus(skuIds);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccSkuList)) {
            throw new BusinessException("8888", "sku_id\u672a\u67e5\u5230\u76f8\u5173\u4fe1\u606f");
        }
        for (UccSkuPo uccSkuPo : uccSkuList) {
            if (StringUtils.isBlank((CharSequence)uccSkuPo.getSpec()) && StringUtils.isBlank((CharSequence)uccSkuPo.getModel()) || StringUtils.isNotBlank((CharSequence)uccSkuPo.getSpec()) && StringUtils.isNotBlank((CharSequence)uccSkuPo.getModel()) && uccSkuPo.getSpec().equals(uccSkuPo.getModel())) {
                rspList.add(uccSkuPo);
                continue;
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)uccSkuPo.getModel()) && UccSkuManagementAbilityServiceImpl.getLength(uccSkuPo.getModel()) > 40) {
                rspList.add(uccSkuPo);
                continue;
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)uccSkuPo.getSpec()) && UccSkuManagementAbilityServiceImpl.getLength(uccSkuPo.getSpec()) > 40) {
                rspList.add(uccSkuPo);
                continue;
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)uccSkuPo.getSpec()) || org.springframework.util.StringUtils.isEmpty((Object)uccSkuPo.getModel()) || UccSkuManagementAbilityServiceImpl.getLength(uccSkuPo.getSpec() + uccSkuPo.getModel()) <= 40) continue;
            rspList.add(uccSkuPo);
        }
        return rspBO;
    }

    @PostMapping(value={"checkSkuName"})
    public UccPublicRspBO checkSkuName(@RequestBody UccPublicReqBO reqBO) {
        UccPublicRspBO rspBO = new UccPublicRspBO();
        ArrayList<UccSkuPo> rspList = new ArrayList<UccSkuPo>();
        rspBO.setRows(rspList);
        List skuIds = (List)reqBO.getM().get("skuIds");
        List uccSkuList = this.uccSkuMapper.qeryBatchSkus(skuIds);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccSkuList)) {
            throw new BusinessException("8888", "sku_id\u672a\u67e5\u5230\u76f8\u5173\u4fe1\u606f");
        }
        List allBlackWord = this.uccSearchWordBlackMapper.getAllBlackWord();
        for (UccSkuPo uccSkuPo : uccSkuList) {
            for (String blackWord : allBlackWord) {
                if (!uccSkuPo.getSkuName().contains(blackWord)) continue;
                rspList.add(uccSkuPo);
            }
        }
        return rspBO;
    }

    public static int getLength(String str) {
        if (org.springframework.util.StringUtils.isEmpty((Object)str)) {
            return 0;
        }
        int leng = 0;
        char[] array = str.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            String item = String.valueOf(array[i]);
            if (item.matches("[\\x00-\\xff]")) {
                ++leng;
                continue;
            }
            leng += 2;
        }
        return leng;
    }

    public static int getStringLengthByByte(String value) {
        if (org.springframework.util.StringUtils.isEmpty((Object)value)) {
            return 0;
        }
        int valueLength = 0;
        for (int i = 0; i < value.length(); ++i) {
            char temp = value.charAt(i);
            if ((temp + "").getBytes().length == 1) {
                ++valueLength;
                continue;
            }
            valueLength += 2;
        }
        return valueLength;
    }

    @PostMapping(value={"selectBrandAddPrice"})
    public UccPublicRspBO selectBrandAddPrice(@RequestBody UccPublicReqBO reqBO) {
        UccPublicRspBO rspBO = new UccPublicRspBO();
        UccBrandAddPriceAbilityBO uccBrandAddPriceAbilityBO = (UccBrandAddPriceAbilityBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getT()), UccBrandAddPriceAbilityBO.class);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List uccBrandAddPricePOS = this.uccBrandAddPriceMapper.selectAllPage(uccBrandAddPriceAbilityBO, page);
        rspBO.setRows(JSON.parseArray((String)JSON.toJSONString((Object)uccBrandAddPricePOS), UccBrandAddPriceAbilityBO.class));
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(rspBO.getPageNo());
        return rspBO;
    }

    @PostMapping(value={"insertBrandAddPrice"})
    public UccPublicRspBO insertBrandAddPrice(@RequestBody UccPublicReqBO reqBO) {
        UccPublicRspBO rspBO = new UccPublicRspBO();
        List uccBrandAddPriceAbilityBOS = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getT()), UccBrandAddPriceAbilityBO.class);
        for (UccBrandAddPriceAbilityBO uccBrandAddPriceAbilityBO : uccBrandAddPriceAbilityBOS) {
            UccBrandAddPricePO uccBrandAddPricePO = (UccBrandAddPricePO)JSON.parseObject((String)JSON.toJSONString((Object)uccBrandAddPriceAbilityBO), UccBrandAddPricePO.class);
            int i = this.uccBrandAddPriceMapper.selectOnly(uccBrandAddPricePO);
            if (i > 0) continue;
            long l = Sequence.getInstance().nextId();
            uccBrandAddPricePO.setCreateTime(new Date());
            uccBrandAddPricePO.setUpdateTime(new Date());
            uccBrandAddPricePO.setCreateUserId(reqBO.getUsername());
            uccBrandAddPricePO.setCreateUserName(reqBO.getName());
            uccBrandAddPricePO.setIsDelete(Integer.valueOf(0));
            UccBrandAddPriceLogPO uccBrandAddPriceLogPO = (UccBrandAddPriceLogPO)JSON.parseObject((String)JSON.toJSONString((Object)uccBrandAddPricePO), UccBrandAddPriceLogPO.class);
            uccBrandAddPricePO.setId(Long.valueOf(l));
            uccBrandAddPriceLogPO.setBrandAddPriceId(Long.valueOf(l));
            uccBrandAddPriceLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            uccBrandAddPriceLogPO.setIsDelete(Integer.valueOf(0));
            uccBrandAddPriceLogPO.setIsFlag(Integer.valueOf(0));
            this.uccBrandAddPriceMapper.insert(uccBrandAddPricePO);
            this.uccBrandAddPriceLogMapper.insert(uccBrandAddPriceLogPO);
        }
        return rspBO;
    }

    @PostMapping(value={"updateBrandAddPrice"})
    public UccPublicRspBO updateBrandAddPrice(@RequestBody UccPublicReqBO reqBO) {
        UccPublicRspBO rspBO = new UccPublicRspBO();
        List uccBrandAddPriceAbilityBOS = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getT()), UccBrandAddPriceAbilityBO.class);
        for (UccBrandAddPriceAbilityBO uccBrandAddPriceAbilityBO : uccBrandAddPriceAbilityBOS) {
            UccBrandAddPricePO uccBrandAddPricePO = (UccBrandAddPricePO)JSON.parseObject((String)JSON.toJSONString((Object)uccBrandAddPriceAbilityBO), UccBrandAddPricePO.class);
            UccBrandAddPriceLogPO uccBrandAddPriceLogPO = new UccBrandAddPriceLogPO();
            uccBrandAddPriceLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            uccBrandAddPriceLogPO.setBrandAddPriceId(uccBrandAddPriceAbilityBO.getId());
            uccBrandAddPriceLogPO.setCreateTime(new Date());
            uccBrandAddPriceLogPO.setIsDelete(Integer.valueOf(0));
            uccBrandAddPriceLogPO.setIsFlag(Integer.valueOf(0));
            uccBrandAddPriceLogPO.setCreateUserId(reqBO.getUsername());
            uccBrandAddPriceLogPO.setCreateUserName(reqBO.getName());
            uccBrandAddPriceLogPO.setAddCoefficient(uccBrandAddPriceAbilityBO.getAddCoefficient());
            uccBrandAddPriceLogPO.setAllowMarketPrice(uccBrandAddPriceAbilityBO.getAllowMarketPrice());
            this.uccBrandAddPriceMapper.updateById(uccBrandAddPricePO);
            this.uccBrandAddPriceLogMapper.updateByAddPriceId(uccBrandAddPriceAbilityBO.getId());
            this.uccBrandAddPriceLogMapper.insert(uccBrandAddPriceLogPO);
        }
        return rspBO;
    }

    @PostMapping(value={"deleteBrandAddPrice"})
    public UccPublicRspBO deleteBrandAddPrice(@RequestBody UccPublicReqBO reqBO) {
        UccPublicRspBO rspBO = new UccPublicRspBO();
        List uccBrandAddPriceAbilityBOS = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getT()), UccBrandAddPriceAbilityBO.class);
        List ids = uccBrandAddPriceAbilityBOS.stream().map(a -> a.getId()).collect(Collectors.toList());
        this.uccBrandAddPriceMapper.deleteByBatchId(ids);
        this.uccBrandAddPriceLogMapper.deleteByBatchId(ids);
        return rspBO;
    }

    @PostMapping(value={"selectBrandAddPriceLog"})
    public UccPublicRspBO selectBrandAddPriceLog(@RequestBody UccPublicReqBO reqBO) {
        UccPublicRspBO rspBO = new UccPublicRspBO();
        String id = String.valueOf(reqBO.getM().get("id"));
        UccBrandAddPriceLogPO uccBrandAddPriceLogPO = new UccBrandAddPriceLogPO();
        uccBrandAddPriceLogPO.setBrandAddPriceId(Long.valueOf(id));
        List uccBrandAddPriceLogPOS = this.uccBrandAddPriceLogMapper.selectAll(uccBrandAddPriceLogPO);
        rspBO.setRows(JSON.parseArray((String)JSON.toJSONString((Object)uccBrandAddPriceLogPOS), UccBrandAddPriceLogBO.class));
        return rspBO;
    }

    @PostMapping(value={"timingBrandAddPrice"})
    public UccPublicRspBO timingBrandAddPrice(@RequestBody UccPublicReqBO reqBO) {
        UccPublicRspBO rspBO = new UccPublicRspBO();
        List uccSkuPos = this.uccBrandAddPriceLogMapper.selectSkuByAddPriceLog();
        if (!ObjectUtils.isEmpty((Object)uccSkuPos)) {
            Map<Long, List<UccBrandAddPriceLogSkuBO>> skuMap = uccSkuPos.stream().collect(Collectors.groupingBy(a -> a.getSupplierShopId()));
            for (Map.Entry<Long, List<Object>> entry : skuMap.entrySet()) {
                List eachSkuIds = entry.getValue().stream().map(a -> a.getSkuId()).collect(Collectors.toList());
                UccMallCurrentPriceQryReqBO uccMallCurrentPriceQryReqBO = new UccMallCurrentPriceQryReqBO();
                uccMallCurrentPriceQryReqBO.setSkuIds(eachSkuIds);
                uccMallCurrentPriceQryReqBO.setSupplierShopId(entry.getKey());
                this.uccMallCurrentPriceQryAbilityService.changeCommdCurrentPrice(uccMallCurrentPriceQryReqBO);
            }
        }
        List ids = uccSkuPos.stream().map(a -> a.getId()).collect(Collectors.toList());
        for (Long l : ids) {
            this.uccBrandAddPriceLogMapper.updateTimeByAddPriceId(l);
        }
        return rspBO;
    }

    @PostMapping(value={"checkTaxCode"})
    public UccPublicRspBO checkTaxCode(@RequestBody UccPublicReqBO reqBO) {
        UccPublicRspBO rspBO = new UccPublicRspBO();
        List taxCatalogs = (List)reqBO.getM().get("taxCatalogs");
        if (!ObjectUtils.isEmpty((Object)taxCatalogs)) {
            ArrayList fail = new ArrayList();
            UccPublicRspBO taxCatCode = this.uccUpperTaxCatCodeQryAbilityService.selectTaxCataLog(new UccUpperTaxCatCodeQryAbilityReqBo());
            log.info("^^^^^^^^^^^^^^^^^^^^reqBOreqBO^^^{}~~~~~~taxCatCode{}", (Object)JSON.toJSONString((Object)reqBO), (Object)JSON.toJSONString((Object)taxCatCode));
            if (ObjectUtils.isEmpty((Object)taxCatCode) || ObjectUtils.isEmpty((Object)taxCatCode.getT())) {
                throw new BusinessException("8888", "\u7a0e\u63a7\u7f16\u7801\u67e5\u8be2\u4e3a\u7a7a");
            }
            List taxCatCodes = (List)taxCatCode.getT();
            List taxCodes = taxCatCodes.stream().map(a -> a.getTaxCode()).collect(Collectors.toList());
            taxCatalogs.forEach(a -> {
                if (!taxCodes.contains(a)) {
                    fail.add(a);
                }
            });
            rspBO.setT(fail);
        }
        return rspBO;
    }

    public static void main(String[] args) {
        UccPublicReqBO reqBO = new UccPublicReqBO();
        HashMap m = new HashMap();
        ArrayList<String> s = new ArrayList<String>();
        s.add("4040000000000000000");
        s.add("1010105000000000000");
        s.add("1010106000000000000");
        s.add("1111");
        m.put("taxCatalogs", s);
        reqBO.setM(m);
        UccPublicRspBO rspBO = new UccPublicRspBO();
        List taxCatalogs = (List)reqBO.getM().get("taxCatalogs");
        if (!ObjectUtils.isEmpty((Object)taxCatalogs)) {
            ArrayList fail = new ArrayList();
            UccPublicRspBO taxCatCode = new UccPublicRspBO();
            ArrayList<UccCommodityTaxTypePO> ts = new ArrayList<UccCommodityTaxTypePO>();
            taxCatCode.setT(ts);
            UccCommodityTaxTypePO po1 = new UccCommodityTaxTypePO();
            po1.setTaxId(Long.valueOf(170L));
            po1.setTaxName("\u68c9\u82b1");
            po1.setTaxCode("1010105000000000000");
            ts.add(po1);
            UccCommodityTaxTypePO po2 = new UccCommodityTaxTypePO();
            po2.setTaxId(Long.valueOf(171L));
            po2.setTaxName("\u751f\u9ebb");
            po2.setTaxCode("1010106000000000000");
            ts.add(po2);
            UccCommodityTaxTypePO po3 = new UccCommodityTaxTypePO();
            po3.setTaxId(Long.valueOf(172L));
            po3.setTaxName("\u7cd6\u6599");
            po3.setTaxCode("1010107000000000000");
            ts.add(po3);
            List taxCatCodes = (List)taxCatCode.getT();
            List taxCodes = taxCatCodes.stream().map(a -> a.getTaxCode()).collect(Collectors.toList());
            taxCatalogs.forEach(a -> {
                if (!taxCodes.contains(a)) {
                    fail.add(a);
                }
            });
            rspBO.setT(fail);
            System.out.println(JSON.toJSONString((Object)rspBO));
        }
    }

    @Autowired
    public void setSkuDataGovernMapper(SkuDataGovernMapper skuDataGovernMapper) {
        this.skuDataGovernMapper = skuDataGovernMapper;
    }

    @Autowired
    public void setSkuDataGovernPropMapper(SkuDataGovernPropMapper skuDataGovernPropMapper) {
        this.skuDataGovernPropMapper = skuDataGovernPropMapper;
    }

    @Autowired
    public void setUccCommodityMapper(UccCommodityMapper uccCommodityMapper) {
        this.uccCommodityMapper = uccCommodityMapper;
    }
}

