/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.google.common.collect.Lists;
import com.tydic.commodity.base.constant.FuzzyFieldsEnum;
import com.tydic.commodity.busibase.busi.bo.SearchEsManageReqBo;
import com.tydic.commodity.busibase.comb.api.SearchCommodityManageService;
import com.tydic.commodity.busibase.comb.api.UccConfigurationparametersDetailCombService;
import com.tydic.commodity.busibase.comb.bo.SearchCommodityManageRspBo;
import com.tydic.commodity.busibase.comb.bo.UccConfigurationparametersCombQryBO;
import com.tydic.commodity.busibase.comb.bo.UccConfigurationparametersDetailCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccConfigurationparametersDetailCombRspBO;
import com.tydic.commodity.common.ability.api.UccSkuPoolRelDataQryListAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuPoolRelDataQryListAbilityBo;
import com.tydic.commodity.common.ability.bo.UccSkuPoolRelDataQryListAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccSkuPoolRelDataQryListAbilityRspBo;
import com.tydic.commodity.dao.UccAddCoefficientMapper;
import com.tydic.commodity.dao.UccCommodityPoolMapper;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.po.UccCommodityPoolPO;
import com.tydic.commodity.po.UccSkuAddCoefficientPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuPoolRelDataQryListAbilityService"})
public class UccSkuPoolRelDataQryListAbilityServiceImpl
implements UccSkuPoolRelDataQryListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuPoolRelDataQryListAbilityServiceImpl.class);
    @Autowired
    private SearchCommodityManageService searchCommodityManageService;
    @Autowired
    private UccCommodityPoolMapper uccCommodityPoolMapper;
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    @Autowired
    private UccAddCoefficientMapper uccAddCoefficientMapper;
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccConfigurationparametersDetailCombService uccConfigurationparametersDetailAbilityService;

    @PostMapping(value={"qrySkuPoolRelDataList"})
    public UccSkuPoolRelDataQryListAbilityRspBo qrySkuPoolRelDataList(@RequestBody UccSkuPoolRelDataQryListAbilityReqBo reqBo) {
        UccSkuPoolRelDataQryListAbilityRspBo rspBo = new UccSkuPoolRelDataQryListAbilityRspBo();
        if (reqBo.getPoolId() == null) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u8f93\u5165\u5546\u54c1\u6c60ID");
            return rspBo;
        }
        SearchEsManageReqBo searchEsManageReqBo = new SearchEsManageReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)searchEsManageReqBo);
        searchEsManageReqBo.setSkuName(reqBo.getSkuName());
        searchEsManageReqBo.setSkuCode(reqBo.getSkuCode());
        searchEsManageReqBo.setCommodityCode(reqBo.getCommodityCode());
        searchEsManageReqBo.setCommodityName(reqBo.getCommodityName());
        if (reqBo.getSkuId() != null) {
            searchEsManageReqBo.setSkuList((List)Lists.newArrayList((Object[])new Long[]{reqBo.getSkuId()}));
        }
        if (reqBo.getPoolId() != null) {
            searchEsManageReqBo.setPoolIds((List)Lists.newArrayList((Object[])new Long[]{reqBo.getPoolId()}));
        }
        if (reqBo.getType() == 1) {
            searchEsManageReqBo.setIsFieldSku(Boolean.valueOf(false));
        }
        searchEsManageReqBo.setTypeId(reqBo.getCommodityTypeId());
        searchEsManageReqBo.setVendorId(reqBo.getVendorId());
        searchEsManageReqBo.setAgreementIds(reqBo.getAgreementIds());
        searchEsManageReqBo.setBrandId(reqBo.getBrandId());
        searchEsManageReqBo.setPageSize(Integer.valueOf(reqBo.getPageSize()));
        searchEsManageReqBo.setPageNo(Integer.valueOf(reqBo.getPageNo()));
        List fuzzyFields = FuzzyFieldsEnum.getAllField();
        fuzzyFields.add("commodityName");
        fuzzyFields.add("commodityCode");
        searchEsManageReqBo.setFuzzyFields(fuzzyFields);
        searchEsManageReqBo.setMinDiscounts(reqBo.getDiscountStar());
        searchEsManageReqBo.setMaxDiscounts(reqBo.getDiscountEnd());
        searchEsManageReqBo.setMinSalesPrice(reqBo.getSalePriceStar());
        searchEsManageReqBo.setMaxSalesPrice(reqBo.getSalePriceEnd());
        searchEsManageReqBo.setMinMarketPrice(reqBo.getMarketPriceStar());
        searchEsManageReqBo.setMaxMarketPrice(reqBo.getMarketPriceEnd());
        if (!StringUtils.isEmpty((Object)reqBo.getStatus())) {
            searchEsManageReqBo.setSkuStatus(Arrays.asList(reqBo.getStatus()));
        }
        ArrayList<UccSkuPoolRelDataQryListAbilityBo> uccSkuPoolRelDataQryListAbilityBos = new ArrayList<UccSkuPoolRelDataQryListAbilityBo>();
        try {
            SearchCommodityManageRspBo searchCommodityManageRspBo = this.searchCommodityManageService.searchCommodity(searchEsManageReqBo);
            if ("0000".equals(searchCommodityManageRspBo.getRespCode())) {
                if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)searchCommodityManageRspBo.getResult())) {
                    searchCommodityManageRspBo.getResult().forEach(each -> {
                        UccSkuPoolRelDataQryListAbilityBo uccSkuPoolRelDataQryListAbilityBo = new UccSkuPoolRelDataQryListAbilityBo();
                        BeanUtils.copyProperties((Object)each, (Object)uccSkuPoolRelDataQryListAbilityBo);
                        uccSkuPoolRelDataQryListAbilityBo.setPicUrl(each.getComPicUrl());
                        if (uccSkuPoolRelDataQryListAbilityBo.getAgreementId() != null && uccSkuPoolRelDataQryListAbilityBo.getAgreementId() == 0L) {
                            uccSkuPoolRelDataQryListAbilityBo.setAgreementId(null);
                        }
                        uccSkuPoolRelDataQryListAbilityBos.add(uccSkuPoolRelDataQryListAbilityBo);
                    });
                }
            } else {
                rspBo.setRespCode("0000");
                rspBo.setRespDesc(searchCommodityManageRspBo.getRespDesc());
                return rspBo;
            }
            rspBo.setPageNo(reqBo.getPageNo());
            rspBo.setRecordsTotal(searchCommodityManageRspBo.getRecordsTotal());
            rspBo.setTotal(searchCommodityManageRspBo.getTotal());
            this.getCancelFlag(reqBo.getPoolId(), uccSkuPoolRelDataQryListAbilityBos);
            rspBo.setRows(uccSkuPoolRelDataQryListAbilityBos);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u67e5\u8be2\u5931\u8d25\uff01");
            return rspBo;
        }
        UccCommodityPoolPO uccCommodityPoolPO = this.uccCommodityPoolMapper.selectByPrimaryKey(reqBo.getPoolId());
        if (uccCommodityPoolPO != null) {
            rspBo.setRelSkuType(uccCommodityPoolPO.getPoolRelated());
        }
        this.markupRatePv(rspBo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void getCancelFlag(Long poolId, List<UccSkuPoolRelDataQryListAbilityBo> rows) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(rows)) {
            return;
        }
        Set spuList = rows.stream().map(a -> a.getCommodityId()).collect(Collectors.toSet());
        Set skuList = rows.stream().map(a -> a.getSkuId()).collect(Collectors.toSet());
        spuList.addAll(skuList);
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(4);
        types.add(5);
        List uccRelPoolCommodityPos = this.uccRelPoolCommodityMapper.queryPoolsBySourceAndPool(poolId, (List)Lists.newArrayList(spuList), types);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccRelPoolCommodityPos)) {
            rows.forEach(each -> each.setCancelFlag(Integer.valueOf(0)));
        } else {
            Set spuIds = uccRelPoolCommodityPos.stream().map(a -> a.getSource()).collect(Collectors.toSet());
            rows.forEach(each -> {
                if (!spuIds.contains(each.getCommodityId()) && !spuIds.contains(each.getSkuId())) {
                    each.setCancelFlag(Integer.valueOf(0));
                } else {
                    each.setCancelFlag(Integer.valueOf(1));
                }
            });
        }
    }

    private void markupRatePv(UccSkuPoolRelDataQryListAbilityRspBo rspBO) {
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            List addCoefficientPOS;
            List skus = rspBO.getRows().stream().map(a -> a.getSkuId()).collect(Collectors.toList());
            List uccSkuAddCoefficientPOList = this.uccSkuAddCoefficientMapper.selectBySkuIds(skus);
            Map<Object, Object> skuCoefficient = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)uccSkuAddCoefficientPOList)) {
                skuCoefficient = uccSkuAddCoefficientPOList.stream().collect(Collectors.toMap(UccSkuAddCoefficientPO::getSkuId, UccSkuAddCoefficientPO::getAddCoefficient));
            }
            HashSet catalogIds = new HashSet();
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
                rspBO.getRows().forEach(a -> {
                    if (a.getL4mgCategoryId() != null) {
                        catalogIds.add(a.getL4mgCategoryId());
                    }
                });
            }
            HashMap typeCoefficient = new HashMap();
            if (!catalogIds.isEmpty() && !CollectionUtils.isEmpty((Collection)(addCoefficientPOS = this.uccAddCoefficientMapper.qryCoefficientByCatalogIds(new ArrayList(catalogIds), null)))) {
                addCoefficientPOS.forEach(a -> typeCoefficient.put("" + a.getCatalogId() + a.getSupplierShopId(), a.getAddCoefficient()));
            }
            BigDecimal defaultCoefficient = null;
            UccConfigurationparametersDetailCombReqBO parametersDetailAbilityReqBO = new UccConfigurationparametersDetailCombReqBO();
            parametersDetailAbilityReqBO.setParamsCode("ESTORE_DEFAULT_COEFFICIENT");
            UccConfigurationparametersDetailCombRspBO detailAbilityRspBO = this.uccConfigurationparametersDetailAbilityService.getparametersDetail(parametersDetailAbilityReqBO);
            if ("0000".equals(detailAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)detailAbilityRspBO.getRows())) {
                defaultCoefficient = new BigDecimal(((UccConfigurationparametersCombQryBO)detailAbilityRspBO.getRows().get(0)).getRule());
            }
            for (UccSkuPoolRelDataQryListAbilityBo each : rspBO.getRows()) {
                if (skuCoefficient.containsKey(each.getSkuId())) {
                    each.setMarkupRate((BigDecimal)skuCoefficient.get(each.getSkuId()));
                    continue;
                }
                if (typeCoefficient.containsKey("" + each.getL4mgCategoryId() + each.getSupplierShopId())) {
                    each.setMarkupRate((BigDecimal)typeCoefficient.get("" + each.getL4mgCategoryId() + each.getSupplierShopId()));
                    continue;
                }
                if (defaultCoefficient == null) continue;
                each.setMarkupRate(defaultCoefficient);
            }
        }
    }
}

