/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.enumType.CommodityEnum;
import com.tydic.commodity.common.ability.api.UccSpuManagementListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccEsCommodityBo;
import com.tydic.commodity.common.ability.bo.UccSpuManagementListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuManagementListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSpuManagementListQryBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSpuManagementListQryAbilityService"})
public class UccSpuManagementListQryAbilityServiceImpl
implements UccSpuManagementListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSpuManagementListQryAbilityServiceImpl.class);
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;

    @PostMapping(value={"getSpuManagementListQry"})
    public UccSpuManagementListQryAbilityRspBO getSpuManagementListQry(@RequestBody UccSpuManagementListQryAbilityReqBO reqBO) {
        List mdmCatalogPOS;
        List commodityTypeIds;
        BoolQueryBuilder extBoolQueryBuilder;
        String queryString;
        String result;
        UccSpuManagementListQryAbilityRspBO rspBo = new UccSpuManagementListQryAbilityRspBO();
        if (reqBO.getIsNoAgrSku() != null && reqBO.getOrgId() != null) {
            if (!CollectionUtils.isEmpty((Collection)reqBO.getCommodityStatus()) && reqBO.getCommodityStatus().size() == 1 && (Integer)reqBO.getCommodityStatus().get(0) == 0 || !CollectionUtils.isEmpty((Collection)reqBO.getStatus()) && reqBO.getStatus().size() == 1 && (Integer)reqBO.getStatus().get(0) == 0) {
                reqBO.setSupplierOrgId(reqBO.getOrgId().toString());
            } else if ("0".equals(reqBO.getIsprofess())) {
                if (!StringUtils.isEmpty((Object)reqBO.getRunMainBodyId()) && !reqBO.getOrgPath().contains(reqBO.getRunMainBodyId())) {
                    rspBo.setTotal(0);
                    rspBo.setRespCode("0000");
                    rspBo.setRecordsTotal(0);
                    rspBo.setRows(new ArrayList());
                    return rspBo;
                }
                if (StringUtils.isEmpty((Object)reqBO.getRunMainBodyId())) {
                    String[] orgIds = reqBO.getOrgPath().split("-");
                    reqBO.setRunMainBodyIds(Arrays.asList(orgIds));
                }
            } else {
                reqBO.setSupplierOrgId(reqBO.getOrgId().toString());
            }
        }
        if (StringUtils.isEmpty((Object)(result = this.searchInfo(queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder = this.buildEsSql(reqBO)))))) {
            rspBo.setTotal(0);
            rspBo.setRespCode("0000");
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        rspBo = this.dealSearchData(result, reqBO);
        if (!(CollectionUtils.isEmpty((Collection)rspBo.getRows()) || CollectionUtils.isEmpty(commodityTypeIds = rspBo.getRows().stream().filter(e -> e.getCommodityTypeId() != null).map(UccSpuManagementListQryBO::getCommodityTypeId).collect(Collectors.toList())) || CollectionUtils.isEmpty((Collection)(mdmCatalogPOS = this.uccEMdmCatalogMapper.getListByType(commodityTypeIds))))) {
            Map<Long, List<UccEMdmCatalogPO>> commodityTypeIdMap = mdmCatalogPOS.stream().filter(e -> e.getCommodityTypeId() != null).collect(Collectors.groupingBy(UccEMdmCatalogPO::getCommodityTypeId));
            for (UccSpuManagementListQryBO bo : rspBo.getRows()) {
                if (bo.getCommodityTypeId() == null || !commodityTypeIdMap.keySet().contains(bo.getCommodityTypeId())) continue;
                bo.setCatalogCode(commodityTypeIdMap.get(bo.getCommodityTypeId()).get(0).getCatalogCode());
            }
        }
        return rspBo;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private BoolQueryBuilder buildEsSql(UccSpuManagementListQryAbilityReqBO reqBo) {
        WildcardQueryBuilder wildcardQuery;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBo.getSkuSource() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)reqBo.getSkuSource()));
        }
        if (reqBo.getSourceAssort() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sourceAssort", (Object)reqBo.getSourceAssort()));
        }
        if (reqBo.getBelongModule() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"belongModule", (Object)reqBo.getBelongModule()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getRunMainBodyId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"runMainBodyId.keyword", (String)reqBo.getRunMainBodyId()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getRunMainBodyIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"runMainBodyId.keyword", (Collection)reqBo.getRunMainBodyIds()));
        }
        if (reqBo.getApprovalStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"spu_approval_status", (Object)reqBo.getApprovalStatus()));
        }
        if (reqBo.getBrandId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)reqBo.getBrandId()));
        }
        if (reqBo.getVendorId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)reqBo.getVendorId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityTypeId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_id", (Object)reqBo.getCommodityTypeId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_id", (String)reqBo.getCommodityId()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExportCommodityIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_id", (Collection)reqBo.getExportCommodityIds()));
        }
        if (reqBo.getL4mgCategoryId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"L4mg_category_id", (Object)reqBo.getL4mgCategoryId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"create_oper_id", (String)reqBo.getCreateOperId()));
        }
        if (reqBo.getSupplierShopId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_shop_id", (Object)reqBo.getSupplierShopId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSupplierOrgId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_org_id", (String)reqBo.getSupplierOrgId()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOperIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operIds", (Collection)reqBo.getOperIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getCommodityStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_status", (Collection)reqBo.getCommodityStatus()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_status", (Collection)reqBo.getStatus()));
        }
        if (reqBo.getAgreementId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_id", (Object)reqBo.getAgreementId()));
        }
        if (reqBo.getAgreementDetailsId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_details_id", (Object)reqBo.getAgreementDetailsId()));
        }
        if (reqBo.getIsSupermarketStaff() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"isSupermarketStaff", (Object)reqBo.getIsSupermarketStaff()));
        } else {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"isSupermarketStaff", (String)"1"));
        }
        if (reqBo.getTradeMode() != null && reqBo.getTradeMode() == 2) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"tradeMode", (Object)reqBo.getTradeMode()));
        } else if (reqBo.getTradeMode() != null && reqBo.getTradeMode() == 1) {
            BoolQueryBuilder boolQueryBuilderSon1 = QueryBuilders.boolQuery();
            BoolQueryBuilder boolQueryBuilderSon2 = QueryBuilders.boolQuery();
            BoolQueryBuilder boolQueryBuilderSon3 = QueryBuilders.boolQuery();
            boolQueryBuilderSon2.must((QueryBuilder)QueryBuilders.termQuery((String)"tradeMode", (Object)reqBo.getTradeMode()));
            boolQueryBuilderSon3.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"tradeMode"));
            boolQueryBuilderSon1.should((QueryBuilder)boolQueryBuilderSon2);
            boolQueryBuilderSon1.should((QueryBuilder)boolQueryBuilderSon3);
            boolQueryBuilder.must((QueryBuilder)boolQueryBuilderSon1);
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getQueryField())) {
            BoolQueryBuilder queryFieldBuilder = new BoolQueryBuilder();
            queryFieldBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"sku_code.keyword", (String)(reqBo.getQueryField() + "*")));
            queryFieldBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)("*" + reqBo.getQueryField() + "*")));
            queryFieldBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"ext_sku_id.keyword", (String)(reqBo.getQueryField() + "*")));
            queryFieldBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"vendor_name.keyword", (String)("*" + reqBo.getQueryField() + "*")));
            queryFieldBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"brand_name.keyword", (String)("*" + reqBo.getQueryField() + "*")));
            queryFieldBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"other_source_code.keyword", (String)(reqBo.getQueryField() + "*")));
            queryFieldBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"type_name", (String)("*" + reqBo.getQueryField() + "*")));
            boolQueryBuilder.must((QueryBuilder)queryFieldBuilder);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBrandName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"brand_name.keyword", (String)("*" + reqBo.getBrandName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_name.keyword", (String)("*" + reqBo.getCommodityName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityExpand1())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_expand1.keyword", (String)(reqBo.getCommodityExpand1() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getVendorName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"vendor_name.keyword", (String)("*" + reqBo.getVendorName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_name.keyword", (String)(reqBo.getOtherSourceName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getModel())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"model.keyword", (String)("*" + reqBo.getModel() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSpec())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"spec.keyword", (String)("*" + reqBo.getSpec() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"material_code.keyword", (String)(reqBo.getMaterialCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"material_name.keyword", (String)("*" + reqBo.getMaterialName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_code.keyword", (String)(reqBo.getOtherSourceCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)(reqBo.getCommodityCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateOperName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"create_oper_name.keyword", (String)("*" + reqBo.getCreateOperName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        try {
            Long timeBegin;
            RangeQueryBuilder qb = null;
            if (reqBo.getCreateTimeStart() != null && reqBo.getCreateTimeEnd() != null) {
                timeBegin = reqBo.getCreateTimeStart().getTime();
                Long timeEnd = reqBo.getCreateTimeEnd().getTime();
                qb = QueryBuilders.rangeQuery((String)"create_time").from((Object)timeBegin).to((Object)timeEnd);
            } else {
                if (reqBo.getCreateTimeStart() != null) {
                    timeBegin = reqBo.getCreateTimeStart().getTime();
                    qb = QueryBuilders.rangeQuery((String)"create_time").from((Object)timeBegin);
                }
                if (reqBo.getCreateTimeEnd() != null) {
                    Long timeEnd = reqBo.getCreateTimeEnd().getTime();
                    qb = QueryBuilders.rangeQuery((String)"create_time").to((Object)timeEnd);
                }
            }
            if (qb != null) {
                boolQueryBuilder.must(qb);
            }
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u521b\u5efa\u65f6\u95f4\u8303\u56f4\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        return boolQueryBuilder;
    }

    private String excuteEsSql(UccSpuManagementListQryAbilityReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)"create_time").order(SortOrder.DESC);
        queryJson.put("sort", (Object)JSONObject.parseObject((String)sortQuery.toString()));
        JSONObject collapse = new JSONObject();
        collapse.put("field", (Object)"commodity_id");
        queryJson.put("collapse", (Object)collapse);
        JSONObject aggs = new JSONObject();
        if (reqBo.isCollapse()) {
            JSONObject total = new JSONObject();
            JSONObject cardinality = new JSONObject();
            total.put("field", (Object)"commodity_id");
            total.put("precision_threshold", (Object)40000);
            cardinality.put("cardinality", (Object)total);
            aggs.put("books_count", (Object)cardinality);
        }
        queryJson.put("aggs", (Object)aggs);
        return queryJson.toString();
    }

    private UccSpuManagementListQryAbilityRspBO dealSearchData(String result, UccSpuManagementListQryAbilityReqBO reqBo) {
        UccSpuManagementListQryAbilityRspBO rspBo = new UccSpuManagementListQryAbilityRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<UccEsCommodityBo> commodityModels = new ArrayList<UccEsCommodityBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccEsCommodityBo commodity = new UccEsCommodityBo();
                try {
                    commodity = (UccEsCommodityBo)JSON.toJavaObject((JSON)data, UccEsCommodityBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        if (reqBo.isCollapse()) {
            String agss = JSONObject.parseObject((String)result).get((Object)"aggregations").toString();
            total = Integer.valueOf(JSONObject.parseObject((String)JSONObject.parseObject((String)agss).get((Object)"books_count").toString()).get((Object)"value").toString());
        }
        rspBo = this.copyData(commodityModels, total, reqBo.getPageNo(), reqBo.getPageSize());
        return rspBo;
    }

    private UccSpuManagementListQryAbilityRspBO copyData(List<UccEsCommodityBo> commodityModels, Integer totalNum, int pageNo, int pageSize) {
        UccSpuManagementListQryAbilityRspBO rspBo = new UccSpuManagementListQryAbilityRspBO();
        ArrayList<UccSpuManagementListQryBO> uccSkuManagementListQryBOs = new ArrayList<UccSpuManagementListQryBO>();
        if (totalNum != null) {
            rspBo.setPageNo(pageNo);
            int size = pageSize;
            int totalPage = 0;
            int add = 0;
            Integer total = 0;
            totalPage = totalNum / size;
            add = totalNum % size == 0 ? 0 : 1;
            total = totalNum;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(total.intValue());
            DicDictionaryPo dicDictionaryPo = null;
            if (!CollectionUtils.isEmpty(commodityModels)) {
                for (UccEsCommodityBo uccEsCommodityBo : commodityModels) {
                    UccSpuManagementListQryBO uccSpuManagementListQryBO = new UccSpuManagementListQryBO();
                    uccSpuManagementListQryBO.setCommodityCode(uccEsCommodityBo.getCommodity_code());
                    uccSpuManagementListQryBO.setCommodityId(Long.valueOf(uccEsCommodityBo.getCommodity_id()));
                    uccSpuManagementListQryBO.setCommodityName(uccEsCommodityBo.getCommodity_name());
                    uccSpuManagementListQryBO.setCommodityStatus(uccEsCommodityBo.getCommodity_status());
                    uccSpuManagementListQryBO.setCommodityTypeId(uccEsCommodityBo.getType_id());
                    uccSpuManagementListQryBO.setCommodityTypeName(uccEsCommodityBo.getType_name());
                    uccSpuManagementListQryBO.setApprovalStatus(uccEsCommodityBo.getSpu_approval_status());
                    uccSpuManagementListQryBO.setAgreementDetailsId(Long.valueOf(uccEsCommodityBo.getAgreement_details_id()));
                    uccSpuManagementListQryBO.setTradeMode(uccEsCommodityBo.getTradeMode());
                    dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(uccEsCommodityBo.getCommodity_status().toString(), CommodityEnum.COMMODITY_STATUS.toString());
                    if (dicDictionaryPo != null) {
                        uccSpuManagementListQryBO.setCommodityStatusDesc(dicDictionaryPo.getTitle());
                    }
                    if (uccEsCommodityBo.getSpu_approval_status() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(uccEsCommodityBo.getSpu_approval_status()), CommodityEnum.SKU_APPROVAL_STATUS.toString())) != null) {
                        uccSpuManagementListQryBO.setApprovalStatusDesc(dicDictionaryPo.getTitle());
                    }
                    if (uccSpuManagementListQryBO.getTradeMode() != null) {
                        Map<String, String> tradeMode = this.uccDictionaryAtomService.queryBypCodeBackMap("TRADE_MODE");
                        uccSpuManagementListQryBO.setTradeModeStr(tradeMode.get(uccSpuManagementListQryBO.getTradeMode().toString()));
                    } else {
                        uccSpuManagementListQryBO.setTradeModeStr("\u96c6\u91c7\u96c6\u4f9b-\u81ea\u8425\u6a21\u5f0f");
                    }
                    uccSpuManagementListQryBO.setSupplierShopId(uccEsCommodityBo.getSupplier_shop_id());
                    uccSpuManagementListQryBO.setBrandId(Long.valueOf(uccEsCommodityBo.getBrand_id()));
                    uccSpuManagementListQryBO.setBrandName(uccEsCommodityBo.getBrand_name());
                    uccSpuManagementListQryBO.setVendorId(uccEsCommodityBo.getVendor_id());
                    uccSpuManagementListQryBO.setVendorName(uccEsCommodityBo.getVendor_name());
                    uccSpuManagementListQryBO.setMeasureName(uccEsCommodityBo.getMeasure_name());
                    uccSpuManagementListQryBO.setL4mgCategoryId(uccEsCommodityBo.getL4mg_category_id());
                    uccSpuManagementListQryBO.setL4mgCategoryName(uccEsCommodityBo.getL4mg_category_name());
                    uccSpuManagementListQryBO.setOtherSourceCode(uccEsCommodityBo.getOther_source_code());
                    uccSpuManagementListQryBO.setOtherSourceName(uccEsCommodityBo.getOther_source_name());
                    uccSpuManagementListQryBO.setSkuSource(Integer.valueOf(uccEsCommodityBo.getSku_source()));
                    uccSpuManagementListQryBO.setSourceAssort(uccEsCommodityBo.getSourceAssort());
                    uccSpuManagementListQryBO.setCommodityExpand1(uccEsCommodityBo.getCommodity_expand1());
                    uccSpuManagementListQryBO.setSettlementUnit(uccEsCommodityBo.getSettlement_unit());
                    uccSpuManagementListQryBO.setCreateOperName(uccEsCommodityBo.getCreate_oper_name());
                    uccSpuManagementListQryBO.setOrgName(uccEsCommodityBo.getSupplier_org_name());
                    uccSpuManagementListQryBO.setBelongModule(uccEsCommodityBo.getBelongModule());
                    if (uccEsCommodityBo.getBelongModule() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(uccEsCommodityBo.getBelongModule()), "BELONG_MODULE")) != null) {
                        uccSpuManagementListQryBO.setBelongModuleStr(dicDictionaryPo.getTitle());
                    }
                    uccSpuManagementListQryBO.setRunMainBodyId(uccEsCommodityBo.getRunMainBodyId());
                    uccSpuManagementListQryBO.setRunMainBodyName(uccEsCommodityBo.getRunMainBodyName());
                    uccSpuManagementListQryBO.setSupplierId(uccEsCommodityBo.getSupplier_id());
                    if (uccEsCommodityBo.getCreate_time() != null) {
                        uccSpuManagementListQryBO.setCreateTime(new Date(uccEsCommodityBo.getCreate_time()));
                    }
                    if (uccEsCommodityBo.getAudit_time() != null) {
                        uccSpuManagementListQryBO.setAuditTime(new Date(uccEsCommodityBo.getAudit_time()));
                    }
                    uccSkuManagementListQryBOs.add(uccSpuManagementListQryBO);
                }
            }
            rspBo.setRows(uccSkuManagementListQryBOs);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

