/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.common.ability.api.UccStandardPriceChangeAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuStandadrPriceDTO;
import com.tydic.commodity.common.ability.bo.UccStandardPriceChangeAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccStandardPriceChangeAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccStandardPriceChangeBusiService;
import com.tydic.commodity.dao.UccSkuMapper;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccStandardPriceChangeAbilityService"})
public class UccStandardPriceChangeAbilityServiceImpl
implements UccStandardPriceChangeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccStandardPriceChangeAbilityServiceImpl.class);
    @Autowired
    private UccStandardPriceChangeBusiService uccStandardPriceChangeBusiService;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"UccStandardPriceChange"})
    public UccStandardPriceChangeAbilityRspBO UccStandardPriceChange(@RequestBody UccStandardPriceChangeAbilityReqBO abilityReqBO) {
        List uccSkuPos;
        UccStandardPriceChangeAbilityRspBO rspBO = new UccStandardPriceChangeAbilityRspBO();
        rspBO.setRespCode("8888");
        if (abilityReqBO == null) {
            rspBO.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
            return rspBO;
        }
        if (abilityReqBO.getStandardPrice() == null || abilityReqBO.getUpRatio() == null || abilityReqBO.getUccSkuStandadrPriceDTOS() == null) {
            rspBO.setRespDesc("\u57fa\u51c6\u4ef7\u3010standardPrice\u3011\u6216\u4e0a\u9650\u6bd4\u4f8b\u3010upRatio\u3011\u6216\u7535\u5546\u5355\u54c1\u4f9b\u5e94\u5546ID\u96c6\u5408\u3010uccSkuStandadrPriceDTOS\u3011\u4e3a\u7a7a");
            return rspBO;
        }
        if (!UccStandardPriceChangeAbilityServiceImpl.validate(abilityReqBO.getUccSkuStandadrPriceDTOS())) {
            rspBO.setRespDesc("\u7535\u5546\u5355\u54c1\u4f9b\u5e94\u5546ID\u96c6\u5408\u3010uccSkuStandadrPriceDTOS\u3011\u4e2d\u5b58\u5728\u7a7a\u503c");
            return rspBO;
        }
        UccStandardPriceChangeAbilityRspBO abilityRspBO = this.uccStandardPriceChangeBusiService.UccStandardPriceChange(abilityReqBO);
        BeanUtils.copyProperties((Object)abilityRspBO, (Object)rspBO);
        List extSkuIds = abilityReqBO.getUccSkuStandadrPriceDTOS().stream().filter(a -> !StringUtils.isEmpty((Object)a.getExtSkuId())).map(a -> a.getExtSkuId()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(extSkuIds) && !CollectionUtils.isEmpty((Collection)(uccSkuPos = this.uccSkuMapper.qerySkusByExtSkuIds(extSkuIds, null)))) {
            List skuIds = uccSkuPos.stream().map(a -> a.getSkuId()).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds(skuIds);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            try {
                this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
            }
            catch (Exception e) {
                log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
            }
        }
        return rspBO;
    }

    public static boolean validate(List<UccSkuStandadrPriceDTO> list) {
        for (UccSkuStandadrPriceDTO skuStandadrPriceDTO : list) {
            if (!StringUtils.isEmpty((Object)skuStandadrPriceDTO.getExtSkuId()) && skuStandadrPriceDTO.getVendorId() != null) continue;
            return false;
        }
        return true;
    }
}

