/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.common.ability.api.UccUpdateSubzoneAbilityService;
import com.tydic.commodity.common.ability.bo.UccUpdateSubzoneAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccUpdateSubzoneAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccUpdateSubzoneBusiService;
import java.util.Collection;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccUpdateSubzoneAbilityService"})
public class UccUpdateSubzoneAbilityServiceImpl
implements UccUpdateSubzoneAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccUpdateSubzoneAbilityServiceImpl.class);
    @Autowired
    private UccUpdateSubzoneBusiService uccUpdateSubzoneBusiService;
    @Resource(name="uccDealPoolSyncToESProvider")
    private ProxyMessageProducer uccDealPoolSyncToESProvider;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;

    @PostMapping(value={"UpdateSubzone"})
    public UccUpdateSubzoneAbilityRspBO UpdateSubzone(@RequestBody UccUpdateSubzoneAbilityReqBO reqBo) {
        this.verification(reqBo);
        UccUpdateSubzoneAbilityRspBO rspBo = this.uccUpdateSubzoneBusiService.UpdateSubzone(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setCommodityIds(reqBo.getCommodityIds());
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            try {
                this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
            }
            catch (Exception e) {
                log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
            }
        }
        return rspBo;
    }

    private void verification(UccUpdateSubzoneAbilityReqBO reqBo) {
        if (null == reqBo) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getSkuPoolIds())) {
            throw new BusinessException("8888", "\u5546\u54c1\u6c60id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getCommodityIds())) {
            throw new BusinessException("8888", "\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getIsSupermarketStaff()) {
            throw new BusinessException("8888", "\u662f\u5426\u5458\u5de5\u8d85\u5e02\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

