/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.atom.api.UccGoodstofreezeAtomService;
import com.tydic.commodity.common.atom.bo.UccGoodstofreezeAtomReqBO;
import com.tydic.commodity.common.atom.bo.UccGoodstofreezeAtomRspBO;
import com.tydic.commodity.dao.UccBeforeStatusRecordEditMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccBeforeStatusRecordEditPO;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccGoodstofreezeAtomServiceImpl
implements UccGoodstofreezeAtomService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccBeforeStatusRecordEditMapper uccBeforeStatusRecordEditMapper;
    private Sequence sequence = Sequence.getInstance();

    @Override
    public UccGoodstofreezeAtomRspBO dealgoodstofreeze(UccGoodstofreezeAtomReqBO reqBO) {
        UccGoodstofreezeAtomRspBO rspBO = new UccGoodstofreezeAtomRspBO();
        if (CollectionUtils.isEmpty(reqBO.getCommodityIds())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        List commodityPoList = this.uccCommodityMapper.batchQryCommd(reqBO.getCommodityIds(), reqBO.getSupplierShopId());
        if (CollectionUtils.isEmpty((Collection)commodityPoList)) {
            throw new BusinessException(RspConstantEnums.COMMODITY_NOT_EXIST.code(), RspConstantEnums.COMMODITY_NOT_EXIST.message());
        }
        List poList = this.uccSkuMapper.qrySkuByCommoditys(reqBO.getCommodityIds(), reqBO.getSupplierShopId());
        if (CollectionUtils.isEmpty((Collection)poList)) {
            throw new BusinessException(RspConstantEnums.SKU_NOT_EXIST.code(), RspConstantEnums.SKU_NOT_EXIST.message());
        }
        List skus = poList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
        List spuRecord = this.uccBeforeStatusRecordEditMapper.batchQueryRecord(reqBO.getCommodityIds(), reqBO.getSupplierShopId(), Integer.valueOf(1));
        List skuRecord = this.uccBeforeStatusRecordEditMapper.batchQueryRecord(skus, reqBO.getSupplierShopId(), Integer.valueOf(2));
        if (!CollectionUtils.isEmpty((Collection)spuRecord) || !CollectionUtils.isEmpty((Collection)skuRecord)) {
            throw new BusinessException(RspConstantEnums.BEFORE_STATUS_RECORD_EXIST.code(), RspConstantEnums.BEFORE_STATUS_RECORD_EXIST.message());
        }
        ArrayList<UccBeforeStatusRecordEditPO> batchInserPo = new ArrayList<UccBeforeStatusRecordEditPO>();
        UccBeforeStatusRecordEditPO po = null;
        for (UccSkuPo each : poList) {
            po = new UccBeforeStatusRecordEditPO();
            po.setId(each.getSkuId());
            po.setStatus(each.getSkuStatus());
            po.setType(Integer.valueOf(2));
            po.setSupplierShopId(each.getSupplierShopId());
            batchInserPo.add(po);
        }
        try {
            this.uccBeforeStatusRecordEditMapper.batchInsert(batchInserPo);
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), RspConstantEnums.QUERY_DATA_EXCEPTION.message());
        }
        try {
            this.uccCommodityMapper.batchUpdateCommodityStatus(reqBO.getCommodityIds(), ModelRuleConstant.SKU_STATUS_FREEZE, reqBO.getSupplierShopId());
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), RspConstantEnums.QUERY_DATA_EXCEPTION.message());
        }
        try {
            this.uccSkuMapper.batchUpdateSkuStatusByIds(reqBO.getCommodityIds(), ModelRuleConstant.SKU_STATUS_FREEZE, reqBO.getSupplierShopId());
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), RspConstantEnums.QUERY_DATA_EXCEPTION.message());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

