/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.bo.SearchEsManageReqBo;
import com.tydic.commodity.busibase.comb.api.SearchCommodityManageService;
import com.tydic.commodity.busibase.comb.bo.SearchCommodityManageRspBo;
import com.tydic.commodity.busibase.comb.bo.SearchSpuManageBO;
import com.tydic.commodity.common.ability.bo.UccSkuStandadrPriceDTO;
import com.tydic.commodity.common.ability.bo.UccStandardPriceChangeAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccStandardPriceChangeAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccStandardPriceChangeBusiService;
import com.tydic.commodity.dao.ECommercePriceChangeLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuStandardPriceMapper;
import com.tydic.commodity.po.ECommercePriceChangeLogPO;
import com.tydic.commodity.po.UccSkuStandardPricePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccStandardPriceChangeBusiServiceImpl
implements UccStandardPriceChangeBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccStandardPriceChangeBusiServiceImpl.class);
    @Autowired
    private UccSkuStandardPriceMapper uccSkuStandardPriceMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private ECommercePriceChangeLogMapper eCommercePriceChangeLogMapper;
    @Autowired
    private SearchCommodityManageService searchCommodityManageService;

    @Override
    public UccStandardPriceChangeAbilityRspBO UccStandardPriceChange(UccStandardPriceChangeAbilityReqBO reqBO) {
        UccStandardPriceChangeAbilityRspBO rspBO = new UccStandardPriceChangeAbilityRspBO();
        rspBO.setRespCode("8888");
        this.insertLog(reqBO);
        UccSkuStandardPricePO valuePO = new UccSkuStandardPricePO();
        valuePO.setUpdateOperId(reqBO.getUsername());
        valuePO.setUpdateTime(new Date());
        valuePO.setStandardPrice(reqBO.getStandardPrice());
        valuePO.setUpRatio(reqBO.getUpRatio());
        List uccSkuStandadrPriceDTOS = reqBO.getUccSkuStandadrPriceDTOS();
        try {
            for (UccSkuStandadrPriceDTO standadrPriceDTO : uccSkuStandadrPriceDTOS) {
                UccSkuStandardPricePO wherePO = new UccSkuStandardPricePO();
                wherePO.setVendorId(standadrPriceDTO.getVendorId());
                wherePO.setExtSkuId(standadrPriceDTO.getExtSkuId());
                this.uccSkuStandardPriceMapper.updateBy(valuePO, wherePO);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", e.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void insertLog(UccStandardPriceChangeAbilityReqBO reqBO) {
        Map<Long, List<UccSkuStandadrPriceDTO>> reqMap = reqBO.getUccSkuStandadrPriceDTOS().stream().collect(Collectors.groupingBy(a -> a.getVendorId()));
        ArrayList<ECommercePriceChangeLogPO> insertPos = new ArrayList<ECommercePriceChangeLogPO>();
        for (Map.Entry<Long, List<UccSkuStandadrPriceDTO>> each : reqMap.entrySet()) {
            List extSkuIds = each.getValue().stream().map(a -> a.getExtSkuId()).collect(Collectors.toList());
            UccSkuStandardPricePO uccSkuStandardPricePO = new UccSkuStandardPricePO();
            uccSkuStandardPricePO.setExtSkuIds(extSkuIds);
            uccSkuStandardPricePO.setVendorId(each.getKey());
            List uccSkuStandardPricePOS = this.uccSkuStandardPriceMapper.getList(uccSkuStandardPricePO);
            if (CollectionUtils.isEmpty((Collection)uccSkuStandardPricePOS)) continue;
            List inexistSku = uccSkuStandardPricePOS.stream().filter(a -> a.getSkuId() == null).collect(Collectors.toList());
            for (UccSkuStandardPricePO skuStandardPricePO : inexistSku) {
                ECommercePriceChangeLogPO eCommercePriceChangeLogPO = new ECommercePriceChangeLogPO();
                Long id = Sequence.getInstance().nextId();
                eCommercePriceChangeLogPO.setBatchId(id);
                eCommercePriceChangeLogPO.setId(id);
                eCommercePriceChangeLogPO.setExtSkuId(skuStandardPricePO.getExtSkuId());
                eCommercePriceChangeLogPO.setSupplierShopId(skuStandardPricePO.getVendorId());
                eCommercePriceChangeLogPO.setStandardPrice(skuStandardPricePO.getStandardPrice());
                eCommercePriceChangeLogPO.setFloatingRatio(skuStandardPricePO.getUpRatio());
                eCommercePriceChangeLogPO.setUpdateTime(new Date());
                eCommercePriceChangeLogPO.setIsDown(Integer.valueOf(0));
                eCommercePriceChangeLogPO.setStandardFlag("1");
                insertPos.add(eCommercePriceChangeLogPO);
            }
            List querySku = uccSkuStandardPricePOS.stream().filter(a -> a.getSkuId() != null).map(a -> a.getSkuId()).distinct().collect(Collectors.toList());
            Map<Long, UccSkuStandardPricePO> skuStandardMap = uccSkuStandardPricePOS.stream().filter(a -> a.getSkuId() != null).collect(Collectors.toMap(a -> a.getSkuId(), a -> a, (first, second) -> first));
            if (CollectionUtils.isEmpty(querySku)) continue;
            SearchEsManageReqBo searchEsManageReqBo = new SearchEsManageReqBo();
            searchEsManageReqBo.setPageNo(Integer.valueOf(1));
            searchEsManageReqBo.setPageSize(Integer.valueOf(querySku.size()));
            searchEsManageReqBo.setSkuList(querySku);
            SearchCommodityManageRspBo searchCommodityManageRspBo = this.searchCommodityManageService.searchCommodity(searchEsManageReqBo);
            if (CollectionUtils.isEmpty((Collection)searchCommodityManageRspBo.getResult())) continue;
            for (SearchSpuManageBO searchSpuManageBO : searchCommodityManageRspBo.getResult()) {
                UccSkuStandardPricePO uccSkuStandardPricePO1 = skuStandardMap.get(searchSpuManageBO.getSkuId());
                ECommercePriceChangeLogPO eCommercePriceChangeLogPO = new ECommercePriceChangeLogPO();
                Long id = Sequence.getInstance().nextId();
                eCommercePriceChangeLogPO.setBatchId(id);
                eCommercePriceChangeLogPO.setId(id);
                eCommercePriceChangeLogPO.setExtSkuId(searchSpuManageBO.getExtSkuId());
                eCommercePriceChangeLogPO.setSupplierShopId(searchSpuManageBO.getVendorId());
                eCommercePriceChangeLogPO.setFloatingRatio(uccSkuStandardPricePO1.getUpRatio());
                eCommercePriceChangeLogPO.setStandardPrice(uccSkuStandardPricePO1.getStandardPrice());
                eCommercePriceChangeLogPO.setUpdateTime(new Date());
                eCommercePriceChangeLogPO.setIsDown(Integer.valueOf(0));
                eCommercePriceChangeLogPO.setSkuId(searchSpuManageBO.getSkuId());
                eCommercePriceChangeLogPO.setPrice(searchSpuManageBO.getAgreementPrice());
                eCommercePriceChangeLogPO.setMarketPrice(searchSpuManageBO.getMartketPrice());
                eCommercePriceChangeLogPO.setStandardFlag("1");
                insertPos.add(eCommercePriceChangeLogPO);
            }
        }
        if (!CollectionUtils.isEmpty(insertPos)) {
            this.eCommercePriceChangeLogMapper.insertECommercePriceChangeLogs(insertPos);
        }
    }
}

