/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccWarehouseAddressBO;
import com.tydic.commodity.common.busi.api.UccWarehouseAddressAddBusiService;
import com.tydic.commodity.common.busi.bo.UccWarehouseAddressAddBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccWarehouseAddressAddBusiRspBO;
import com.tydic.commodity.common.external.util.BatchImportUtils;
import com.tydic.commodity.dao.UccWarehouseAddressImportMapper;
import com.tydic.commodity.dao.UccWarehouseAddressMapper;
import com.tydic.commodity.po.UccWarehouseAddressImportPO;
import com.tydic.commodity.po.UccWarehouseAddressPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccWarehouseAddressAddBusiServiceImpl
implements UccWarehouseAddressAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccWarehouseAddressAddBusiServiceImpl.class);
    @Autowired
    private UccWarehouseAddressMapper uccWarehouseAddressMapper;
    @Autowired
    private UccWarehouseAddressImportMapper uccWarehouseAddressImportMapper;

    @Override
    public UccWarehouseAddressAddBusiRspBO addWarehouseAddress(UccWarehouseAddressAddBusiReqBO reqBO) {
        if (UccConstants.AddressType.CURRENT.equals(reqBO.getAddressType())) {
            UccWarehouseAddressPO uccWarehouseAddressPO = new UccWarehouseAddressPO();
            uccWarehouseAddressPO.setAddressType(reqBO.getAddressType());
            uccWarehouseAddressPO.setProvinceCode(reqBO.getProvinceCode());
            uccWarehouseAddressPO.setCityCode(reqBO.getCityCode());
            uccWarehouseAddressPO.setCountyCode(reqBO.getCountyCode());
            uccWarehouseAddressPO.setTownCode(reqBO.getTownCode());
            int i = this.uccWarehouseAddressMapper.getCheckBy(uccWarehouseAddressPO);
            if (i > 0) {
                throw new BusinessException(RspConstantEnums.WAREHOUSE_ADDRESS_ADD_FAIL.code(), "\u6b64\u5730\u533a\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
            }
        }
        ArrayList<String> areaList = new ArrayList<String>();
        areaList.add(reqBO.getProvince());
        if (!StringUtils.isEmpty((Object)reqBO.getCity())) {
            areaList.add(reqBO.getCity());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getCounty())) {
            areaList.add(reqBO.getCounty());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getTown())) {
            areaList.add(reqBO.getTown());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getAddress())) {
            areaList.add(reqBO.getAddress());
        }
        String area = String.join((CharSequence)"/", areaList);
        UccWarehouseAddressPO warehouseAddressPO = (UccWarehouseAddressPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), UccWarehouseAddressPO.class);
        warehouseAddressPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        warehouseAddressPO.setWarehouseId(reqBO.getWarehouseId());
        warehouseAddressPO.setStatus(UccConstants.WarehouseState.VALID);
        Date nowDate = new Date();
        warehouseAddressPO.setCreateTime(nowDate);
        warehouseAddressPO.setCreateUserName(reqBO.getName());
        warehouseAddressPO.setCreateUserId(reqBO.getUserId());
        warehouseAddressPO.setCreateUserAccount(reqBO.getUsername());
        warehouseAddressPO.setUpdateTime(nowDate);
        warehouseAddressPO.setUpdateUserName(reqBO.getName());
        warehouseAddressPO.setUpdateUserId(reqBO.getUserId());
        warehouseAddressPO.setUpdateUserAccount(reqBO.getUsername());
        warehouseAddressPO.setArea(area);
        this.uccWarehouseAddressMapper.insert(warehouseAddressPO);
        UccWarehouseAddressAddBusiRspBO rspBO = new UccWarehouseAddressAddBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public UccWarehouseAddressAddBusiRspBO importWarehouseAddress(UccWarehouseAddressAddBusiReqBO reqBO) {
        List<List<String>> importData;
        UccWarehouseAddressAddBusiRspBO rspBO = new UccWarehouseAddressAddBusiRspBO();
        ArrayList<String> title = new ArrayList<String>();
        title.add("id");
        title.add("\u4e00\u7ea7\u5730\u5740");
        title.add("\u4e00\u7ea7\u5730\u5740\u7f16\u7801");
        title.add("\u4e8c\u7ea7\u5730\u5740");
        title.add("\u4e8c\u7ea7\u5730\u5740\u7f16\u7801");
        title.add("\u4e09\u7ea7\u5730\u5740");
        title.add("\u4e09\u7ea7\u5730\u5740\u7f16\u7801");
        title.add("\u56db\u7ea7\u5730\u5740");
        title.add("\u56db\u7ea7\u5730\u5740\u7f16\u7801");
        if (!UccConstants.AddressType.CURRENT.equals(reqBO.getAddressType())) {
            title.add("\u5730\u5740\u4fe1\u606f");
        }
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            BatchImportUtils<UccWarehouseAddressBO> batchImportUtils = new BatchImportUtils<UccWarehouseAddressBO>(title, data, UccWarehouseAddressBO.class);
            batchImportUtils.batchImport(reqBO.getUrl(), 0, 1, -1);
            importData = batchImportUtils.getData();
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u5931\u8d25\uff1a" + e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.toString());
            return rspBO;
        }
        if (CollectionUtils.isEmpty(importData)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a");
            return rspBO;
        }
        Long tempId = Sequence.getInstance().nextId();
        rspBO.setTempId(tempId);
        Date nowDate = new Date();
        for (List<String> row : importData) {
            UccWarehouseAddressImportPO uccWarehouseAddressImportPO = new UccWarehouseAddressImportPO();
            uccWarehouseAddressImportPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            uccWarehouseAddressImportPO.setWarehouseId(reqBO.getWarehouseId());
            uccWarehouseAddressImportPO.setAddressType(reqBO.getAddressType());
            uccWarehouseAddressImportPO.setStatus(UccConstants.WarehouseState.VALID);
            uccWarehouseAddressImportPO.setCreateTime(nowDate);
            uccWarehouseAddressImportPO.setCreateUserName(reqBO.getName());
            uccWarehouseAddressImportPO.setCreateUserId(reqBO.getUserId());
            uccWarehouseAddressImportPO.setCreateUserAccount(reqBO.getUsername());
            uccWarehouseAddressImportPO.setUpdateTime(nowDate);
            uccWarehouseAddressImportPO.setUpdateUserName(reqBO.getName());
            uccWarehouseAddressImportPO.setUpdateUserId(reqBO.getUserId());
            uccWarehouseAddressImportPO.setUpdateUserAccount(reqBO.getUsername());
            uccWarehouseAddressImportPO.setTempId(tempId);
            uccWarehouseAddressImportPO.setState(UccConstants.WarehouseState.VALID);
            UccWarehouseAddressPO uccWarehouseAddressPO = new UccWarehouseAddressPO();
            uccWarehouseAddressPO.setWarehouseId(reqBO.getWarehouseId());
            uccWarehouseAddressPO.setAddressType(reqBO.getAddressType());
            uccWarehouseAddressPO.setStatus(UccConstants.WarehouseState.VALID);
            int index = 0;
            if (!StringUtils.isEmpty((Object)row.get(index)) && !"0".equals(row.get(index))) {
                uccWarehouseAddressPO.setId(Long.valueOf(Long.parseLong(row.get(index++))));
            } else {
                ++index;
            }
            if (StringUtils.isEmpty((Object)row.get(index)) || "null".equals(row.get(index))) {
                uccWarehouseAddressImportPO.setState(UccConstants.WarehouseState.INVALID);
                uccWarehouseAddressImportPO.setFailContent("\u4e00\u7ea7\u5730\u5740\u4e3a\u7a7a");
                this.uccWarehouseAddressImportMapper.insert(uccWarehouseAddressImportPO);
                continue;
            }
            uccWarehouseAddressPO.setProvince(row.get(index++));
            uccWarehouseAddressImportPO.setProvince(uccWarehouseAddressPO.getProvince());
            if (StringUtils.isEmpty((Object)row.get(index)) || "null".equals(row.get(index))) {
                uccWarehouseAddressImportPO.setState(UccConstants.WarehouseState.INVALID);
                uccWarehouseAddressImportPO.setFailContent("\u4e00\u7ea7\u5730\u5740\u7f16\u7801\u4e3a\u7a7a");
                this.uccWarehouseAddressImportMapper.insert(uccWarehouseAddressImportPO);
                continue;
            }
            uccWarehouseAddressPO.setProvinceCode(Integer.valueOf(Integer.parseInt(row.get(index++))));
            uccWarehouseAddressImportPO.setProvinceCode(uccWarehouseAddressPO.getProvinceCode());
            if (row.size() > index && !StringUtils.isEmpty((Object)row.get(index)) && !"null".equals(row.get(index))) {
                uccWarehouseAddressPO.setCity(row.get(index++));
                uccWarehouseAddressImportPO.setCity(uccWarehouseAddressPO.getCity());
            }
            if (row.size() > index && !StringUtils.isEmpty((Object)row.get(index)) && !"null".equals(row.get(index))) {
                uccWarehouseAddressPO.setCityCode(Integer.valueOf(Integer.parseInt(row.get(index++))));
                uccWarehouseAddressImportPO.setCityCode(uccWarehouseAddressPO.getCityCode());
            }
            if (row.size() > index && !StringUtils.isEmpty((Object)row.get(index)) && !"null".equals(row.get(index))) {
                uccWarehouseAddressPO.setCounty(row.get(index++));
                uccWarehouseAddressImportPO.setCounty(uccWarehouseAddressPO.getCounty());
            }
            if (row.size() > index && !StringUtils.isEmpty((Object)row.get(index)) && !"null".equals(row.get(index))) {
                uccWarehouseAddressPO.setCountyCode(Integer.valueOf(Integer.parseInt(row.get(index++))));
                uccWarehouseAddressImportPO.setCountyCode(uccWarehouseAddressPO.getCountyCode());
            }
            if (row.size() > index && !StringUtils.isEmpty((Object)row.get(index)) && !"null".equals(row.get(index))) {
                uccWarehouseAddressPO.setTown(row.get(index++));
                uccWarehouseAddressImportPO.setTown(uccWarehouseAddressPO.getTown());
            }
            if (row.size() > index && !StringUtils.isEmpty((Object)row.get(index)) && !"null".equals(row.get(index))) {
                uccWarehouseAddressPO.setTownCode(Integer.valueOf(Integer.parseInt(row.get(index++))));
                uccWarehouseAddressImportPO.setTownCode(uccWarehouseAddressPO.getTownCode());
            }
            if (row.size() > index && !StringUtils.isEmpty((Object)row.get(index)) && !"null".equals(row.get(index))) {
                uccWarehouseAddressPO.setAddress(row.get(index));
                uccWarehouseAddressImportPO.setTown(uccWarehouseAddressPO.getAddress());
            }
            ArrayList<String> areaList = new ArrayList<String>();
            areaList.add(reqBO.getProvince());
            if (!StringUtils.isEmpty((Object)reqBO.getCity())) {
                areaList.add(reqBO.getCity());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getCounty())) {
                areaList.add(reqBO.getCounty());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getTown())) {
                areaList.add(reqBO.getTown());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getAddress())) {
                areaList.add(reqBO.getAddress());
            }
            String area = String.join((CharSequence)"/", areaList);
            uccWarehouseAddressPO.setArea(area);
            uccWarehouseAddressImportPO.setArea(area);
            UccWarehouseAddressPO have = uccWarehouseAddressPO;
            have = this.uccWarehouseAddressMapper.selectSameList(have);
            if (UccConstants.AddressType.CURRENT.equals(reqBO.getAddressType())) {
                if (have != null && have.getId() != null && uccWarehouseAddressPO.getId() == null) {
                    uccWarehouseAddressImportPO.setState(UccConstants.WarehouseState.INVALID);
                    uccWarehouseAddressImportPO.setFailContent("\u8be5\u5730\u5740\u5df2\u5b58\u5728");
                    this.uccWarehouseAddressImportMapper.insert(uccWarehouseAddressImportPO);
                    continue;
                }
            } else if (have != null && have.getId() != null) {
                uccWarehouseAddressPO.setId(have.getId());
            }
            if (uccWarehouseAddressPO.getId() == null) {
                uccWarehouseAddressPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                uccWarehouseAddressPO.setCreateTime(nowDate);
                uccWarehouseAddressPO.setCreateUserName(reqBO.getName());
                uccWarehouseAddressPO.setCreateUserId(reqBO.getUserId());
                uccWarehouseAddressPO.setCreateUserAccount(reqBO.getUsername());
                uccWarehouseAddressPO.setUpdateTime(nowDate);
                uccWarehouseAddressPO.setUpdateUserName(reqBO.getName());
                uccWarehouseAddressPO.setUpdateUserId(reqBO.getUserId());
                uccWarehouseAddressPO.setUpdateUserAccount(reqBO.getUsername());
                this.uccWarehouseAddressMapper.insert(uccWarehouseAddressPO);
            } else {
                uccWarehouseAddressPO.setUpdateTime(nowDate);
                uccWarehouseAddressPO.setUpdateUserName(reqBO.getName());
                uccWarehouseAddressPO.setUpdateUserId(reqBO.getUserId());
                uccWarehouseAddressPO.setUpdateUserAccount(reqBO.getUsername());
                this.uccWarehouseAddressMapper.updateById(uccWarehouseAddressPO);
            }
            this.uccWarehouseAddressImportMapper.insert(uccWarehouseAddressImportPO);
        }
        return rspBO;
    }
}

