/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.UccDealPoolSyncESAtomReqBo;
import com.tydic.commodity.busibase.atom.api.UccDealPoolSyncESAtomService;
import com.tydic.commodity.common.ability.api.UccChannelRelPoolAbilityService;
import com.tydic.commodity.common.ability.bo.UccChannelRelPoolAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccChannelRelPoolAbilityRspBO;
import com.tydic.commodity.dao.UccRelChannelPoolMapper;
import com.tydic.commodity.po.UccRelChannelPoolPo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccChannelRelPoolAbilityService"})
public class UccChannelRelPoolAbilityServiceImpl
implements UccChannelRelPoolAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccChannelRelPoolAbilityServiceImpl.class);
    private Sequence uccBrandSequence = Sequence.getInstance();
    @Autowired
    private UccRelChannelPoolMapper uccRelChannelPoolMapper;
    @Autowired
    private UccDealPoolSyncESAtomService uccDealPoolSyncESAtomService;
    @Resource(name="uccDealPoolSyncToESProvider")
    private ProxyMessageProducer uccDealPoolSyncToESProvider;

    @PostMapping(value={"relPool"})
    public UccChannelRelPoolAbilityRspBO relPool(@RequestBody UccChannelRelPoolAbilityReqBO reqBO) {
        UccChannelRelPoolAbilityRspBO rspBO = new UccChannelRelPoolAbilityRspBO();
        if (reqBO.getChannelId() == null || CollectionUtils.isEmpty((Collection)reqBO.getPoolIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u4e0d\u5b8c\u6574");
            return rspBO;
        }
        List poolIds = reqBO.getPoolIds();
        ArrayList<UccRelChannelPoolPo> list = new ArrayList<UccRelChannelPoolPo>();
        for (Long poolId : poolIds) {
            UccRelChannelPoolPo uccRelChannelPoolPo = new UccRelChannelPoolPo();
            uccRelChannelPoolPo.setId(Long.valueOf(this.uccBrandSequence.nextId()));
            uccRelChannelPoolPo.setChannelId(reqBO.getChannelId());
            uccRelChannelPoolPo.setPoolId(poolId);
            list.add(uccRelChannelPoolPo);
        }
        List cnncUccChannelPoolJoinPOS = this.uccRelChannelPoolMapper.queryRelList((List)Lists.newArrayList((Object[])new Long[]{reqBO.getChannelId()}), reqBO.getPoolIds());
        if (!CollectionUtils.isEmpty((Collection)cnncUccChannelPoolJoinPOS)) {
            List relPoolIds = cnncUccChannelPoolJoinPOS.stream().map(a -> a.getPoolId()).collect(Collectors.toList());
            rspBO.setRespDesc("\u9891\u9053\u5df2\u4e0e\u9009\u62e9\u7684\u5546\u54c1\u6c60" + relPoolIds + "\u5173\u8054\uff01");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        Integer result = this.uccRelChannelPoolMapper.batchInsert(list);
        if (result > 0) {
            UccDealPoolSyncESAtomReqBo cnncDealPoolSyncESAtomReqBo = new UccDealPoolSyncESAtomReqBo();
            cnncDealPoolSyncESAtomReqBo.setSyncType(Integer.valueOf(4));
            cnncDealPoolSyncESAtomReqBo.setReqPoolIds(reqBO.getPoolIds());
            log.info("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)cnncDealPoolSyncESAtomReqBo));
            this.uccDealPoolSyncToESProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"UCC_SYNC_POOL_ES_TOPIC"), PropertiesUtil.getProperty((String)"UCC_SYNC_POOL_ES_TAG"), JSON.toJSONString((Object)cnncDealPoolSyncESAtomReqBo)));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

