/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccMallEsUpdateReqBo;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.busibase.atom.api.UccSyncBrandToDGAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSyncBrandToDGAtomReqBo;
import com.tydic.commodity.common.ability.api.UccMallBrandUpdateAbilityService;
import com.tydic.commodity.common.ability.bo.BrandESBO;
import com.tydic.commodity.common.ability.bo.UccMallBrandUpdateAbilityBo;
import com.tydic.commodity.common.ability.bo.UccMallBrandUpdateAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccMallBrandUpdateAbilityRspBo;
import com.tydic.commodity.common.busi.api.UccMallBrandUpdateBusiService;
import com.tydic.commodity.common.busi.api.UccMallBrandUpdateCheckBusiService;
import com.tydic.commodity.common.busi.bo.UccMallBrandUpdateCheckBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccMallBrandUpdateCheckBusiRspBO;
import com.tydic.commodity.dao.UccBrandExtMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccMallBrandUpdateAbilityService"})
public class UccMallBrandUpdateAbilityServiceImpl
implements UccMallBrandUpdateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallBrandUpdateAbilityServiceImpl.class);
    @Autowired
    private UccMallBrandUpdateBusiService uccMallBrandUpdateBusiService;
    @Autowired
    private UccMallBrandUpdateCheckBusiService uccMallBrandUpdateCheckBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccBrandExtMapper uccBrandExtMapper;
    @Autowired
    private UccSyncBrandToDGAtomService uccSyncBrandToDGAtomService;

    @PostMapping(value={"updateBrandInfo"})
    public UccMallBrandUpdateAbilityRspBo updateBrandInfo(@RequestBody UccMallBrandUpdateAbilityReqBo reqBo) {
        UccMallBrandUpdateAbilityRspBo busiRspBo;
        UccMallBrandUpdateAbilityRspBo rspBo = new UccMallBrandUpdateAbilityRspBo();
        rspBo.setRespCode("8888");
        if (null == reqBo || CollectionUtils.isEmpty((Collection)reqBo.getBrandInfo())) {
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u3001\u54c1\u724c\u4fe1\u606f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getBrandInfo())) {
            for (UccMallBrandUpdateAbilityBo bo : reqBo.getBrandInfo()) {
                if (null == bo.getType()) {
                    rspBo.setRespDesc("\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                    return rspBo;
                }
                if (!UccConstants.BrandRelOperType.CANCEL.equals(bo.getType()) && !UccConstants.BrandRelOperType.CREATE.equals(bo.getType())) {
                    rspBo.setRespDesc("\u672a\u77e5\u7684\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b");
                    return rspBo;
                }
                if (UccConstants.BrandRelOperType.CANCEL.equals(bo.getType())) {
                    if (null != bo.getMallBrandId() && StringUtils.hasText((String)bo.getBrandName())) continue;
                    rspBo.setRespDesc("\u89e3\u9664\u5173\u8054\u65f6\uff0c\u5546\u57ce\u54c1\u724cID\u4e0e\u5546\u54c1\u54c1\u724c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                    return rspBo;
                }
                if (!UccConstants.BrandRelOperType.CREATE.equals(bo.getType()) || StringUtils.hasText((String)bo.getMallBrandName()) && StringUtils.hasText((String)bo.getBrandName())) continue;
                rspBo.setRespDesc("\u65b0\u589e\u5173\u8054\u65f6\uff0c\u5546\u57ce\u54c1\u724c\u540d\u79f0\u4e0e\u5546\u54c1\u54c1\u724c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBo;
            }
        }
        UccMallBrandUpdateCheckBusiReqBO updateCheckBusiReqBo = (UccMallBrandUpdateCheckBusiReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), UccMallBrandUpdateCheckBusiReqBO.class);
        updateCheckBusiReqBo.setBrandInfo(reqBo.getBrandInfo());
        UccMallBrandUpdateCheckBusiRspBO updateCheckBusiRspBo = this.uccMallBrandUpdateCheckBusiService.addMallBrand(updateCheckBusiReqBo);
        if (!"0000".equals(updateCheckBusiRspBo.getRespCode())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(updateCheckBusiRspBo.getRespDesc());
            return rspBo;
        }
        if (!CollectionUtils.isEmpty(updateCheckBusiRspBo.getBrandInfo())) {
            reqBo.setBrandInfo(updateCheckBusiRspBo.getBrandInfo());
        }
        if ("0000".equals((busiRspBo = this.uccMallBrandUpdateBusiService.updateBrandInfo(reqBo)).getRespCode())) {
            this.syncEs(busiRspBo.getBrandList());
            for (UccMallBrandUpdateAbilityBo uccMallBrandUpdateAbilityBo : reqBo.getBrandInfo()) {
                int num = 1;
                int total = 0;
                do {
                    Page page = new Page(num, 2000);
                    List dealSkuIds = this.uccSkuMapper.queryByBrandName(uccMallBrandUpdateAbilityBo.getBrandName(), page);
                    if (total == 0) {
                        total = page.getTotalPages();
                    }
                    if (CollectionUtils.isEmpty((Collection)dealSkuIds)) continue;
                    SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                    syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList((Iterable)dealSkuIds));
                    syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                    syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                    log.info("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
                    try {
                        this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                    }
                    catch (Exception e) {
                        log.error("\u540c\u6b65\u5546\u54c1\u72b6\u6001\u548c\u4ef7\u683c\uff0c\u53d1\u9001es MQ\u5931\u8d25\uff1a" + e);
                    }
                } while (++num <= total);
            }
        } else if (!CollectionUtils.isEmpty(updateCheckBusiRspBo.getMallBrandIdList())) {
            updateCheckBusiReqBo.setMallBrandIdList(updateCheckBusiRspBo.getMallBrandIdList());
            updateCheckBusiRspBo = this.uccMallBrandUpdateCheckBusiService.deleteMallBrand(updateCheckBusiReqBo);
            if (!"0000".equals(updateCheckBusiRspBo.getRespCode())) {
                log.error("\u5546\u57ce\u54c1\u724c\u5173\u8054\u66f4\u65b0\u5931\u8d25\u540e\u5220\u9664\u65b0\u521b\u5efa\u7684\u5546\u57ce\u54c1\u724c\u5931\u8d25\uff01{}", (Object)updateCheckBusiRspBo.getRespDesc());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getBrandInfo()) && ((UccMallBrandUpdateAbilityBo)reqBo.getBrandInfo().get(0)).getMallBrandId() != null) {
            try {
                UccSyncBrandToDGAtomReqBo uccSyncBrandToDGAtomReqBo = new UccSyncBrandToDGAtomReqBo();
                uccSyncBrandToDGAtomReqBo.setBrandIds((List)Lists.newArrayList((Object[])new Long[]{((UccMallBrandUpdateAbilityBo)reqBo.getBrandInfo().get(0)).getMallBrandId()}));
                this.uccSyncBrandToDGAtomService.dealSyncBrandToDG(uccSyncBrandToDGAtomReqBo);
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u6570\u636e\u6cbb\u7406\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return busiRspBo;
    }

    private void syncEs(List<BrandESBO> brandInfoList) {
        if (!CollectionUtils.isEmpty(brandInfoList)) {
            brandInfoList.forEach(esbo -> {
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBo = new SyncSceneCommodityToEsReqBO();
                UccMallEsUpdateReqBo uccMallEsUpdateReqBo = new UccMallEsUpdateReqBo();
                uccMallEsUpdateReqBo.setBrandId(esbo.getBrandIdList());
                uccMallEsUpdateReqBo.setOriginBrandId(esbo.getOriginBrandIdList());
                uccMallEsUpdateReqBo.setUpdateMap(esbo.getBrandMap());
                syncSceneCommodityToEsReqBo.setUccMallEsUpdateReqBo(uccMallEsUpdateReqBo);
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBo)));
            });
        }
    }
}

