/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccOrderMatchWarehouseCatalogAbilityService;
import com.tydic.commodity.common.ability.bo.UccEnterpriseWarehouseBO;
import com.tydic.commodity.common.ability.bo.UccOrderMatchWarehouseCatalogAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccOrderMatchWarehouseCatalogAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccOrderMatchWarehouseCatalogBO;
import com.tydic.commodity.dao.UccEnterpriseWarehouseMapper;
import com.tydic.commodity.dao.UccWarehouseAddressMapper;
import com.tydic.commodity.dao.UccWarehouseBuyerMapper;
import com.tydic.commodity.dao.UccWarehouseCatalogMapper;
import com.tydic.commodity.po.UccEnterpriseWarehousePO;
import com.tydic.commodity.po.UccWarehouseAddressPO;
import com.tydic.commodity.po.UccWarehouseBuyerPO;
import com.tydic.commodity.po.UccWarehouseCatalogPO;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccOrderMatchWarehouseCatalogAbilityService"})
public class UccOrderMatchWarehouseCatalogAbilityServiceImpl
implements UccOrderMatchWarehouseCatalogAbilityService {
    @Autowired
    private UccEnterpriseWarehouseMapper uccEnterpriseWarehouseMapper;
    @Autowired
    private UccWarehouseCatalogMapper uccWarehouseCatalogMapper;
    @Autowired
    private UccWarehouseAddressMapper uccWarehouseAddressMapper;
    @Autowired
    private UccWarehouseBuyerMapper uccWarehouseBuyerMapper;

    @PostMapping(value={"dealWarehouseCatalogMatch"})
    public UccOrderMatchWarehouseCatalogAbilityRspBO dealWarehouseCatalogMatch(@RequestBody UccOrderMatchWarehouseCatalogAbilityReqBO reqBO) {
        this.valid(reqBO);
        UccOrderMatchWarehouseCatalogAbilityRspBO rspBO = new UccOrderMatchWarehouseCatalogAbilityRspBO();
        ArrayList<UccOrderMatchWarehouseCatalogBO> result = new ArrayList<UccOrderMatchWarehouseCatalogBO>();
        Map catalogMap = reqBO.getCatalogCodes();
        boolean mathFlag = false;
        UccWarehouseAddressPO addressPO = new UccWarehouseAddressPO();
        addressPO.setAddress(reqBO.getAddress());
        addressPO.setOrgCode(reqBO.getBuyerNo());
        addressPO.setSupplierIds(reqBO.getSupplierIds());
        Long warehouseId = null;
        List exceptionAddressList = this.uccWarehouseAddressMapper.selectByAddressNew(addressPO);
        for (Object uccWarehouseAddressPO : exceptionAddressList) {
            List catalogCodes = (List)catalogMap.get(uccWarehouseAddressPO.getSupplierId().toString());
            if (CollectionUtils.isEmpty((Collection)catalogCodes)) continue;
            if (uccWarehouseAddressPO.getAddressType().equals(UccConstants.AddressType.EXCLUSE)) {
                for (String catalogCode : catalogCodes) {
                    UccOrderMatchWarehouseCatalogBO catalogBO = new UccOrderMatchWarehouseCatalogBO();
                    catalogBO.setSupplierId(uccWarehouseAddressPO.getSupplierId());
                    catalogBO.setCatalogCode(catalogCode);
                    catalogBO.setIsMatchWarehouse(UccConstants.IsMatchWarehouse.NO);
                    result.add(catalogBO);
                    catalogMap.remove(uccWarehouseAddressPO.getSupplierId().toString());
                }
                continue;
            }
            if (!uccWarehouseAddressPO.getAddressType().equals(UccConstants.AddressType.SUPPLEMENT)) continue;
            this.dealCatalogMatch(catalogCodes, (UccWarehouseAddressPO)uccWarehouseAddressPO, result);
            catalogMap.remove(uccWarehouseAddressPO.getSupplierId().toString());
            if (warehouseId != null && !warehouseId.equals(uccWarehouseAddressPO.getWarehouseId())) {
                throw new FscBusinessException("0001", "\u6570\u636e\u5f02\u5e38,\u540c\u4e00\u5730\u5740\u4e0d\u80fd\u914d\u7f6e\u5728\u4e0d\u540c\u4f01\u914d\u8231\u4e0b\uff01");
            }
            if (!uccWarehouseAddressPO.isMatchWarehouse()) continue;
            warehouseId = uccWarehouseAddressPO.getWarehouseId();
        }
        if (!CollectionUtils.isEmpty((Map)catalogMap)) {
            addressPO.setAddress(null);
            addressPO.setSupplierIdsSet(catalogMap.keySet());
            addressPO.setProvinceCode(reqBO.getProvinceCode());
            addressPO.setCityCode(reqBO.getCityCode());
            addressPO.setCountyCode(reqBO.getCountyCode());
            addressPO.setTownCode(reqBO.getTownCode());
            addressPO.setAddressTypes(Collections.singletonList(UccConstants.AddressType.CURRENT));
            addressPO.setWarehouseId(warehouseId);
            List commonAddressList = this.uccWarehouseAddressMapper.selectByAddressNew(addressPO);
            for (UccWarehouseAddressPO uccWarehouseAddressPO : commonAddressList) {
                List catalogCodes = (List)catalogMap.get(uccWarehouseAddressPO.getSupplierId().toString());
                this.dealCatalogMatch(catalogCodes, uccWarehouseAddressPO, result);
                catalogMap.remove(uccWarehouseAddressPO.getSupplierId().toString());
                if (warehouseId != null && !warehouseId.equals(uccWarehouseAddressPO.getWarehouseId())) {
                    throw new FscBusinessException("0001", "\u6570\u636e\u5f02\u5e38,\u540c\u4e00\u5730\u5740\u4e0d\u80fd\u914d\u7f6e\u5728\u4e0d\u540c\u4f01\u914d\u8231\u4e0b\uff01");
                }
                if (!uccWarehouseAddressPO.isMatchWarehouse()) continue;
                warehouseId = uccWarehouseAddressPO.getWarehouseId();
            }
        }
        if (!CollectionUtils.isEmpty((Map)catalogMap)) {
            UccWarehouseBuyerPO warehouseBuyerPO = new UccWarehouseBuyerPO();
            warehouseBuyerPO.setOrgCode(reqBO.getBuyerNo());
            warehouseBuyerPO.setWarehouseId(warehouseId);
            warehouseBuyerPO.setSupplierIdsSet(catalogMap.keySet());
            warehouseBuyerPO.setStatus(UccConstants.WarehouseState.VALID);
            List list = this.uccWarehouseBuyerMapper.getListNew(warehouseBuyerPO);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                for (UccWarehouseBuyerPO buyerPO : list) {
                    List catalogCodes = (List)catalogMap.get(buyerPO.getSupplierId().toString());
                    UccWarehouseAddressPO uccWarehouseAddressPO = new UccWarehouseAddressPO();
                    uccWarehouseAddressPO.setWarehouseId(((UccWarehouseBuyerPO)list.get(0)).getWarehouseId());
                    uccWarehouseAddressPO.setSupplierId(buyerPO.getSupplierId());
                    this.dealCatalogMatch(catalogCodes, uccWarehouseAddressPO, result);
                    catalogMap.remove(buyerPO.getSupplierId().toString());
                    if (warehouseId != null && !warehouseId.equals(uccWarehouseAddressPO.getWarehouseId())) {
                        throw new FscBusinessException("0001", "\u6570\u636e\u5f02\u5e38,\u5730\u5740\u548c\u4e70\u53d7\u4eba\u914d\u7f6e\u51b2\u7a81\uff01");
                    }
                    if (!uccWarehouseAddressPO.isMatchWarehouse()) continue;
                    warehouseId = uccWarehouseAddressPO.getWarehouseId();
                }
            }
        }
        if (!CollectionUtils.isEmpty((Map)catalogMap)) {
            for (String supplierId : catalogMap.keySet()) {
                for (String catalogCode : (List)catalogMap.get(supplierId)) {
                    UccOrderMatchWarehouseCatalogBO catalogBO = new UccOrderMatchWarehouseCatalogBO();
                    catalogBO.setSupplierId(Long.valueOf(supplierId));
                    catalogBO.setCatalogCode(catalogCode);
                    catalogBO.setIsMatchWarehouse(UccConstants.IsMatchWarehouse.NO);
                    result.add(catalogBO);
                }
            }
        }
        if (warehouseId != null) {
            UccEnterpriseWarehousePO warehousePO = new UccEnterpriseWarehousePO();
            warehousePO.setWarehouseId(warehouseId);
            warehousePO = this.uccEnterpriseWarehouseMapper.getModelBy(warehousePO);
            if (warehousePO == null) {
                throw new FscBusinessException("0001", "\u6570\u636e\u5f02\u5e38,\u67e5\u8be2\u4f01\u914d\u4ed3\u4fe1\u606f\u4e3a\u7a7a\uff1a" + warehouseId);
            }
            UccEnterpriseWarehouseBO warehouseBO = new UccEnterpriseWarehouseBO();
            BeanUtils.copyProperties((Object)warehousePO, (Object)warehouseBO);
            rspBO.setUccEnterpriseWarehouseBO(warehouseBO);
            mathFlag = true;
        }
        rspBO.setResult(result);
        rspBO.setMathFlag(Boolean.valueOf(mathFlag));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealCatalogMatch(List<String> catalogCodes, UccWarehouseAddressPO uccWarehouseAddressPO, List<UccOrderMatchWarehouseCatalogBO> result) {
        UccWarehouseCatalogPO catalogPO = new UccWarehouseCatalogPO();
        catalogPO.setCatalogCodes(catalogCodes);
        catalogPO.setWarehouseId(uccWarehouseAddressPO.getWarehouseId());
        catalogPO.setState(UccConstants.WarehouseState.VALID);
        List catalogPOList = this.uccWarehouseCatalogMapper.getList(catalogPO);
        boolean matchWarehouse = true;
        if (!CollectionUtils.isEmpty((Collection)catalogPOList)) {
            Map<String, String> confMap = catalogPOList.stream().collect(Collectors.toMap(UccWarehouseCatalogPO::getCatalogCode, UccWarehouseCatalogPO::getCatalogName));
            for (String catalogCode : catalogCodes) {
                Integer isMatchWarehouse = UccConstants.IsMatchWarehouse.YES;
                if (!StringUtils.isEmpty((Object)confMap.get(catalogCode))) {
                    isMatchWarehouse = UccConstants.IsMatchWarehouse.NO;
                    matchWarehouse = false;
                }
                UccOrderMatchWarehouseCatalogBO catalogBO = new UccOrderMatchWarehouseCatalogBO();
                catalogBO.setIsMatchWarehouse(isMatchWarehouse);
                catalogBO.setSupplierId(uccWarehouseAddressPO.getSupplierId());
                catalogBO.setCatalogCode(catalogCode);
                result.add(catalogBO);
            }
        } else {
            for (String catalogCode : catalogCodes) {
                UccOrderMatchWarehouseCatalogBO catalogBO = new UccOrderMatchWarehouseCatalogBO();
                catalogBO.setIsMatchWarehouse(UccConstants.IsMatchWarehouse.YES);
                catalogBO.setSupplierId(uccWarehouseAddressPO.getSupplierId());
                catalogBO.setCatalogCode(catalogCode);
                result.add(catalogBO);
            }
        }
        uccWarehouseAddressPO.setMatchWarehouse(matchWarehouse);
    }

    private void valid(UccOrderMatchWarehouseCatalogAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getAddress())) {
            throw new BusinessException("0001", "\u5165\u53c2[address]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Map)reqBO.getCatalogCodes())) {
            throw new BusinessException("0001", "\u5165\u53c2[catalogCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getProvinceCode() == null) {
            throw new BusinessException("0001", "\u5165\u53c2[provinceCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

