/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccSimilerBrandRelAbilityService;
import com.tydic.commodity.common.ability.bo.UccSimilerBrandRelAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSimilerBrandRelAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccSimilerBrandRelBusiService;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSimilerBrandRelAbilityService"})
public class UccSimilerBrandRelAbilityServiceImpl
implements UccSimilerBrandRelAbilityService {
    @Autowired
    private UccSimilerBrandRelBusiService uccSimilerBrandRelBusiService;

    @PostMapping(value={"dealSimilerBrandRel"})
    public UccSimilerBrandRelAbilityRspBO dealSimilerBrandRel(@RequestBody UccSimilerBrandRelAbilityReqBO reqBO) {
        this.validateReq(reqBO);
        return this.uccSimilerBrandRelBusiService.dealSimilerBrandRel(reqBO);
    }

    private void validateReq(UccSimilerBrandRelAbilityReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getType())) {
            throw new BusinessException("8888", "\u5165\u53c2 type \u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getExtBrandId()) && UccConstants.DealSimilerBrandRelType.CONFIRM.equals(reqBO.getType())) {
            throw new BusinessException("8888", "\u5165\u53c2 extBrandId \u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getBrandIdList()) && UccConstants.DealSimilerBrandRelType.CONFIRM.equals(reqBO.getType())) {
            throw new BusinessException("8888", "\u5165\u53c2 brandIdList \u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSimilerRelIdList()) && UccConstants.DealSimilerBrandRelType.LIFT.equals(reqBO.getType())) {
            throw new BusinessException("8888", "\u5165\u53c2 similerRelIdList \u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getExtBrandIdList()) && UccConstants.DealSimilerBrandRelType.LIFT_BY_EXT_BRAND_ID.equals(reqBO.getType())) {
            throw new BusinessException("8888", "\u5165\u53c2 extBrandIdList \u7a7a");
        }
    }
}

