/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.common.ability.api.UccUpdateCatalogRelBrandAbilityService;
import com.tydic.commodity.common.ability.bo.UccAutoHideCatalogStandardSkuAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccUpdateCatalogRelBrandAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccUpdateCatalogRelBrandAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccUpdateCatalogRelBrandBusiService;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccUpdateCatalogRelBrandAbilityService"})
public class UccUpdateCatalogRelBrandAbilityServiceImpl
implements UccUpdateCatalogRelBrandAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccUpdateCatalogRelBrandAbilityServiceImpl.class);
    @Autowired
    private UccUpdateCatalogRelBrandBusiService uccUpdateCatalogRelBrandBusiService;
    @Resource(name="brandSkuHideProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${BRAND_SKU_HIDE_TOPIC:BRAND_SKU_HIDE_TOPIC}")
    private String brandSkuHideTopic;
    public static final Integer OPER_TYPE_HIDE_CATALOG = 1;
    public static final Integer OPER_TYPE_DISPLAY_CATALOG = 2;
    public static final Integer OPER_TYPE_HIDE_BANNER = 3;

    @PostMapping(value={"updateCatalogRelBrand"})
    public UccUpdateCatalogRelBrandAbilityRspBO updateCatalogRelBrand(@RequestBody UccUpdateCatalogRelBrandAbilityReqBO reqBO) {
        UccUpdateCatalogRelBrandAbilityRspBO rspBO = this.uccUpdateCatalogRelBrandBusiService.updateCatalogRelBrand(reqBO);
        if ("0000".equals(rspBO.getRespCode()) && reqBO.getDiscountFlag() != null && reqBO.getDiscountFlag() == 0) {
            ArrayList<Integer> operType = new ArrayList<Integer>();
            if (reqBO.getStatus() != null && reqBO.getStatus() == 2) {
                operType.add(OPER_TYPE_DISPLAY_CATALOG);
            }
            if (reqBO.getStatus() != null && reqBO.getStatus() == 1) {
                operType.add(OPER_TYPE_HIDE_BANNER);
            }
            if (!CollectionUtils.isEmpty(operType)) {
                UccAutoHideCatalogStandardSkuAbilityReqBO abilityReqBO = new UccAutoHideCatalogStandardSkuAbilityReqBO();
                try {
                    this.proxyMessageProducer.send(new ProxyMessage(this.brandSkuHideTopic, "*", JSON.toJSONString((Object)abilityReqBO)));
                }
                catch (Exception e) {
                    log.error("\u4e0a\u67b6\u7533\u8bf7\u5355\u5ba1\u6279\u901a\u8fc7\u540e\u53d1\u9001\u6d88\u606f\u5931\u8d25");
                }
            }
        }
        return rspBO;
    }
}

