/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.enumType.GuideCatalogEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccCatalogAddReqBO;
import com.tydic.commodity.common.ability.bo.UccCatalogAddRspBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.api.UccCatalogAddBusiService;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.po.UccCatalogDealPO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccCatalogAddBusiServiceImpl
implements UccCatalogAddBusiService {
    @Autowired
    private UccCatalogDealMapper mapper;
    private Sequence uccBrandSequence = Sequence.getInstance();
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private CacheClient cacheClient;
    UccCatalogAddRspBO rspBO = new UccCatalogAddRspBO();
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCatalogAddBusiServiceImpl.class);

    @Override
    public UccCatalogAddRspBO addCatalog(UccCatalogAddReqBO reqBO) {
        if (!this.judge(reqBO)) {
            this.rspBO.setRespCode("8888");
            return this.rspBO;
        }
        this.dealOrder(reqBO);
        this.rspBO = new UccCatalogAddRspBO();
        UccCatalogDealPO catalogDealPO = new UccCatalogDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)catalogDealPO);
        int result = 0;
        try {
            catalogDealPO.setGuideCatalogId(Long.valueOf(this.uccBrandSequence.nextId()));
            result = this.mapper.addCatalog(catalogDealPO);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u6570\u636e\u5e93\u6dfb\u52a0\u5f02\u5e38");
        }
        if (result > 0) {
            this.rspBO.setRespCode("0000");
            this.rspBO.setRespDesc("\u63d2\u5165\u7c7b\u76ee\u6210\u529f");
            this.rspBO.setGuideCatalogId(catalogDealPO.getGuideCatalogId());
            this.cacheClient.delete("ucc_channel_redis_key1001");
        } else {
            this.rspBO.setRespCode("8888");
            this.rspBO.setRespDesc("\u63d2\u5165\u7c7b\u76ee\u5931\u8d25");
        }
        return this.rspBO;
    }

    public boolean judge(UccCatalogAddReqBO reqBO) {
        Map<String, String> map = null;
        if (reqBO.getCatalogName() == null || reqBO.getCatalogName().equals("")) {
            this.rspBO.setRespDesc("\u63d2\u5165\u7c7b\u76ee\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (reqBO.getCatalogLevel() != null) {
            map = this.uccDictionaryAtomService.queryBypCodeBackMap(GuideCatalogEnum.GUIDE_CATALOG_LEVEL.toString());
            if (!map.containsKey(String.valueOf(reqBO.getCatalogLevel()))) {
                this.rspBO.setRespDesc("\u7c7b\u76ee\u7b49\u7ea7\u8f93\u5165\u9519\u8bef");
                return false;
            }
            if (reqBO.getCatalogLevel() == 1) {
                reqBO.setUpperCatalogId(Long.valueOf(0L));
            } else if (reqBO.getUpperCatalogId() == null) {
                this.rspBO.setRespDesc("\u8bf7\u9009\u62e9\u4e0a\u7ea7\u7c7b\u76ee");
                this.rspBO.setGuideCatalogId(null);
                return false;
            }
        } else {
            this.rspBO.setRespDesc("\u7c7b\u76ee\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (reqBO.getCatalogCode() == null || reqBO.getCatalogCode().equals("")) {
            this.rspBO.setRespDesc("\u7c7b\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (reqBO.getShopCatalogType() == null) {
            this.rspBO.setRespDesc("\u7c7b\u76ee\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (reqBO.getCatalogStatus() == null) {
            this.rspBO.setRespDesc("\u7c7b\u76ee\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        map = this.uccDictionaryAtomService.queryBypCodeBackMap(GuideCatalogEnum.GUIDE_CATALOG_STATUS.toString());
        if (!map.containsKey(String.valueOf(reqBO.getCatalogStatus()))) {
            this.rspBO.setRespDesc("\u7c7b\u76ee\u72b6\u6001\u8f93\u5165\u9519\u8bef");
            return false;
        }
        if (reqBO.getViewOrder() == null) {
            this.rspBO.setRespDesc("\u7c7b\u76ee\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        return true;
    }

    private void dealOrder(UccCatalogAddReqBO reqBO) {
        UccCatalogDealPO uccCatalogDealPO1 = new UccCatalogDealPO();
        uccCatalogDealPO1.setUpperCatalogId(reqBO.getUpperCatalogId());
        uccCatalogDealPO1.setCatalogLevel(reqBO.getCatalogLevel());
        uccCatalogDealPO1.setOrderStr("VIEW_ORDER ASC");
        List uccCatalogDealPOS = this.mapper.queryCatalog(uccCatalogDealPO1);
        if (CollectionUtils.isEmpty((Collection)uccCatalogDealPOS)) {
            reqBO.setViewOrder(Integer.valueOf(0));
            return;
        }
        UccCatalogDealPO lastPo = (UccCatalogDealPO)uccCatalogDealPOS.get(uccCatalogDealPOS.size() - 1);
        if (lastPo.getGuideCatalogId().equals(reqBO.getBehindCatalogId())) {
            reqBO.setViewOrder(Integer.valueOf(lastPo.getViewOrder() + 1));
            return;
        }
        int index = IntStream.range(0, uccCatalogDealPOS.size()).filter(i -> ((UccCatalogDealPO)uccCatalogDealPOS.get(i)).getGuideCatalogId().equals(reqBO.getBehindCatalogId())).findFirst().orElse(-1);
        Integer orderViewOrder = ((UccCatalogDealPO)uccCatalogDealPOS.get(index)).getViewOrder();
        reqBO.setViewOrder(Integer.valueOf(orderViewOrder + 1));
        List subList = uccCatalogDealPOS.subList(index + 1, uccCatalogDealPOS.size());
        subList.forEach(x -> x.setViewOrder(Integer.valueOf(x.getViewOrder() + 2)));
        this.mapper.updateUccCatalogList(subList);
    }
}

