/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.enumType.Brand;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccBrandRelCatalogLevelBO;
import com.tydic.commodity.common.ability.bo.UccBrandUpdateReqBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.api.UccBrandUpdateBusiService;
import com.tydic.commodity.common.busi.api.UccMallBrandDetailInfoGroupListBusiService;
import com.tydic.commodity.common.busi.bo.UccMallBrandDetailInfoGroupListAbilityBo;
import com.tydic.commodity.common.busi.bo.UccMallBrandDetailInfoGroupListBusiReqBo;
import com.tydic.commodity.common.busi.bo.UccMallBrandDetailInfoGroupListBusiRspBo;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccBrandExtMapper;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccBrandRelCatalogLevelPo;
import com.tydic.commodity.po.UccMallBrandDetailInfoGroupListAbilityPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMallBrandDetailInfoGroupListBusiServiceImpl
implements UccMallBrandDetailInfoGroupListBusiService {
    @Autowired
    private UccBrandExtMapper uccBrandExtMapper;
    @Autowired
    private UccBrandUpdateBusiService uccBrandUpdateBusiService;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;

    @Override
    public UccMallBrandDetailInfoGroupListBusiRspBo qryMallBrandDetailGroup(UccMallBrandDetailInfoGroupListBusiReqBo reqBo) {
        UccMallBrandDetailInfoGroupListBusiRspBo rspBo = new UccMallBrandDetailInfoGroupListBusiRspBo();
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        ArrayList<UccMallBrandDetailInfoGroupListAbilityBo> mallBrandDetailList = new ArrayList();
        UccMallBrandDetailInfoGroupListAbilityPO queryBo = (UccMallBrandDetailInfoGroupListAbilityPO)BeanUtil.copyProperties((Object)((Object)reqBo), UccMallBrandDetailInfoGroupListAbilityPO.class);
        queryBo.setBrandStatusList((List)Lists.newArrayList((Object[])new Integer[]{0, 1}));
        List getMallBrandDetailGroupList = this.uccBrandExtMapper.getMallBrandDetailGroupPageByParam(queryBo, page);
        if (!CollectionUtils.isEmpty((Collection)getMallBrandDetailGroupList)) {
            mallBrandDetailList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)getMallBrandDetailGroupList), UccMallBrandDetailInfoGroupListAbilityBo.class);
            this.collectRelCatalogInfo(getMallBrandDetailGroupList, mallBrandDetailList);
        }
        if (!CollectionUtils.isEmpty(mallBrandDetailList)) {
            Map<String, String> brand = this.uccDictionaryAtomService.queryBypCodeBackMap(Brand.BRAND_STATUS.toString());
            Map<String, String> appRange = this.uccDictionaryAtomService.queryBypCodeBackMap(Brand.APP_RANGE.toString());
            if (brand != null) {
                for (UccMallBrandDetailInfoGroupListAbilityBo each : mallBrandDetailList) {
                    if (each.getBrandStatus() == null || !brand.containsKey(each.getBrandStatus().toString())) continue;
                    each.setBrandStatusDesc(brand.get(each.getBrandStatus().toString()));
                }
            }
            if (appRange != null) {
                for (UccMallBrandDetailInfoGroupListAbilityBo each : mallBrandDetailList) {
                    if (each.getAppRange() == null || !appRange.containsKey(each.getAppRange().toString())) continue;
                    each.setAppRangeDesc(appRange.get(each.getAppRange().toString()));
                }
            }
        }
        rspBo.setRows(mallBrandDetailList);
        rspBo.setPageNo(page.getPageNo());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void collectRelCatalogInfo(List<UccMallBrandDetailInfoGroupListAbilityPO> getMallBrandDetailGroupList, List<UccMallBrandDetailInfoGroupListAbilityBo> mallBrandDetailList) {
        List brandIds = getMallBrandDetailGroupList.stream().map(UccMallBrandDetailInfoGroupListAbilityPO::getMallBrandId).collect(Collectors.toList());
        List catalogLevelList = this.uccBrandDealMapper.queryCatalogTreeList(brandIds);
        if (!CollectionUtils.isEmpty((Collection)catalogLevelList)) {
            Map<Long, List<UccBrandRelCatalogLevelPo>> brandCatalogMap = catalogLevelList.stream().collect(Collectors.groupingBy(UccBrandRelCatalogLevelPo::getBrandId));
            for (UccMallBrandDetailInfoGroupListAbilityBo each : mallBrandDetailList) {
                if (!brandCatalogMap.containsKey(each.getMallBrandId())) continue;
                List uccBrandRelCatalogLevelBOS = JSON.parseArray((String)JSON.toJSONString(brandCatalogMap.get(each.getMallBrandId())), UccBrandRelCatalogLevelBO.class);
                each.setCatalogLevelBOS(uccBrandRelCatalogLevelBOS);
                each.setCatalogLevelSplitStr(uccBrandRelCatalogLevelBOS.stream().map(UccBrandRelCatalogLevelBO::getCatalogLevelNameStr).collect(Collectors.joining(",")));
            }
        }
    }

    private void ChangeBrandStatus(UccMallBrandDetailInfoGroupListBusiRspBo rspBo, UccBrandUpdateReqBO uccBrandUpdateReqBO) {
        try {
            UccBrandDealPO uccBrandDealPO = new UccBrandDealPO();
            uccBrandDealPO.setBrandId(uccBrandUpdateReqBO.getBrandId());
            uccBrandDealPO.setBrandStatus(uccBrandUpdateReqBO.getBrandStatus());
            this.uccBrandDealMapper.updateBrand(uccBrandDealPO);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u4fee\u6539\u54c1\u724c\u72b6\u6001\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

