/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.common.ability.api.UccBrandUpdateAbilityService;
import com.tydic.commodity.common.ability.bo.UccBrandBatchDownSkuEsReqBO;
import com.tydic.commodity.common.ability.bo.UccBrandUpdateReqBO;
import com.tydic.commodity.common.ability.bo.UccBrandUpdateRspBO;
import com.tydic.commodity.common.busi.api.UccBrandUpdateBusiService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccBrandUpdateAbilityService"})
public class UccBrandUpdateAbilityServiceImpl
implements UccBrandUpdateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccBrandUpdateAbilityServiceImpl.class);
    @Autowired
    private UccBrandUpdateBusiService uccBrandUpdateBusiService;
    @Resource(name="brandSkuDownProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${BRAND_SKU_DOWN_TOPIC:BRAND_SKU_DOWN_TOPIC}")
    private String topic;

    @PostMapping(value={"updateBrand"})
    public UccBrandUpdateRspBO updateBrand(@RequestBody UccBrandUpdateReqBO reqBO) {
        UccBrandUpdateRspBO rspBO = this.uccBrandUpdateBusiService.updateBrand(reqBO);
        if (rspBO.isSyncFlag()) {
            UccBrandBatchDownSkuEsReqBO esReqBO = new UccBrandBatchDownSkuEsReqBO();
            esReqBO.setBrandId(reqBO.getBrandId());
            try {
                this.proxyMessageProducer.send(new ProxyMessage(this.topic, "*", JSON.toJSONString((Object)esReqBO)));
            }
            catch (Exception e) {
                log.error("\u540c\u6b65ES{}MQ\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Object)"\u54c1\u724c\u5bf9\u5e94\u5546\u54c1\u6279\u91cf\u4e0b\u67b6");
            }
        }
        return rspBO;
    }
}

