/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.google.common.collect.Lists;
import com.tydic.commodity.common.ability.api.UccMaterialInfoQueryAbilityService;
import com.tydic.commodity.common.ability.api.UccMaterialSearchService;
import com.tydic.commodity.common.ability.bo.DycSyncMaterialEsBo;
import com.tydic.commodity.common.ability.bo.UccMaterialInfoQueryAbilityBo;
import com.tydic.commodity.common.ability.bo.UccMaterialInfoQueryAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccMaterialInfoQueryAbilityRspBo;
import com.tydic.commodity.common.ability.bo.UccMaterialSearchReqBo;
import com.tydic.commodity.common.ability.bo.UccMaterialSearchRspBo;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccMaterialInfoQueryAbilityService"})
public class UccMaterialInfoQueryAbilityServiceImpl
implements UccMaterialInfoQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMaterialInfoQueryAbilityServiceImpl.class);
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccEMdmCatalogMapper uccMdmCatalogMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccMaterialSearchService uccMaterialSearchService;

    @PostMapping(value={"getUccMaterialInfo"})
    public UccMaterialInfoQueryAbilityRspBo getUccMaterialInfo(@RequestBody UccMaterialInfoQueryAbilityReqBo reqBo) {
        UccMaterialInfoQueryAbilityRspBo rspBo = new UccMaterialInfoQueryAbilityRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        reqBo.setIsprofess("0");
        reqBo.setUserErpCode("");
        if (reqBo.isQueryErpFlag() && StringUtils.isEmpty((Object)reqBo.getUserErpCode()) && !"0".equals(reqBo.getIsprofess())) {
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        ArrayList<UccMaterialInfoQueryAbilityBo> uccMaterialInfoQueryAbilityBos = new ArrayList<UccMaterialInfoQueryAbilityBo>();
        UccMaterialSearchReqBo uccMaterialSearchReqBo = new UccMaterialSearchReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)uccMaterialSearchReqBo);
        if (!StringUtils.isEmpty((Object)reqBo.getUserErpCode())) {
            uccMaterialSearchReqBo.setErpCodes((List)Lists.newArrayList((Object[])new String[]{reqBo.getUserErpCode()}));
        }
        uccMaterialSearchReqBo.setLikeFields((List)Lists.newArrayList((Object[])new String[]{"materialCode", "materialName", "spec", "model"}));
        UccMaterialSearchRspBo uccMaterialSearchRspBo = this.uccMaterialSearchService.searchMaterial(uccMaterialSearchReqBo);
        if (!CollectionUtils.isEmpty((Collection)uccMaterialSearchRspBo.getRows())) {
            Map<String, String> freezeFlagMap = this.uccDictionaryAtomService.queryBypCodeBackMap("FREEZE_FLAG");
            for (DycSyncMaterialEsBo uccEMdmMaterialPo1 : uccMaterialSearchRspBo.getRows()) {
                UccMaterialInfoQueryAbilityBo uccMaterialInfoQueryAbilityBo = new UccMaterialInfoQueryAbilityBo();
                BeanUtils.copyProperties((Object)uccEMdmMaterialPo1, (Object)uccMaterialInfoQueryAbilityBo);
                uccMaterialInfoQueryAbilityBo.setCatalogId(uccEMdmMaterialPo1.getCatalogId());
                uccMaterialInfoQueryAbilityBo.setMaterialId(uccEMdmMaterialPo1.getMaterialId().toString());
                uccMaterialInfoQueryAbilityBo.setMaterialName(uccEMdmMaterialPo1.getMaterialName());
                uccMaterialInfoQueryAbilityBo.setMaterialDesc(uccEMdmMaterialPo1.getLongDesc());
                uccMaterialInfoQueryAbilityBo.setMaterialModel(uccEMdmMaterialPo1.getModel());
                uccMaterialInfoQueryAbilityBo.setMaterialSpec(uccEMdmMaterialPo1.getSpec());
                uccMaterialInfoQueryAbilityBo.setUnit(uccEMdmMaterialPo1.getMeasure());
                uccMaterialInfoQueryAbilityBo.setMaterialCode(uccEMdmMaterialPo1.getMaterialCode());
                uccMaterialInfoQueryAbilityBo.setCatalogCode(uccEMdmMaterialPo1.getCatalogCode());
                this.getAllName(uccMaterialInfoQueryAbilityBo);
                if (uccMaterialInfoQueryAbilityBo.getFreezeFlag() != null && !CollectionUtils.isEmpty(freezeFlagMap)) {
                    uccMaterialInfoQueryAbilityBo.setFreezeFlagDesc(freezeFlagMap.get(uccMaterialInfoQueryAbilityBo.getFreezeFlag().toString()));
                }
                uccMaterialInfoQueryAbilityBos.add(uccMaterialInfoQueryAbilityBo);
            }
        }
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRecordsTotal(uccMaterialSearchRspBo.getRecordsTotal());
        rspBo.setTotal(uccMaterialSearchRspBo.getTotal());
        rspBo.setRows(uccMaterialInfoQueryAbilityBos);
        return rspBo;
    }

    private void getAllName(UccMaterialInfoQueryAbilityBo bo) {
        UccEMdmCatalogPO uccEMdmCatalogPO;
        if (null != bo && bo.getCatalogId() != null && (uccEMdmCatalogPO = this.uccMdmCatalogMapper.queryByCatId(bo.getCatalogId())) != null) {
            StringBuffer name = new StringBuffer(uccEMdmCatalogPO.getCatalogName());
            while (uccEMdmCatalogPO.getParentCatalogId() != null && uccEMdmCatalogPO.getParentCatalogId() != 0L && (uccEMdmCatalogPO = this.uccMdmCatalogMapper.queryByCatId(uccEMdmCatalogPO.getParentCatalogId())) != null) {
                name = new StringBuffer(uccEMdmCatalogPO.getCatalogName()).append("/").append(name);
            }
            bo.setCatalogNameAll(name.toString());
        }
    }
}

