/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.common.ability.api.UccSearchWordBlackTimeDealService;
import com.tydic.commodity.common.ability.api.UccSkuOperationLogRecordAbilityService;
import com.tydic.commodity.common.ability.bo.UccSearchWordBlackTimeDealReqBo;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityBO;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityReqBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSearchWordBlackMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSearchWordBlackPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.uac.ability.UacNoTaskAuditCancelAbilityService;
import com.tydic.uac.ability.UacNoTaskAuditOrderSyncAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelRspBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderSyncReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderSyncRspBO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSearchWordBlackTimeDealService"})
public class UccSearchWordBlackTimeDealServiceImpl
implements UccSearchWordBlackTimeDealService {
    private static final Logger log = LoggerFactory.getLogger(UccSearchWordBlackTimeDealServiceImpl.class);
    @Autowired
    private UccSearchWordBlackMapper uccSearchWordBlackMapper;
    private static final int dealSize = 2000;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UacNoTaskAuditCancelAbilityService uacNoTaskAuditCancelAbilityService;
    @Autowired
    private UacNoTaskAuditOrderSyncAbilityService uacNoTaskAuditOrderSyncAbilityService;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccSkuOperationLogRecordAbilityService uccSkuOperationLogRecordAbilityService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;

    @PostMapping(value={"dealSearchWordBlackTime"})
    public RspUccBo dealSearchWordBlackTime(@RequestBody UccSearchWordBlackTimeDealReqBo reqBo) {
        RspUccBo rspUccBo = new RspUccBo();
        rspUccBo.setRespCode("0000");
        rspUccBo.setRespDesc("\u6210\u529f");
        ArrayList<String> approvalSensitiveWordList = new ArrayList();
        List uccSearchWordBlackPOS = this.uccSearchWordBlackMapper.getList(new UccSearchWordBlackPO());
        if (CollectionUtils.isEmpty((Collection)uccSearchWordBlackPOS)) {
            return rspUccBo;
        }
        approvalSensitiveWordList = uccSearchWordBlackPOS.stream().map(UccSearchWordBlackPO::getBlackKeyWord).collect(Collectors.toList());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, Integer.valueOf("-" + reqBo.getStrikeDay()));
        Date date = calendar.getTime();
        UccSearchWordBlackPO uccSearchWordBlackPO = new UccSearchWordBlackPO();
        uccSearchWordBlackPO.setStartUpdateTime(date);
        int count = this.uccSearchWordBlackMapper.getCheckBy(uccSearchWordBlackPO);
        if (count > 1) {
            int num = 1;
            int total = 0;
            do {
                Page page = new Page(num, 2000);
                List<UccSkuPo> skuList = this.uccSkuMapper.getSkuIdsBySource(page, Integer.valueOf(2));
                skuList = this.getNotPassSku(skuList, approvalSensitiveWordList);
                if (total == 0) {
                    total = page.getTotalPages();
                }
                if (CollectionUtils.isEmpty(skuList)) continue;
                this.dealElcSku(skuList);
                try {
                    SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBo = new SyncSceneCommodityToEsReqBO();
                    syncSceneCommodityToEsReqBo.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                    syncSceneCommodityToEsReqBo.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    syncSceneCommodityToEsReqBo.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                    syncSceneCommodityToEsReqBo.setSkuIds(skuList.stream().map(a -> a.getSkuId()).collect(Collectors.toList()));
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBo)));
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    throw new BusinessException("8888", "\u7c7b\u76ee\u540c\u6b65ES\u5931\u8d25");
                }
            } while (++num <= total);
        }
        return rspUccBo;
    }

    private void dealElcSku(List<UccSkuPo> skuList) {
        if (CollectionUtils.isEmpty(skuList)) {
            return;
        }
        Map<Long, List<UccSkuPo>> skuMap = skuList.stream().collect(Collectors.groupingBy(a -> a.getSupplierShopId()));
        Iterator<Long> iteratorSku = skuMap.keySet().iterator();
        ArrayList<UccSkuOperationLogRecordAbilityBO> uccSkuOperationLogRecordAbilityBOS = new ArrayList<UccSkuOperationLogRecordAbilityBO>();
        while (iteratorSku.hasNext()) {
            Long supplierShopId = iteratorSku.next();
            List downList = skuMap.get(supplierShopId).stream().map(a -> a.getSkuId()).collect(Collectors.toList());
            for (UccSkuPo uccSkuPo : skuMap.get(supplierShopId)) {
                if (uccSkuPo.getApprovalStatus() == null) continue;
                switch (uccSkuPo.getApprovalStatus()) {
                    case 21: {
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF);
                        break;
                    }
                    case 31: {
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_EDIT);
                        break;
                    }
                    case 41: {
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN);
                        break;
                    }
                    case 51: {
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_RECOVER);
                        break;
                    }
                }
                UccSkuOperationLogRecordAbilityBO uccSkuOperationLogRecordAbilityBO = new UccSkuOperationLogRecordAbilityBO();
                uccSkuOperationLogRecordAbilityBO.setSkuId(uccSkuPo.getSkuId());
                uccSkuOperationLogRecordAbilityBO.setCommodityId(uccSkuPo.getCommodityId());
                uccSkuOperationLogRecordAbilityBO.setOperationType(Integer.valueOf(8));
                uccSkuOperationLogRecordAbilityBO.setRemark("\u654f\u611f\u8bcd\u5f3a\u5236\u5931\u6548");
                uccSkuOperationLogRecordAbilityBOS.add(uccSkuOperationLogRecordAbilityBO);
            }
            if (!CollectionUtils.isEmpty(downList)) {
                UacNoTaskAuditOrderSyncReqBO uocAuditOrderSyncReqBO = new UacNoTaskAuditOrderSyncReqBO();
                uocAuditOrderSyncReqBO.setObjType(Integer.valueOf(6));
                uocAuditOrderSyncReqBO.setOperDept("sys-mgc");
                uocAuditOrderSyncReqBO.setAuditAdvice("\u654f\u611f\u8bcd\u5f3a\u5236\u5931\u6548");
                uocAuditOrderSyncReqBO.setDownload("");
                uocAuditOrderSyncReqBO.setOperid("sys-mgc");
                uocAuditOrderSyncReqBO.setObjId(downList.stream().map(a -> String.valueOf(a)).collect(Collectors.toList()));
                HashMap<String, String> ext = new HashMap<String, String>();
                ext.put("dealStepName", "\u654f\u611f\u8bcd\u5f3a\u5236\u5931\u6548");
                uocAuditOrderSyncReqBO.setExt(ext);
                UacNoTaskAuditOrderSyncRspBO uocAuditOrderSyncBusiRspBO = this.uacNoTaskAuditOrderSyncAbilityService.dealAuditOrderSync(uocAuditOrderSyncReqBO);
                if ("0000".equals(uocAuditOrderSyncBusiRspBO.getRespCode())) {
                    UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
                    UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
                    ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
                    UccSkuUpdateStatusBO bo = null;
                    for (Long each : downList) {
                        bo = new UccSkuUpdateStatusBO();
                        bo.setSkuId(each);
                        bo.setSkuStatus(Integer.valueOf(6));
                        skuUpdateStatusBOS.add(bo);
                    }
                    uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
                    uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
                    uccStatusChangeUpdateSpuAtomReqBO.setUserId(Long.valueOf(0L));
                    uccStatusChangeUpdateSpuAtomReqBO.setApprovalStatus("0");
                    uccStatusChangeUpdateSpuAtomReqBO.setStepId("null");
                    try {
                        statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
                        if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
                        }
                    }
                    catch (Exception e) {
                        log.error("\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25\uff1a" + e.getMessage());
                    }
                } else {
                    log.error("\u654f\u611f\u8bcd\u5f3a\u5236\u5931\u6548\u540c\u6b65\u5ba1\u6279\u65e5\u5fd7\u5931\u8d25");
                }
            }
            try {
                UccSkuOperationLogRecordAbilityReqBO uccSkuOperationLogRecordAbilityReqBO = new UccSkuOperationLogRecordAbilityReqBO();
                uccSkuOperationLogRecordAbilityReqBO.setRecordAbilityBOS(uccSkuOperationLogRecordAbilityBOS);
                this.uccSkuOperationLogRecordAbilityService.recordUccSkuOperationLog(uccSkuOperationLogRecordAbilityReqBO);
            }
            catch (Exception e) {
                log.error("\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    private void cancelAudit(Long skuId, Integer objType) {
        try {
            UacNoTaskAuditCancelReqBO uacNoTaskAuditCancelReqBO = new UacNoTaskAuditCancelReqBO();
            uacNoTaskAuditCancelReqBO.setObjId(skuId.toString());
            uacNoTaskAuditCancelReqBO.setObjType(objType);
            uacNoTaskAuditCancelReqBO.setOperDept("sys-mgc");
            uacNoTaskAuditCancelReqBO.setOperId("sys-mgc");
            uacNoTaskAuditCancelReqBO.setCancelOperId("sys-mgc");
            uacNoTaskAuditCancelReqBO.setCancelReason("\u654f\u611f\u8bcd-\u5f3a\u5236\u5931\u6548");
            UacNoTaskAuditCancelRspBO uacNoTaskAuditCancelRspBO = this.uacNoTaskAuditCancelAbilityService.auditCancel(uacNoTaskAuditCancelReqBO);
            if ("0000".equals(uacNoTaskAuditCancelRspBO.getRespCode())) {
                throw new BusinessException("8888", uacNoTaskAuditCancelRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88\u5ba1\u6279\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private List<UccSkuPo> getNotPassSku(List<UccSkuPo> skuPos, List<String> approvalSensitiveWordList) {
        if (CollectionUtils.isEmpty(skuPos)) {
            return new ArrayList<UccSkuPo>();
        }
        ArrayList<UccSkuPo> notPassSku = new ArrayList<UccSkuPo>();
        List commodityIds = skuPos.stream().map(a -> a.getCommodityId()).distinct().collect(Collectors.toList());
        List uccCommodityPos = this.uccCommodityMapper.queryByCommodityIdLists(commodityIds);
        if (!CollectionUtils.isEmpty((Collection)uccCommodityPos)) {
            Map<Long, String> spuAndName = uccCommodityPos.stream().collect(Collectors.toMap(a -> a.getCommodityId(), b -> b.getCommodityName(), (o, n) -> o));
            skuPos.forEach(sku -> {
                for (String word : approvalSensitiveWordList) {
                    if (!sku.getSkuName().contains(word) && !((String)spuAndName.get(sku.getCommodityId())).contains(word)) continue;
                    notPassSku.add((UccSkuPo)sku);
                    break;
                }
            });
        }
        return notPassSku;
    }
}

