/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccWarehouseAddressUpdateAbilityService;
import com.tydic.commodity.common.ability.bo.UccWarehouseAddressUpdateAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccWarehouseAddressUpdateAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccWarehouseAddressUpdateBusiService;
import com.tydic.commodity.common.busi.bo.UccWarehouseAddressUpdateBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccWarehouseAddressUpdateBusiRspBO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccWarehouseAddressUpdateAbilityService"})
public class UccWarehouseAddressUpdateAbilityServiceImpl
implements UccWarehouseAddressUpdateAbilityService {
    @Autowired
    private UccWarehouseAddressUpdateBusiService uccWarehouseAddressUpdateBusiService;

    @PostMapping(value={"updateWarehouseAddress"})
    public UccWarehouseAddressUpdateAbilityRspBO updateWarehouseAddress(@RequestBody UccWarehouseAddressUpdateAbilityReqBO reqBO) {
        this.validParam(reqBO);
        UccWarehouseAddressUpdateBusiReqBO busiReqBO = (UccWarehouseAddressUpdateBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), UccWarehouseAddressUpdateBusiReqBO.class));
        UccWarehouseAddressUpdateBusiRspBO busiRspBO = this.uccWarehouseAddressUpdateBusiService.updateWarehouseAddress(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new BusinessException(RspConstantEnums.WAREHOUSE_ADDRESS_ADD_FAIL.code(), busiRspBO.getRespDesc());
        }
        return (UccWarehouseAddressUpdateAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), UccWarehouseAddressUpdateAbilityRspBO.class);
    }

    private void validParam(UccWarehouseAddressUpdateAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException(RspConstantEnums.WAREHOUSE_ADDRESS_ADD_FAIL.code(), "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (reqBO.getId() == null) {
            throw new BusinessException(RspConstantEnums.WAREHOUSE_ADDRESS_ADD_FAIL.code(), "\u5165\u53c2\u4e3b\u952eId[id]\u4e3a\u7a7a");
        }
        if (reqBO.getStatus() != null) {
            if (reqBO.getStatus() != 1 && reqBO.getStatus() != 0) {
                throw new BusinessException(RspConstantEnums.WAREHOUSE_ADDRESS_ADD_FAIL.code(), "\u5165\u53c2\u72b6\u6001\u503c\u9519\u8bef");
            }
        } else {
            if (reqBO.getWarehouseId() == null) {
                throw new BusinessException(RspConstantEnums.WAREHOUSE_ADDRESS_ADD_FAIL.code(), "\u5165\u53c2\u4f01\u914d\u4ed3Id[warehouseId]\u4e3a\u7a7a");
            }
            if (reqBO.getAddressType() == null) {
                throw new BusinessException(RspConstantEnums.WAREHOUSE_ADDRESS_ADD_FAIL.code(), "\u5165\u53c2\u5730\u5740\u7c7b\u578b[warehouseCode]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getProvinceCode())) {
                throw new BusinessException(RspConstantEnums.WAREHOUSE_ADDRESS_ADD_FAIL.code(), "\u5165\u53c2\u4e00\u7ea7\u5730\u5740(\u7701)\u7f16\u7801[provinceCode]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getProvince())) {
                throw new BusinessException(RspConstantEnums.WAREHOUSE_ADDRESS_ADD_FAIL.code(), "\u5165\u53c2\u4e00\u7ea7\u5730\u5740(\u7701)[province]\u4e3a\u7a7a");
            }
            if (reqBO.getAddressType() != 1) {
                if (StringUtils.isEmpty((Object)reqBO.getCityCode())) {
                    throw new BusinessException(RspConstantEnums.WAREHOUSE_ADDRESS_ADD_FAIL.code(), "\u5165\u53c2\u4e8c\u7ea7\u5730\u5740(\u5e02)\u7f16\u7801[cityCode]\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((Object)reqBO.getCity())) {
                    throw new BusinessException(RspConstantEnums.WAREHOUSE_ADDRESS_ADD_FAIL.code(), "\u5165\u53c2\u4e8c\u7ea7\u5730\u5740(\u5e02)[city]\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((Object)reqBO.getCountyCode())) {
                    throw new BusinessException(RspConstantEnums.WAREHOUSE_ADDRESS_ADD_FAIL.code(), "\u5165\u53c2\u4e09\u7ea7\u5730\u5740(\u533a)\u7f16\u7801[countyCode]\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((Object)reqBO.getCounty())) {
                    throw new BusinessException(RspConstantEnums.WAREHOUSE_ADDRESS_ADD_FAIL.code(), "\u5165\u53c2\u4e09\u7ea7\u5730\u5740(\u533a)[county]\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((Object)reqBO.getAddress())) {
                    throw new BusinessException(RspConstantEnums.WAREHOUSE_ADDRESS_ADD_FAIL.code(), "\u5165\u53c2\u8be6\u7ec6\u5730\u5740[address]\u4e3a\u7a7a");
                }
            }
        }
    }
}

