/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccAddBrandRelApproveListAbilityService;
import com.tydic.commodity.common.ability.bo.UccAddBrandRelApproveListAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccAddBrandRelApproveListAbilityRspBo;
import com.tydic.commodity.common.ability.bo.UccBrandRelApproveBo;
import com.tydic.commodity.common.busi.api.UccAddBrandRelApproveListBusiService;
import com.tydic.commodity.dao.UccBrandRelApproveMapper;
import com.tydic.commodity.po.UccBrandRelApprovePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccAddBrandRelApproveListAbilityService"})
public class UccAddBrandRelApproveListAbilityServiceImpl
implements UccAddBrandRelApproveListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAddBrandRelApproveListAbilityServiceImpl.class);
    @Autowired
    private UccBrandRelApproveMapper uccBrandRelApproveMapper;
    @Autowired
    private UccAddBrandRelApproveListBusiService uccAddBrandRelApproveListBusiService;

    @PostMapping(value={"addBrandRelApproveList"})
    public UccAddBrandRelApproveListAbilityRspBo addBrandRelApproveList(@RequestBody UccAddBrandRelApproveListAbilityReqBo reqBo) {
        UccAddBrandRelApproveListAbilityServiceImpl.isCheck(reqBo);
        if (StringUtils.isBlank((CharSequence)reqBo.getName())) {
            reqBo.setName("\u7cfb\u7edf");
        }
        List brandIds = reqBo.getUccBrandRelApproveBos().stream().map(UccBrandRelApproveBo::getBrandId).collect(Collectors.toList());
        List extBrandNames = reqBo.getUccBrandRelApproveBos().stream().map(UccBrandRelApproveBo::getExtBrandName).collect(Collectors.toList());
        UccBrandRelApprovePO qryUccBrandRelApprovePo = new UccBrandRelApprovePO();
        qryUccBrandRelApprovePo.setBrandIds(brandIds);
        qryUccBrandRelApprovePo.setExtBrandNames(extBrandNames);
        ArrayList<Integer> approveStatusList = new ArrayList<Integer>();
        approveStatusList.add(UccConstants.UccBrandRelApproveStatus.TO_BE_CONFIRMED);
        approveStatusList.add(UccConstants.UccBrandRelApproveStatus.CONFIRMED_APPROVED);
        qryUccBrandRelApprovePo.setApproveStatusList(approveStatusList);
        int checkBy = this.uccBrandRelApproveMapper.getCheckBy(qryUccBrandRelApprovePo);
        if (checkBy > 0) {
            throw new BusinessException("8888", "\u60a8\u63d0\u4ea4\u7684\u6570\u636e\u91cc\u9762\u6709\u5b58\u5728\u6d41\u7a0b\u8fd8\u6ca1\u5b8c\u7ed3\u7684\u6570\u636e");
        }
        return this.uccAddBrandRelApproveListBusiService.addBrandRelApproveList(reqBo);
    }

    private static void isCheck(UccAddBrandRelApproveListAbilityReqBo reqBo) {
        if (CollectionUtils.isEmpty((Collection)reqBo.getUccBrandRelApproveBos())) {
            throw new BusinessException("8888", "\u5165\u53c2\u3010uccBrandRelApproveBos\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UccBrandRelApproveBo uccBrandRelApproveBo : reqBo.getUccBrandRelApproveBos()) {
            if (uccBrandRelApproveBo.getBrandId() == null) {
                throw new BusinessException("8888", "\u5165\u53c2\u3010\u54c1\u724cID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (uccBrandRelApproveBo.getExtBrandId() == null) {
                throw new BusinessException("8888", "\u5165\u53c2\u3010\u7b2c\u4e09\u65b9\u54c1\u724cID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)uccBrandRelApproveBo.getExtBrandName())) {
                throw new BusinessException("8888", "\u5165\u53c2\u3010\u7b2c\u4e09\u65b9\u54c1\u724c\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (uccBrandRelApproveBo.getBrandOperType() == null) {
                throw new BusinessException("8888", "\u5165\u53c2\u3010\u64cd\u4f5c\u7c7b\u578b\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!UccConstants.BrandOperType.ADD.equals(uccBrandRelApproveBo.getBrandOperType()) && !UccConstants.BrandOperType.DEL.equals(uccBrandRelApproveBo.getBrandOperType())) {
                throw new BusinessException("8888", "\u5165\u53c2\u3010\u64cd\u4f5c\u7c7b\u578b\u3011\u4f20\u5165\u683c\u5f0f\u4e0d\u5bf9");
            }
            if (uccBrandRelApproveBo.getBrandRelSource() != null) continue;
            throw new BusinessException("8888", "\u5165\u53c2\u3010\u64cd\u4f5c\u6765\u6e90\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

