/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.common.ability.api.UccGovernPriceExpSyncAbilityService;
import com.tydic.commodity.common.ability.bo.UccGovernPriceExpSyncAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccGovernPriceExpSyncAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccGovernPriceExpSyncDetailBO;
import com.tydic.commodity.common.busi.api.UccGovernPriceExpSyncBusiService;
import com.tydic.commodity.dao.UccPushLogMapper;
import com.tydic.commodity.po.UccPushLogPO;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccGovernPriceExpSyncAbilityService"})
public class UccGovernPriceExpSyncAbilityServiceImpl
implements UccGovernPriceExpSyncAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccGovernPriceExpSyncAbilityServiceImpl.class);
    @Autowired
    private UccGovernPriceExpSyncBusiService uccGovernPriceExpSyncBusiService;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Autowired
    private UccPushLogMapper uccPushLogMapper;

    @PostMapping(value={"dealGovernPriceExpSync"})
    public UccGovernPriceExpSyncAbilityRspBO dealGovernPriceExpSync(@RequestBody UccGovernPriceExpSyncAbilityReqBO reqBO) {
        UccGovernPriceExpSyncAbilityRspBO rspBO = new UccGovernPriceExpSyncAbilityRspBO();
        log.info("\u6570\u636e\u6cbb\u7406\u540c\u6b65\u4ef7\u683c\u5f02\u5e38\u5f00\u59cb\uff1a" + JSON.toJSONString((Object)reqBO));
        UccPushLogPO uccPushLogPO = new UccPushLogPO();
        uccPushLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        uccPushLogPO.setCreateTime(new Date());
        uccPushLogPO.setType(Integer.valueOf(110));
        uccPushLogPO.setReqJson(JSON.toJSONString((Object)uccPushLogPO));
        uccPushLogPO.setStatus(Integer.valueOf(1));
        String validateStr = this.validateReq(reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            uccPushLogPO.setStatus(Integer.valueOf(0));
            rspBO.setRespDesc(validateStr);
            this.addLog(uccPushLogPO, rspBO);
            return rspBO;
        }
        rspBO = this.uccGovernPriceExpSyncBusiService.dealGovernPriceExpSync(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            CompletableFuture.runAsync(() -> {
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                List<Long> skuIds = Collections.singletonList(reqBO.getSkuId());
                syncSceneCommodityToEsReqBO.setSkuIds(skuIds);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                try {
                    this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u540c\u6b65es\u6570\u636e\u5931\u8d25");
                }
            });
        } else {
            uccPushLogPO.setStatus(Integer.valueOf(0));
        }
        uccPushLogPO.setRspJson(JSON.toJSONString((Object)rspBO));
        this.addLog(uccPushLogPO, rspBO);
        return rspBO;
    }

    private void addLog(UccPushLogPO uccPushLogPO, UccGovernPriceExpSyncAbilityRspBO rspBO) {
        try {
            uccPushLogPO.setNewType(Integer.valueOf(2));
            this.uccPushLogMapper.insert(uccPushLogPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8bb0\u5f55\u65e5\u5fd7\u4fe1\u606f\u5f02\u5e38" + e.getMessage());
        }
    }

    private String validateReq(UccGovernPriceExpSyncAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getType())) {
            return "\u5165\u53c2 type \u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getHitDetails())) {
            return "\u5165\u53c2 hitDetails \u4e3a\u7a7a";
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSkuId())) {
            return "\u5165\u53c2 skuId \u4e3a\u7a7a";
        }
        for (UccGovernPriceExpSyncDetailBO hitDetail : reqBO.getHitDetails()) {
            if (ObjectUtil.isEmpty((Object)hitDetail.getOriginPriceType())) {
                return "\u5165\u53c2 hitDetails originPriceType \u4e3a\u7a7a";
            }
            if (!ObjectUtil.isEmpty((Object)hitDetail.getFloatingValue())) continue;
            return "\u5165\u53c2 hitDetails floatingValue \u4e3a\u7a7a";
        }
        return null;
    }
}

