/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.Brand;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.common.ability.api.UccSimilerBrandMatchDetailListAbilityService;
import com.tydic.commodity.common.ability.bo.UccBrandRelCatalogLevelBO;
import com.tydic.commodity.common.ability.bo.UccSimilerBrandMatchDetailListAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSimilerBrandMatchDetailListAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSimilerBrandMatchDetailListBO;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccBrandExtMapper;
import com.tydic.commodity.dao.UccBrandRelApproveMapper;
import com.tydic.commodity.dao.UccSimilerBrandRelMapper;
import com.tydic.commodity.po.UccBrandRelApprovePO;
import com.tydic.commodity.po.UccBrandRelCatalogLevelPo;
import com.tydic.commodity.po.UccSimilerBrandRelPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSimilerBrandMatchDetailListAbilityService"})
public class UccSimilerBrandMatchDetailListAbilityServiceImpl
implements UccSimilerBrandMatchDetailListAbilityService {
    @Autowired
    private UccSimilerBrandRelMapper uccSimilerBrandRelMapper;
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccBrandRelApproveMapper uccBrandRelApproveMapper;
    @Autowired
    private UccBrandExtMapper uccBrandExtMapper;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;

    @PostMapping(value={"getSimilerBrandMatchDetailList"})
    public UccSimilerBrandMatchDetailListAbilityRspBO getSimilerBrandMatchDetailList(@RequestBody UccSimilerBrandMatchDetailListAbilityReqBO reqBO) {
        UccSimilerBrandMatchDetailListAbilityRspBO rspBO = new UccSimilerBrandMatchDetailListAbilityRspBO();
        rspBO.setRespCode("0000");
        this.validateReq(reqBO);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccSimilerBrandRelPO brandRelPO = (UccSimilerBrandRelPO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), UccSimilerBrandRelPO.class);
        brandRelPO.setBrandCode(reqBO.getMallBrandCode());
        brandRelPO.setVendorName(reqBO.getVendorName());
        List similerBrandRelPOList = this.uccSimilerBrandRelMapper.getListPageJoin(brandRelPO, page);
        Map map = this.uccDictionaryAtomService.queryBypCodeBackMap(Brand.UCC_RELATION_DIC.toString());
        if (!CollectionUtils.isEmpty((Collection)similerBrandRelPOList)) {
            List detailListBOS = similerBrandRelPOList.stream().map(e -> {
                UccSimilerBrandMatchDetailListBO detailListBO = (UccSimilerBrandMatchDetailListBO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccSimilerBrandMatchDetailListBO.class);
                detailListBO.setExtBrandBelongOrg(e.getVendorName());
                if (MapUtil.isNotEmpty((Map)map) && detailListBO.getRelation() != null) {
                    detailListBO.setRelationStr((String)map.get(detailListBO.getRelation().toString()));
                }
                return detailListBO;
            }).collect(Collectors.toList());
            List mallBrandIds = similerBrandRelPOList.stream().map(UccSimilerBrandRelPO::getMallBrandId).collect(Collectors.toList());
            List uccBrandRelCatalogLevelPos = this.uccBrandDealMapper.queryCatalogTreeList(mallBrandIds);
            if (!CollectionUtils.isEmpty((Collection)uccBrandRelCatalogLevelPos)) {
                Map<Long, List<UccBrandRelCatalogLevelPo>> brandCatalogMap = uccBrandRelCatalogLevelPos.stream().collect(Collectors.groupingBy(UccBrandRelCatalogLevelPo::getBrandId));
                for (UccSimilerBrandMatchDetailListBO each : detailListBOS) {
                    if (!brandCatalogMap.containsKey(each.getMallBrandId())) continue;
                    List uccBrandRelCatalogLevelBOS = JSON.parseArray((String)JSON.toJSONString(brandCatalogMap.get(each.getMallBrandId())), UccBrandRelCatalogLevelBO.class);
                    each.setCatalogLevelBOS(uccBrandRelCatalogLevelBOS);
                }
            }
            List extBrandIds = similerBrandRelPOList.stream().map(UccSimilerBrandRelPO::getExtBrandId).collect(Collectors.toList());
            UccBrandRelApprovePO qryUccBrandRelApprovePo = new UccBrandRelApprovePO();
            qryUccBrandRelApprovePo.setExtBrandIds(extBrandIds);
            qryUccBrandRelApprovePo.setBrandId(((UccSimilerBrandRelPO)similerBrandRelPOList.get(0)).getMallBrandId());
            qryUccBrandRelApprovePo.setBrandOperType(UccConstants.BrandOperType.ADD);
            ArrayList<Integer> approveStatusList = new ArrayList<Integer>(2);
            approveStatusList.add(UccConstants.UccBrandRelApproveStatus.TO_BE_CONFIRMED);
            approveStatusList.add(UccConstants.UccBrandRelApproveStatus.CONFIRMED_APPROVED);
            qryUccBrandRelApprovePo.setApproveStatusList(approveStatusList);
            List uccBrandRelApprovePos = this.uccBrandRelApproveMapper.getList(qryUccBrandRelApprovePo);
            Map<Object, Object> UccBrandRelApproveMap = new HashMap(16);
            if (!CollectionUtils.isEmpty((Collection)uccBrandRelApprovePos)) {
                UccBrandRelApproveMap = uccBrandRelApprovePos.stream().collect(Collectors.groupingBy(UccBrandRelApprovePO::getExtBrandId));
            }
            for (UccSimilerBrandMatchDetailListBO detailListBO : detailListBOS) {
                detailListBO.setIsConfirmBtn(Boolean.valueOf(true));
                if (detailListBO.getRelId() != null) {
                    detailListBO.setIsConfirmBtn(Boolean.valueOf(false));
                    continue;
                }
                if (!MapUtil.isNotEmpty(UccBrandRelApproveMap) || CollectionUtils.isEmpty((Collection)((Collection)UccBrandRelApproveMap.get(detailListBO.getExtBrandId())))) continue;
                detailListBO.setIsConfirmBtn(Boolean.valueOf(false));
            }
            rspBO.setRows(detailListBOS);
            rspBO.setTotal(page.getTotalCount());
            rspBO.setRecordsTotal(page.getTotalCount());
        }
        return rspBO;
    }

    private void validateReq(UccSimilerBrandMatchDetailListAbilityReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getExtBrandId())) {
            throw new BusinessException("8888", "\u5165\u53c2 extBrandId \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Autowired
    public void setUccDictionaryAtomService(UccBaseDictionaryAtomService uccDictionaryAtomService) {
        this.uccDictionaryAtomService = uccDictionaryAtomService;
    }
}

