/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.common.ability.api.UccWarehouseSupplierAbilityService;
import com.tydic.commodity.common.ability.bo.UccWarehouseSupplierAddAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccWarehouseSupplierAddAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccWarehouseSupplierBO;
import com.tydic.commodity.common.ability.bo.UccWarehouseSupplierPageListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccWarehouseSupplierPageListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccWarehouseSupplierUpdateAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccWarehouseSupplierUpdateAbilityRspBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.api.UccWarehouseSupplierBusiService;
import com.tydic.commodity.common.busi.bo.UccWarehouseSupplierAddBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccWarehouseSupplierAddBusiRspBO;
import com.tydic.commodity.common.busi.bo.UccWarehouseSupplierUpdateBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccWarehouseSupplierUpdateBusiRspBO;
import com.tydic.commodity.dao.UccWarehouseSupplierMapper;
import com.tydic.commodity.po.UccWarehouseSupplierPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccWarehouseSupplierAbilityService"})
public class UccWarehouseSupplierAbilityServiceImpl
implements UccWarehouseSupplierAbilityService {
    @Autowired
    private UccWarehouseSupplierMapper uccWarehouseSupplierMapper;
    @Autowired
    private UccWarehouseSupplierBusiService uccWarehouseSupplierBusiService;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    @PostMapping(value={"addWarehouseSupplier"})
    public UccWarehouseSupplierAddAbilityRspBO addWarehouseSupplier(@RequestBody UccWarehouseSupplierAddAbilityReqBO reqBO) {
        UccWarehouseSupplierAddAbilityRspBO rspBO = new UccWarehouseSupplierAddAbilityRspBO();
        rspBO.setRespCode("0001");
        if (reqBO.getWarehouseId() == null) {
            rspBO.setRespDesc("\u5165\u53c2[warehouseId]\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        ArrayList<Long> supplierIds = new ArrayList<Long>();
        for (UccWarehouseSupplierBO supplierBO : reqBO.getSupplierList()) {
            if (supplierBO.getSupplierCode() == null) {
                rspBO.setRespDesc("\u5165\u53c2[supplierCode]\u4e0d\u80fd\u4e3a\u7a7a!");
                return rspBO;
            }
            if (supplierBO.getSupplierId() == null) {
                rspBO.setRespDesc("\u5165\u53c2[supplierId]\u4e0d\u80fd\u4e3a\u7a7a!");
                return rspBO;
            }
            if (supplierBO.getSupplierName() == null) {
                rspBO.setRespDesc("\u5165\u53c2[supplierName]\u4e0d\u80fd\u4e3a\u7a7a!");
                return rspBO;
            }
            supplierIds.add(supplierBO.getSupplierId());
        }
        String reqString = JSONObject.toJSONString((Object)reqBO);
        UccWarehouseSupplierAddBusiReqBO busiReqBO = (UccWarehouseSupplierAddBusiReqBO)((Object)JSONObject.parseObject((String)reqString, UccWarehouseSupplierAddBusiReqBO.class));
        UccWarehouseSupplierAddBusiRspBO busiRspBO = this.uccWarehouseSupplierBusiService.addWarehouseSupplier(busiReqBO);
        return (UccWarehouseSupplierAddAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), UccWarehouseSupplierAddAbilityRspBO.class);
    }

    @PostMapping(value={"qryWarehouseSupplierList"})
    public UccWarehouseSupplierPageListQryAbilityRspBO qryWarehouseSupplierList(@RequestBody UccWarehouseSupplierPageListQryAbilityReqBO reqBO) {
        UccWarehouseSupplierPageListQryAbilityRspBO rspBO = new UccWarehouseSupplierPageListQryAbilityRspBO();
        if (reqBO.getWarehouseId() == null) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2[warehouseId]\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        UccWarehouseSupplierPO supplierPO = new UccWarehouseSupplierPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)supplierPO);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List list = this.uccWarehouseSupplierMapper.getListPage(supplierPO, page);
        rspBO.setPageNo(reqBO.getPageNo());
        if (CollectionUtils.isEmpty((Collection)list)) {
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        ArrayList<UccWarehouseSupplierBO> rows = new ArrayList<UccWarehouseSupplierBO>(list.size());
        Map<String, String> statusMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_WAREHOUSE_STATUS");
        for (UccWarehouseSupplierPO uccWarehouseSupplierPO : list) {
            UccWarehouseSupplierBO supplierBO = new UccWarehouseSupplierBO();
            BeanUtils.copyProperties((Object)uccWarehouseSupplierPO, (Object)supplierBO);
            supplierBO.setStatusStr(statusMap.get(supplierBO.getStatus() + ""));
            rows.add(supplierBO);
        }
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }

    @PostMapping(value={"updateWarehouseSupplier"})
    public UccWarehouseSupplierUpdateAbilityRspBO updateWarehouseSupplier(@RequestBody UccWarehouseSupplierUpdateAbilityReqBO reqBO) {
        UccWarehouseSupplierUpdateAbilityRspBO rspBO = new UccWarehouseSupplierUpdateAbilityRspBO();
        rspBO.setRespCode("0001");
        if (reqBO.getId() == null) {
            rspBO.setRespDesc("\u5165\u53c2[id]\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        if (reqBO.getWarehouseId() == null) {
            rspBO.setRespDesc("\u5165\u53c2[warehouseId]\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        String reqString = JSONObject.toJSONString((Object)reqBO);
        UccWarehouseSupplierUpdateBusiReqBO busiReqBO = (UccWarehouseSupplierUpdateBusiReqBO)((Object)JSONObject.parseObject((String)reqString, UccWarehouseSupplierUpdateBusiReqBO.class));
        UccWarehouseSupplierUpdateBusiRspBO busiRspBO = this.uccWarehouseSupplierBusiService.updateWarehouseSupplier(busiReqBO);
        return (UccWarehouseSupplierUpdateAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), UccWarehouseSupplierUpdateAbilityRspBO.class);
    }
}

