/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.tydic.commodity.common.ability.bo.UccChannelListQryBO;
import com.tydic.commodity.common.ability.bo.UccChannelListQryReqBO;
import com.tydic.commodity.common.ability.bo.UccChannelListQryRspBO;
import com.tydic.commodity.common.busi.api.UccChannelListQryBusiService;
import com.tydic.commodity.dao.UccChannelAppTypeMapper;
import com.tydic.commodity.dao.UccChannelMapper;
import com.tydic.commodity.po.UccChannelAppTypePO;
import com.tydic.commodity.po.UccChannelPO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccChannelListQryBusiServiceImpl
implements UccChannelListQryBusiService {
    @Autowired
    private UccChannelMapper uccChannelMapper;
    @Autowired
    private UccChannelAppTypeMapper uccChannelAppTypeMapper;

    @Override
    public UccChannelListQryRspBO queryChannelList(UccChannelListQryReqBO reqBO) {
        UccChannelListQryRspBO rspBO = new UccChannelListQryRspBO();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        simpleDateFormat.setLenient(false);
        try {
            if (!StringUtils.isEmpty((Object)reqBO.getCreateTimeBegin())) {
                simpleDateFormat.parse(reqBO.getCreateTimeBegin());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getCreateTimeEnd())) {
                simpleDateFormat.parse(reqBO.getCreateTimeEnd());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getUpdateTimeBegin())) {
                simpleDateFormat.parse(reqBO.getUpdateTimeBegin());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getUpdateTimeEnd())) {
                simpleDateFormat.parse(reqBO.getUpdateTimeEnd());
            }
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u4f20\u5165\u65e5\u671f\u683c\u5f0f\u51fa\u9519:" + e.getMessage());
            return rspBO;
        }
        UccChannelPO queryConditionPO = new UccChannelPO();
        queryConditionPO.setChannelId(reqBO.getChannelId());
        queryConditionPO.setChannelCode(reqBO.getChannelCode());
        queryConditionPO.setChannelName(reqBO.getChannelName());
        queryConditionPO.setCreateOperId(reqBO.getCreateOperId());
        queryConditionPO.setUpdateOperId(reqBO.getUpdateOperId());
        List<UccChannelPO> uccChannelPOS = new ArrayList();
        Integer recordsTotal = 0;
        try {
            recordsTotal = this.uccChannelMapper.queryCountByCondition(queryConditionPO, reqBO.getCreateTimeBegin(), reqBO.getCreateTimeEnd(), reqBO.getUpdateTimeBegin(), reqBO.getUpdateTimeEnd());
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2\u6e20\u9053\u6570\u91cf\u51fa\u9519:" + e.getMessage());
            return rspBO;
        }
        int pageSize = reqBO.getPageSize();
        int pageNo = reqBO.getPageNo();
        Integer total = recordsTotal % pageSize == 0 ? recordsTotal / pageSize : recordsTotal / pageSize + 1;
        Integer start = pageSize * (pageNo - 1);
        try {
            uccChannelPOS = this.uccChannelMapper.queryByCondition(queryConditionPO, reqBO.getCreateTimeBegin(), reqBO.getCreateTimeEnd(), reqBO.getUpdateTimeBegin(), reqBO.getUpdateTimeEnd(), start, Integer.valueOf(pageSize));
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2\u6e20\u9053\u4fe1\u606f\u51fa\u9519:" + e.getMessage());
            return rspBO;
        }
        List channelIds = uccChannelPOS.stream().map(UccChannelPO::getChannelId).collect(Collectors.toList());
        ArrayList<UccChannelAppTypePO> uccChannelAppTypePOS = new ArrayList();
        try {
            uccChannelAppTypePOS = this.uccChannelAppTypeMapper.batchQryByChannelIds(channelIds);
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2\u6e20\u9053\u5e94\u7528\u4fe1\u606f\u51fa\u9519:" + e.getMessage());
            return rspBO;
        }
        List<UccChannelListQryBO> rows = this.createDataList(uccChannelPOS, uccChannelAppTypePOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRows(rows);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(total.intValue());
        rspBO.setRecordsTotal(recordsTotal.intValue());
        return rspBO;
    }

    public List<UccChannelListQryBO> createDataList(List<UccChannelPO> uccChannelPOS, List<UccChannelAppTypePO> uccChannelAppTypePOS) {
        ArrayList<UccChannelListQryBO> rows = new ArrayList<UccChannelListQryBO>();
        Integer viewOrderPre = 0;
        for (UccChannelPO uccChannelPO : uccChannelPOS) {
            UccChannelListQryBO uccChannelListQryBO = new UccChannelListQryBO();
            uccChannelListQryBO.setChannelId(uccChannelPO.getChannelId());
            uccChannelListQryBO.setChannelCode(uccChannelPO.getChannelCode());
            uccChannelListQryBO.setChannelName(uccChannelPO.getChannelName());
            uccChannelListQryBO.setChannelStatus(uccChannelPO.getChannelStatus());
            if (uccChannelPO.getChannelStatus() != null) {
                uccChannelListQryBO.setChannelStatusText(uccChannelPO.getChannelStatus() == 1 ? "\u542f\u7528" : "\u505c\u7528");
            }
            uccChannelListQryBO.setCreateOperId(uccChannelPO.getCreateOperId());
            uccChannelListQryBO.setCreateTime(uccChannelPO.getCreateTime());
            uccChannelListQryBO.setUpdateOperId(uccChannelPO.getUpdateOperId());
            uccChannelListQryBO.setUpdateTime(uccChannelPO.getUpdateTime());
            uccChannelListQryBO.setRemark(uccChannelPO.getRemark());
            uccChannelListQryBO.setType(uccChannelPO.getType());
            uccChannelListQryBO.setViewOrder(uccChannelPO.getViewOrder());
            if (uccChannelPO.getType() != null) {
                uccChannelListQryBO.setTypeText(uccChannelPO.getType() == 1 ? "\u798f\u5229\u6d3b\u52a8" : "\u5bf9\u516c\u4e1a\u52a1");
            }
            uccChannelListQryBO.setRelatedType(uccChannelPO.getRelatedType());
            if (uccChannelPO.getRelatedType() != null) {
                uccChannelListQryBO.setRelatedTypeText(uccChannelPO.getRelatedType() == 1 ? "\u5546\u54c1\u6c60" : "\u5546\u54c1\u7c7b\u76ee");
            }
            ArrayList<Integer> appTypes = new ArrayList<Integer>();
            ArrayList<String> appTypesText = new ArrayList<String>();
            for (UccChannelAppTypePO uccChannelAppTypePO : uccChannelAppTypePOS) {
                if (uccChannelAppTypePO.getChannelId().compareTo(uccChannelPO.getChannelId()) != 0) continue;
                appTypes.add(uccChannelAppTypePO.getAppTypes());
                appTypesText.add(uccChannelAppTypePO.getAppTypes() == 1 ? "WEB\u7aef" : "APP\u7aef");
            }
            uccChannelListQryBO.setSceneIds(appTypes);
            uccChannelListQryBO.setSceneNames(appTypesText);
            rows.add(uccChannelListQryBO);
        }
        return rows;
    }
}

