/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.UccDealPoolSyncESAtomReqBo;
import com.tydic.commodity.common.ability.api.SearchCommodityManageAbilityService;
import com.tydic.commodity.common.ability.api.UccSkuPoolUpdateAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuPoolUpdateAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccSkuPoolUpdateAbilityRspBo;
import com.tydic.commodity.common.busi.api.UccSkuPoolUpdateBusiService;
import com.tydic.commodity.dao.UccCommodityPoolMapper;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.po.UccCommodityPoolPO;
import com.tydic.commodity.po.UccRelPoolCommodityPo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.utils.ValidatorUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuPoolUpdateAbilityService"})
public class UccSkuPoolUpdateAbilityServiceImpl
implements UccSkuPoolUpdateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuPoolUpdateAbilityServiceImpl.class);
    @Autowired
    private UccCommodityPoolMapper uccCommodityPoolMapper;
    @Autowired
    private SearchCommodityManageAbilityService searchCommodityManageAbilityService;
    @Autowired
    private UccSkuPoolUpdateBusiService uccSkuPoolUpdateBusiService;
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    @Resource(name="uccDealPoolSyncToESProvider")
    private ProxyMessageProducer uccDealPoolSyncToESProvider;

    @PostMapping(value={"dealSkuPool"})
    public UccSkuPoolUpdateAbilityRspBo dealSkuPool(@RequestBody UccSkuPoolUpdateAbilityReqBo reqBo) {
        UccSkuPoolUpdateAbilityRspBo rspBo = new UccSkuPoolUpdateAbilityRspBo();
        try {
            ValidatorUtil.validator((Object)reqBo);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(e.getMessage());
            return rspBo;
        }
        UccCommodityPoolPO uccCommodityPoolPO = this.uccCommodityPoolMapper.selectByPrimaryKey(reqBo.getPoolId());
        if (uccCommodityPoolPO == null) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8f93\u5165\u7684\u5546\u54c1\u6c60ID\u4e0d\u6b63\u786e");
            return rspBo;
        }
        if (reqBo.getRelType() != null && uccCommodityPoolPO.getPoolRelated().compareTo(reqBo.getRelType()) == 0) {
            reqBo.setRelType(null);
        }
        Map<Object, Object> gbRelated = new HashMap();
        if (reqBo.getRelType() != null) {
            UccRelPoolCommodityPo cnncRelPoolCommodityPo = new UccRelPoolCommodityPo();
            cnncRelPoolCommodityPo.setPoolId(reqBo.getPoolId());
            List poolCommodityPos = this.uccRelPoolCommodityMapper.queryAll(cnncRelPoolCommodityPo);
            if (!CollectionUtils.isEmpty((Collection)poolCommodityPos)) {
                gbRelated = poolCommodityPos.stream().collect(Collectors.groupingBy(UccRelPoolCommodityPo::getPoolRelated));
            }
        }
        try {
            rspBo = this.uccSkuPoolUpdateBusiService.dealSkuPool(reqBo);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u4fee\u6539\u5546\u54c1\u6c60\u5931\u8d25\uff01");
        }
        if (!"0000".equals(rspBo.getRespCode())) {
            throw new ZTBusinessException("\u4fee\u6539\u5546\u54c1\u6c60\u5931\u8d25\uff01");
        }
        if (!gbRelated.isEmpty()) {
            for (Integer related : gbRelated.keySet()) {
                List sourceListt = ((List)gbRelated.get(related)).stream().map(UccRelPoolCommodityPo::getSource).collect(Collectors.toList());
                UccDealPoolSyncESAtomReqBo uccDealPoolSyncESAtomReqBo = new UccDealPoolSyncESAtomReqBo();
                switch (related) {
                    case 1: {
                        uccDealPoolSyncESAtomReqBo.setSyncType(Integer.valueOf(2));
                        uccDealPoolSyncESAtomReqBo.setTypeIds(sourceListt);
                        break;
                    }
                    case 2: {
                        uccDealPoolSyncESAtomReqBo.setSyncType(Integer.valueOf(3));
                        uccDealPoolSyncESAtomReqBo.setAgrIds(sourceListt);
                        break;
                    }
                    case 3: {
                        uccDealPoolSyncESAtomReqBo.setSyncType(Integer.valueOf(1));
                        uccDealPoolSyncESAtomReqBo.setVendorIds(sourceListt);
                        break;
                    }
                    case 4: {
                        uccDealPoolSyncESAtomReqBo.setSyncType(Integer.valueOf(0));
                        uccDealPoolSyncESAtomReqBo.setSkuIds(sourceListt);
                        break;
                    }
                    case 5: {
                        uccDealPoolSyncESAtomReqBo.setSyncType(Integer.valueOf(6));
                        uccDealPoolSyncESAtomReqBo.setSpuIds(sourceListt);
                    }
                }
                try {
                    log.info("\u5546\u54c1\u6c60 \u540c\u6b65es\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uccDealPoolSyncESAtomReqBo));
                    this.uccDealPoolSyncToESProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"UCC_SYNC_POOL_ES_TOPIC"), PropertiesUtil.getProperty((String)"UCC_SYNC_POOL_ES_TAG"), JSON.toJSONString((Object)uccDealPoolSyncESAtomReqBo)));
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

