/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccWarehouseSupplierBO;
import com.tydic.commodity.common.busi.api.UccWarehouseSupplierBusiService;
import com.tydic.commodity.common.busi.bo.UccWarehouseSupplierAddBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccWarehouseSupplierAddBusiRspBO;
import com.tydic.commodity.common.busi.bo.UccWarehouseSupplierUpdateBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccWarehouseSupplierUpdateBusiRspBO;
import com.tydic.commodity.dao.UccWarehouseSupplierMapper;
import com.tydic.commodity.po.UccWarehouseSupplierPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccWarehouseSupplierBusiServiceImpl
implements UccWarehouseSupplierBusiService {
    @Autowired
    private UccWarehouseSupplierMapper uccWarehouseSupplierMapper;

    @Override
    public UccWarehouseSupplierAddBusiRspBO addWarehouseSupplier(UccWarehouseSupplierAddBusiReqBO reqBO) {
        UccWarehouseSupplierAddBusiRspBO rspBO = new UccWarehouseSupplierAddBusiRspBO();
        UccWarehouseSupplierPO supplierPO = new UccWarehouseSupplierPO();
        supplierPO.setSupplierIds(reqBO.getSupplierIds());
        supplierPO.setWarehouseId(reqBO.getWarehouseId());
        List list = this.uccWarehouseSupplierMapper.getList(supplierPO);
        Map<Long, Long> supplierMap = list.stream().collect(Collectors.toMap(UccWarehouseSupplierPO::getSupplierId, UccWarehouseSupplierPO::getId));
        ArrayList<UccWarehouseSupplierPO> addList = new ArrayList<UccWarehouseSupplierPO>();
        ArrayList<UccWarehouseSupplierPO> updList = new ArrayList<UccWarehouseSupplierPO>();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)supplierPO);
        for (UccWarehouseSupplierBO supplierBO : reqBO.getSupplierList()) {
            UccWarehouseSupplierPO supplier = new UccWarehouseSupplierPO();
            BeanUtils.copyProperties((Object)supplierBO, (Object)supplier);
            supplier.setUpdateTime(new Date());
            supplier.setUpdateUserId(reqBO.getUserId());
            supplier.setUpdateUserName(reqBO.getName());
            supplier.setUpdateUserAccount(reqBO.getUsername());
            supplier.setStatus(UccConstants.WarehouseState.VALID);
            if (!CollectionUtils.isEmpty(supplierMap) && supplierMap.get(supplier.getSupplierId()) != null) {
                supplier.setId(supplierMap.get(supplier.getSupplierId()));
                updList.add(supplier);
                continue;
            }
            supplier.setCreateTime(new Date());
            supplier.setCreateUserId(reqBO.getUserId());
            supplier.setCreateUserAccount(reqBO.getUsername());
            supplier.setCreateUserName(reqBO.getName());
            supplier.setWarehouseId(reqBO.getWarehouseId());
            supplier.setId(Long.valueOf(Sequence.getInstance().nextId()));
            addList.add(supplier);
        }
        if (!CollectionUtils.isEmpty(addList)) {
            this.uccWarehouseSupplierMapper.insertBatch(addList);
        }
        if (!CollectionUtils.isEmpty(updList)) {
            for (UccWarehouseSupplierPO uccWarehouseSupplierPO : updList) {
                this.uccWarehouseSupplierMapper.updateById(uccWarehouseSupplierPO);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public UccWarehouseSupplierUpdateBusiRspBO updateWarehouseSupplier(UccWarehouseSupplierUpdateBusiReqBO reqBO) {
        UccWarehouseSupplierPO supplierPO = new UccWarehouseSupplierPO();
        supplierPO.setId(reqBO.getId());
        supplierPO = this.uccWarehouseSupplierMapper.getModelBy(supplierPO);
        if (supplierPO == null) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5f53\u524d\u4f01\u914d\u4ed3\u4f9b\u5e94\u5546\u670d\u52a1\u8303\u56f4\u4fe1\u606f,\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38!");
        }
        supplierPO.setUpdateTime(new Date());
        supplierPO.setUpdateUserAccount(reqBO.getUsername());
        supplierPO.setUpdateUserName(reqBO.getName());
        supplierPO.setUpdateUserId(reqBO.getUserId());
        supplierPO.setSupplierId(reqBO.getSupplierId());
        supplierPO.setSupplierCode(reqBO.getSupplierCode());
        supplierPO.setSupplierName(reqBO.getSupplierName());
        supplierPO.setStatus(reqBO.getStatus());
        int count = this.uccWarehouseSupplierMapper.updateById(supplierPO);
        if (count < 0) {
            throw new BusinessException("8888", "\u66f4\u65b0\u4f01\u914d\u4ed3\u4f9b\u5e94\u5546\u670d\u52a1\u8303\u56f4\u5931\u8d25!");
        }
        UccWarehouseSupplierUpdateBusiRspBO rspBO = new UccWarehouseSupplierUpdateBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

