/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.enumType.SkuOnShelveWayEnum;
import com.tydic.commodity.base.enumType.SkuSourceEnum;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.common.ability.api.UccConfigurationparametersDetailAbilityService;
import com.tydic.commodity.common.ability.api.UccMarketAutoShelfAbilityService;
import com.tydic.commodity.common.ability.api.UccSkuOperationLogRecordAbilityService;
import com.tydic.commodity.common.ability.bo.UccConfigurationparametersDetailAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccConfigurationparametersDetailAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccConfigurationparametersQryBO;
import com.tydic.commodity.common.ability.bo.UccMarketAutoShelfAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccMarketAutoShelfAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityBO;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityReqBO;
import com.tydic.commodity.config.UccThreadPoolExecutorConfig;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccMallBrandRelMapper;
import com.tydic.commodity.dao.UccRelCatalogBrandVendorMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuStandardPriceMapper;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccMallBrandRelPO;
import com.tydic.commodity.po.UccRelCatalogBrandVendorPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UccSkuStandardPricePO;
import com.tydic.commodity.utils.CommonUtils;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccMarketAutoShelfAbilityService"})
public class UccMarketAutoShelfAbilityServiceImpl
implements UccMarketAutoShelfAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMarketAutoShelfAbilityServiceImpl.class);
    private static final int PAGE_SIZE = 200;
    private static final Long CONFIG_PARAM_ID = 7L;
    private static final String CONFIG_PARAM_CODE = "SHELF_CHECK";
    private static final Integer ENABLE = 1;
    private static final Integer UN_ENABLE = 0;
    private static final ThreadPoolExecutor threadPoolExecutor = UccThreadPoolExecutorConfig.poolExecutor;
    private static final String UCC_SHELF_CHECK = "uccShelfCheck";
    private static final String UCC_BRAND_VERIFY = "uccBrandVerify";
    private static final String UCC_IS_EXCEED_PRICE_THRESHOLD_VALUE = "uccIsExceedPriceThresholdValue";
    private static final String UCC_IS_EXCEED_STANDARD_PRICE = "uccIsExceedStandardPrice";
    private static final String UCC_IS_EXCEED_MAXIMUM_DISCOUNT_RATE_LIMIT = "uccISExceedMaximumDiscountRateLimit";
    @Autowired
    private UccConfigurationparametersDetailAbilityService uccConfigurationparametersDetailAbilityService;
    @Resource
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccRelCatalogBrandVendorMapper uccRelCatalogBrandVendorMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccMallBrandRelMapper uccMallBrandRelMapper;
    @Resource
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Resource
    private UccSkuStandardPriceMapper uccSkuStandardPriceMapper;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccSkuOperationLogRecordAbilityService uccSkuOperationLogRecordAbilityService;

    @PostMapping(value={"autoShelf"})
    public UccMarketAutoShelfAbilityRspBO autoShelf(@RequestBody UccMarketAutoShelfAbilityReqBO reqBO) {
        log.error("---------------\u8d85\u5e02\u5546\u54c1\u81ea\u52a8\u4e0a\u67b6\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb---------------");
        UccMarketAutoShelfAbilityRspBO rspBO = new UccMarketAutoShelfAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        try {
            int count;
            UccConfigurationparametersDetailAbilityReqBO configReqBO = new UccConfigurationparametersDetailAbilityReqBO();
            configReqBO.setParamsId(CONFIG_PARAM_ID);
            configReqBO.setParamsCode(CONFIG_PARAM_CODE);
            UccConfigurationparametersDetailAbilityRspBO configRspBO = this.uccConfigurationparametersDetailAbilityService.getparametersDetail(configReqBO);
            if (Objects.isNull(configRspBO) || !"0000".equals(configRspBO.getRespCode())) {
                log.error("\u67e5\u8be2\u5546\u54c1\u81ea\u52a8\u4e0a\u67b6\u89c4\u5219\u6821\u9a8c\u8bbe\u7f6e\u5f02\u5e38!" + (Objects.isNull(configRspBO) ? "" : configRspBO.getRespDesc()));
                throw new ZTBusinessException("\u67e5\u8be2\u5546\u54c1\u81ea\u52a8\u4e0a\u67b6\u89c4\u5219\u6821\u9a8c\u8bbe\u7f6e\u5f02\u5e38!");
            }
            if (CollectionUtils.isEmpty((Collection)configRspBO.getRows())) {
                log.error("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u81ea\u52a8\u4e0a\u67b6\u89c4\u5219\u6821\u9a8c!");
                throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u81ea\u52a8\u4e0a\u67b6\u89c4\u5219\u6821\u9a8c!");
            }
            Map<String, UccConfigurationparametersQryBO> configMap = configRspBO.getRows().stream().collect(Collectors.toMap(UccConfigurationparametersQryBO::getRule, Function.identity(), (k1, k2) -> k1));
            if (!CollectionUtils.isEmpty(configMap) && UN_ENABLE.equals(((UccConfigurationparametersQryBO)configMap.get(UCC_SHELF_CHECK)).getEnable())) {
                log.error("\u5546\u54c1\u81ea\u52a8\u4e0a\u67b6\u89c4\u5219\u6821\u9a8c\u8bbe\u7f6e\u672a\u5f00\u542f");
                throw new ZTBusinessException("\u5546\u54c1\u81ea\u52a8\u4e0a\u67b6\u89c4\u5219\u6821\u9a8c\u8bbe\u7f6e\u672a\u5f00\u542f!");
            }
            UccSkuPo uccSkuPo = new UccSkuPo();
            List<Integer> skuStatusList = Arrays.asList(SkuStatusEnum.PENDING_SHELF_STATUS.getStatus(), SkuStatusEnum.MAPPING_BRAND.getStatus());
            uccSkuPo.setSkuStatusList(skuStatusList);
            uccSkuPo.setSkuSource(SkuSourceEnum.ELECTRONIC_SUPERMARKET_SOURCE.getSource());
            if (ENABLE.equals(((UccConfigurationparametersQryBO)configMap.get(UCC_IS_EXCEED_PRICE_THRESHOLD_VALUE)).getEnable())) {
                uccSkuPo.setSurpassVpt(UN_ENABLE);
            }
            if (ENABLE.equals(((UccConfigurationparametersQryBO)configMap.get(UCC_IS_EXCEED_MAXIMUM_DISCOUNT_RATE_LIMIT)).getEnable())) {
                uccSkuPo.setDiscountLimitValue(UN_ENABLE);
            }
            if ((count = this.uccSkuMapper.queryCount(uccSkuPo)) == 0) {
                log.error("\u4e0d\u5b58\u5728\u7b26\u5408\u81ea\u52a8\u4e0a\u67b6\u7684\u6570\u636e\uff01");
                return rspBO;
            }
            int pageCount = count % 200 == 0 ? count / 200 : count / 200 + 1;
            for (int i = 1; i <= pageCount; ++i) {
                log.error("------- \u81ea\u52a8\u4e0a\u67b6\u4efb\u52a1\u8fdb\u5165\u7b2c{}\u6b21\u5faa\u73af\uff0c\u5171{}\u6b21\u5faa\u73af\uff1a", (Object)(i + 1), (Object)pageCount);
                Page page = new Page();
                page.setPageNo(i);
                page.setPageSize(200);
                List skuPoList = this.uccSkuMapper.queryMarketSkuByPage(uccSkuPo, page);
                this.dealData(skuPoList, configMap);
            }
        }
        catch (Exception ex) {
            log.error("\u8d85\u5e02\u5546\u54c1\u81ea\u52a8\u4e0a\u67b6\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38\uff1a" + CommonUtils.dealStackTrace((Exception)ex));
        }
        log.error("---------------\u8d85\u5e02\u5546\u54c1\u81ea\u52a8\u4e0a\u67b6\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f---------------");
        return rspBO;
    }

    private void dealData(List<UccSkuPo> skuPoList, Map<String, UccConfigurationparametersQryBO> configMap) {
        Runnable runnable = () -> {
            if (CollectionUtils.isEmpty((Collection)skuPoList)) {
                return;
            }
            log.error("{} \u7ebf\u7a0b\u5f00\u59cb\u540c\u6b65\u6570\u636e...\uff1b\u5f53\u524d\u7ebf\u7a0b\u5904\u7406\u6570\u636e\u6761\u6570{}", (Object)Thread.currentThread().getName(), (Object)skuPoList.size());
            Set<Long> brandVerifySet = ENABLE.equals(((UccConfigurationparametersQryBO)configMap.get(UCC_BRAND_VERIFY)).getEnable()) ? this.checkMallBrand(skuPoList) : new HashSet<Long>();
            if (ENABLE.equals(((UccConfigurationparametersQryBO)configMap.get(UCC_BRAND_VERIFY)).getEnable()) && CollectionUtils.isEmpty(brandVerifySet)) {
                log.error("{} \u7ebf\u7a0b\u54c1\u724c\u6821\u9a8c\u5747\u672a\u901a\u8fc7\uff0c\u5f53\u524d\u7ebf\u7a0b\u4e0d\u8fdb\u884c\u81ea\u52a8\u4e0a\u67b6\u5904\u7406", (Object)Thread.currentThread().getName());
                return;
            }
            ArrayList shelfSkuIds = new ArrayList();
            ArrayList recordAbilityBOS = new ArrayList();
            skuPoList.forEach(e -> {
                try {
                    if (ENABLE.equals(((UccConfigurationparametersQryBO)configMap.get(UCC_BRAND_VERIFY)).getEnable()) && !brandVerifySet.contains(e.getSkuId())) {
                        log.error("skuId:{} \u54c1\u724c\u6821\u9a8c\u672a\u901a\u8fc7\uff0c\u4e0d\u8fdb\u884c\u81ea\u52a8\u4e0a\u67b6\u5904\u7406", (Object)e.getSkuId());
                        return;
                    }
                    if (ENABLE.equals(((UccConfigurationparametersQryBO)configMap.get(UCC_IS_EXCEED_STANDARD_PRICE)).getEnable()) && !this.uccIsExceedStandardPrice(e.getSkuId())) {
                        return;
                    }
                    UccSkuPo uccSkuPo = new UccSkuPo();
                    uccSkuPo.setSkuId(e.getSkuId());
                    uccSkuPo.setSkuStatus(SkuStatusEnum.ON_SHELVES_STATUS.getStatus());
                    uccSkuPo.setOnShelveWay(SkuOnShelveWayEnum.ON_SHELVE_WAY_AUTO_TIME.getCode());
                    uccSkuPo.setUpdateOperId("system");
                    uccSkuPo.setUpdateOperName("\u8d85\u5e02\u81ea\u52a8\u4e0a\u67b6\u5b9a\u65f6\u4efb\u52a1");
                    uccSkuPo.setUpdateTime(new Date());
                    this.uccSkuMapper.updateSku(uccSkuPo);
                    shelfSkuIds.add(e.getSkuId());
                    UccSkuOperationLogRecordAbilityBO logRecordAbilityBO = new UccSkuOperationLogRecordAbilityBO();
                    logRecordAbilityBO.setSkuId(e.getSkuId());
                    logRecordAbilityBO.setCreateOperId("\u7cfb\u7edf");
                    logRecordAbilityBO.setCommodityId(e.getCommodityId());
                    logRecordAbilityBO.setCreateTime(new Date());
                    logRecordAbilityBO.setExtField1("\u8d85\u5e02\u5546\u54c1\u81ea\u52a8\u4e0a\u67b6\u5b9a\u65f6\u4efb\u52a1");
                    logRecordAbilityBO.setOperationType(Integer.valueOf(17));
                    logRecordAbilityBO.setRemark("\u5546\u54c1\u4e0a\u67b6-\u81ea\u52a8\u4e0a\u67b6");
                    recordAbilityBOS.add(logRecordAbilityBO);
                }
                catch (Exception ex) {
                    log.error("skuId:{}\u81ea\u52a8\u4e0a\u67b6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + CommonUtils.dealStackTrace((Exception)ex), (Object)e.getSkuId());
                }
            });
            try {
                if (!CollectionUtils.isEmpty(recordAbilityBOS)) {
                    UccSkuOperationLogRecordAbilityReqBO skuOperationLogRecordAbilityReqBO = new UccSkuOperationLogRecordAbilityReqBO();
                    skuOperationLogRecordAbilityReqBO.setRecordAbilityBOS(recordAbilityBOS);
                    this.uccSkuOperationLogRecordAbilityService.recordUccSkuOperationLog(skuOperationLogRecordAbilityReqBO);
                }
            }
            catch (Exception e2) {
                log.error("\u5546\u54c1\u4e0a\u67b6-\u81ea\u52a8\u4e0a\u67b6" + e2.getMessage());
            }
            if (!CollectionUtils.isEmpty(shelfSkuIds)) {
                CompletableFuture.runAsync(() -> {
                    SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                    syncSceneCommodityToEsReqBO.setSkuIds(shelfSkuIds);
                    syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
                    syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                    this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
                });
                log.error("{} \u7ebf\u7a0b\u5904\u7406\u8d85\u5e02\u4e0a\u67b6\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\uff01", (Object)Thread.currentThread().getName());
            }
        };
        threadPoolExecutor.submit(runnable);
    }

    private boolean uccIsExceedStandardPrice(Long skuId) {
        List skuPricePoList = this.uccSkuPriceMapper.getPricesBySkuId(skuId);
        if (CollectionUtils.isEmpty((Collection)skuPricePoList)) {
            log.error("skuId:{} \u672a\u67e5\u8be2\u5230\u4ef7\u683c\u4fe1\u606f\uff0c\u4e0d\u8fdb\u884c\u81ea\u52a8\u4e0a\u67b6\u5904\u7406", (Object)skuId);
            return false;
        }
        UccSkuStandardPricePO uccSkuStandardPricePO = new UccSkuStandardPricePO();
        uccSkuStandardPricePO.setSkuId(skuId);
        List standardPricePOList = this.uccSkuStandardPriceMapper.getList(uccSkuStandardPricePO);
        if (CollectionUtils.isEmpty((Collection)standardPricePOList)) {
            log.error("skuId:{} \u672a\u67e5\u8be2\u5230\u6807\u51c6\u4ef7\u683c\u4fe1\u606f\uff0c\u4e0d\u8fdb\u884c\u81ea\u52a8\u4e0a\u67b6\u5904\u7406", (Object)skuId);
            return false;
        }
        if (MoneyUtils.haoToYuan((Long)((UccSkuPricePo)skuPricePoList.get(0)).getAgreementPrice()).compareTo(((UccSkuStandardPricePO)standardPricePOList.get(0)).getStandardPrice().multiply(BigDecimal.ONE.add(((UccSkuStandardPricePO)standardPricePOList.get(0)).getUpRatio()))) > 0) {
            log.error("skuId:{} \u8d85\u8fc7\u57fa\u51c6\u4ef7\uff0c\u4e0d\u8fdb\u884c\u81ea\u52a8\u4e0a\u67b6\u5904\u7406", (Object)skuId);
            return false;
        }
        return true;
    }

    private Set<Long> checkMallBrand(List<UccSkuPo> uccSkus) {
        HashSet<Long> brandVerifySet = new HashSet<Long>();
        try {
            List brandIds = uccSkus.stream().map(UccSkuPo::getBrandId).distinct().collect(Collectors.toList());
            List commodityTypeIds = uccSkus.stream().map(UccSkuPo::getCommodityTypeId).distinct().collect(Collectors.toList());
            UccMallBrandRelPO uccMallBrandRelPo = new UccMallBrandRelPO();
            uccMallBrandRelPo.setBrandIds(brandIds);
            List uccMallBrandRelPOS = this.uccMallBrandRelMapper.getList(uccMallBrandRelPo);
            if (CollectionUtils.isEmpty((Collection)uccMallBrandRelPOS)) {
                return brandVerifySet;
            }
            Map uccMallBrandRelMap = uccMallBrandRelPOS.parallelStream().collect(Collectors.toMap(UccMallBrandRelPO::getBrandId, Function.identity(), (c1, c2) -> c1.getCreateTime().getTime() > c2.getCreateTime().getTime() ? c1 : c2));
            List uccCommodityTypePos = this.uccCommodityTypeMapper.queryPoByCommodityTypeIds(commodityTypeIds);
            if (CollectionUtils.isEmpty((Collection)uccCommodityTypePos)) {
                return brandVerifySet;
            }
            List catalogIds = uccCommodityTypePos.stream().map(UccCommodityTypePo::getCatalogId).collect(Collectors.toList());
            Map<Long, List<UccCommodityTypePo>> uccCommodityTypesMap = uccCommodityTypePos.stream().collect(Collectors.groupingBy(UccCommodityTypePo::getCommodityTypeId));
            List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.queryByCatIds(catalogIds);
            if (CollectionUtils.isEmpty((Collection)uccEMdmCatalogPOS)) {
                return brandVerifySet;
            }
            Map<Long, List<UccEMdmCatalogPO>> uccEmdmCatalogsMap = uccEMdmCatalogPOS.stream().collect(Collectors.groupingBy(UccEMdmCatalogPO::getCatalogId));
            HashMap mappingMap = new HashMap();
            List uccRelCatalogBrandVendorPOS = uccSkus.stream().map($ -> {
                UccMallBrandRelPO uccMallBrandRelPO = (UccMallBrandRelPO)uccMallBrandRelMap.get($.getBrandId());
                List uccCommodityTypePoList = (List)uccCommodityTypesMap.get($.getCommodityTypeId());
                if (Objects.nonNull(uccMallBrandRelPO) && !CollectionUtils.isEmpty((Collection)uccCommodityTypePoList)) {
                    UccRelCatalogBrandVendorPO uccRelCatalogBrandVendorPo = new UccRelCatalogBrandVendorPO();
                    UccCommodityTypePo uccCommodityTypePo = (UccCommodityTypePo)uccCommodityTypePoList.get(0);
                    uccRelCatalogBrandVendorPo.setBrandId(uccMallBrandRelPO.getMallBrandId());
                    uccRelCatalogBrandVendorPo.setVendorId($.getSupplierShopId());
                    uccRelCatalogBrandVendorPo.setCatalogId(uccCommodityTypePo.getCatalogId());
                    uccRelCatalogBrandVendorPo.setDiscountFlag(Integer.valueOf(0));
                    mappingMap.put($.getSkuId(), uccMallBrandRelPO.getMallBrandId() + "-" + $.getSupplierShopId() + "-" + uccCommodityTypePo.getCatalogId());
                    return uccRelCatalogBrandVendorPo;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(uccRelCatalogBrandVendorPOS)) {
                return brandVerifySet;
            }
            List listByParam = this.uccRelCatalogBrandVendorMapper.qryListByParam(uccRelCatalogBrandVendorPOS);
            if (CollectionUtils.isEmpty((Collection)listByParam)) {
                return brandVerifySet;
            }
            List<Object> mapping = !CollectionUtils.isEmpty((Collection)listByParam) ? listByParam.stream().map($ -> $.getBrandId() + "-" + $.getVendorId() + "-" + $.getCatalogId()).collect(Collectors.toList()) : new ArrayList();
            uccSkus.forEach(uccSkuPo -> {
                List uccCommodityTypePoList = (List)uccCommodityTypesMap.get(uccSkuPo.getCommodityTypeId());
                if (!CollectionUtils.isEmpty((Collection)uccCommodityTypePoList)) {
                    UccEMdmCatalogPO uccEMdmCatalogPO;
                    UccCommodityTypePo uccCommodityTypePo = (UccCommodityTypePo)uccCommodityTypePoList.get(0);
                    List uccEMdmCatalogPOList = (List)uccEmdmCatalogsMap.get(uccCommodityTypePo.getCatalogId());
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)uccEMdmCatalogPOList) && (Objects.isNull((uccEMdmCatalogPO = (UccEMdmCatalogPO)uccEMdmCatalogPOList.get(0)).getBrandVerify()) || 0 == uccEMdmCatalogPO.getBrandVerify())) {
                        return;
                    }
                    String s = (String)mappingMap.get(uccSkuPo.getSkuId());
                    if (!CollectionUtils.isEmpty((Collection)mapping) && !StringUtils.isEmpty((Object)s) && mapping.contains(s)) {
                        brandVerifySet.add(uccSkuPo.getSkuId());
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("\u8d85\u5e02\u5546\u54c1\u81ea\u52a8\u4e0a\u67b6\u5b9a\u65f6\u4efb\u52a1\u4e2d\uff0c\u54c1\u724c\u6821\u9a8c\u5f02\u5e38\uff1a " + CommonUtils.dealStackTrace((Exception)e));
        }
        return brandVerifySet;
    }
}

