/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccDealHandlerTaskJobAbilityReqBO;
import com.tydic.commodity.base.bo.UccMallEsUpdateReqBo;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.UccDealHandlerService;
import com.tydic.commodity.busibase.busi.api.UccDealHandlerTaskJobBusiService;
import com.tydic.commodity.busibase.busi.bo.UccDealHandlerReqBO;
import com.tydic.commodity.common.ability.api.UccUpdateBrandRelApproveAuditListAbilityService;
import com.tydic.commodity.common.ability.bo.BrandESBO;
import com.tydic.commodity.common.ability.bo.UccBrandRelApproveBo;
import com.tydic.commodity.common.ability.bo.UccMallBrandUpdateAbilityBo;
import com.tydic.commodity.common.ability.bo.UccUpdateBrandRelApproveAuditListReqBo;
import com.tydic.commodity.common.ability.bo.UccUpdateBrandRelApproveAuditListRspBo;
import com.tydic.commodity.common.busi.api.UccUpdateBrandRelApproveAuditListBusiService;
import com.tydic.commodity.config.DuplicateCommitLimit;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UocApprovalLogPO;
import com.tydic.commodity.task.TaskTodoWaitService;
import com.tydic.commodity.task.bo.TodoUccWaitAbilityReqBO;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccUpdateBrandRelApproveAuditListAbilityService"})
public class UccUpdateBrandRelApproveAuditListAbilityServiceImpl
implements UccUpdateBrandRelApproveAuditListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccUpdateBrandRelApproveAuditListAbilityServiceImpl.class);
    @Autowired
    private UccUpdateBrandRelApproveAuditListBusiService uccUpdateBrandRelApproveAuditListBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private UccDealHandlerService uccDealHandlerService;
    @Autowired
    private UccDealHandlerTaskJobBusiService uccDealHandlerTaskJobBusiService;

    @DuplicateCommitLimit
    @PostMapping(value={"updateBrandRelApproveAuditList"})
    public UccUpdateBrandRelApproveAuditListRspBo updateBrandRelApproveAuditList(@RequestBody UccUpdateBrandRelApproveAuditListReqBo reqBo) {
        UccUpdateBrandRelApproveAuditListAbilityServiceImpl.isCheck(reqBo);
        ArrayList<UocApprovalLogPO> uocApprovalLogPos = new ArrayList<UocApprovalLogPO>(reqBo.getApproveIds().size());
        for (Long approveId : reqBo.getApproveIds()) {
            UocApprovalLogPO uocApprovalLogPo = this.taskTodoWaitService.listApproval(approveId);
            uocApprovalLogPos.add(uocApprovalLogPo);
        }
        UccUpdateBrandRelApproveAuditListRspBo rspBo = this.uccUpdateBrandRelApproveAuditListBusiService.updateBrandRelApproveAuditList(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            CompletableFuture.runAsync(() -> {
                try {
                    this.sendToDo(reqBo, rspBo, uocApprovalLogPos);
                }
                catch (Exception e) {
                    log.error("\u53d1\u9001\u5f85\u529e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                }
                this.syncEs(rspBo.getBrandList());
                if (!CollectionUtils.isEmpty((Collection)rspBo.getUccMallBrandUpdateAbilityBos())) {
                    for (UccMallBrandUpdateAbilityBo uccMallBrandUpdateAbilityBo : rspBo.getUccMallBrandUpdateAbilityBos()) {
                        int num = 1;
                        int total = 0;
                        do {
                            Page page = new Page(num, 2000);
                            List dealSkuIds = this.uccSkuMapper.queryByBrandName(uccMallBrandUpdateAbilityBo.getBrandName(), page);
                            if (total == 0) {
                                total = page.getTotalPages();
                            }
                            if (CollectionUtils.isEmpty((Collection)dealSkuIds)) continue;
                            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                            syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList((Iterable)dealSkuIds));
                            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                            log.info("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
                            try {
                                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                            }
                            catch (Exception e) {
                                log.error("\u540c\u6b65\u5546\u54c1\u72b6\u6001\u548c\u4ef7\u683c\uff0c\u53d1\u9001es MQ\u5931\u8d25\uff1a" + e);
                            }
                        } while (++num <= total);
                    }
                }
            });
        }
        return rspBo;
    }

    private void sendToDo(UccUpdateBrandRelApproveAuditListReqBo reqBo, UccUpdateBrandRelApproveAuditListRspBo rspBo, List<UocApprovalLogPO> uocApprovalLogPos) {
        Map<Object, Object> uccBrandRelApproveBoList = new HashMap(16);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getUccBrandRelApproveBos())) {
            uccBrandRelApproveBoList = rspBo.getUccBrandRelApproveBos().stream().collect(Collectors.groupingBy(UccBrandRelApproveBo::getApproveId));
        }
        Map<Object, Object> uocApprovalLogPoList = new HashMap(16);
        if (!CollectionUtils.isEmpty(uocApprovalLogPos)) {
            uocApprovalLogPoList = uocApprovalLogPos.stream().collect(Collectors.groupingBy(UocApprovalLogPO::getObjId));
        }
        log.debug("uccBrandRelApproveBoList:{},uocApprovalLogPoList:{}", uccBrandRelApproveBoList, uocApprovalLogPoList);
        for (Long approveId : reqBo.getApproveIds()) {
            List uccBrandRelApproveBos;
            UocApprovalLogPO uocApprovalLogPo = new UocApprovalLogPO();
            if (MapUtil.isNotEmpty(uocApprovalLogPoList) && !CollectionUtils.isEmpty((Collection)((Collection)uocApprovalLogPoList.get(approveId)))) {
                uocApprovalLogPo = (UocApprovalLogPO)((List)uocApprovalLogPoList.get(approveId)).get(0);
            }
            if (CollectionUtils.isEmpty((Collection)(uccBrandRelApproveBos = (List)uccBrandRelApproveBoList.get(approveId)))) continue;
            UccBrandRelApproveBo uccBrandRelApproveBo = (UccBrandRelApproveBo)uccBrandRelApproveBos.get(0);
            TodoUccWaitAbilityReqBO todoParam = new TodoUccWaitAbilityReqBO();
            todoParam.setObjNo(uccBrandRelApproveBo.getApproveCode());
            todoParam.setOperatorType("1");
            todoParam.setObjId(uccBrandRelApproveBo.getApproveId());
            todoParam.setCenterCode("commodity");
            if (uocApprovalLogPo != null) {
                todoParam.setStationId(uocApprovalLogPo.getNextStationId() + "");
            }
            todoParam.setBusiCode("2022");
            todoParam.setBusiName("\u54c1\u724c\u5173\u8054\u5173\u7cfb\u5ba1\u6279");
            log.debug("todoParam:{}", (Object)todoParam);
            UccDealHandlerReqBO uccDealHandlerReqBO = (UccDealHandlerReqBO)JSON.parseObject((String)JSON.toJSONString((Object)todoParam), UccDealHandlerReqBO.class);
            uccDealHandlerReqBO.setHandleName("newBrandHandler");
            this.uccDealHandlerService.insertDealHandler(uccDealHandlerReqBO);
            UccDealHandlerTaskJobAbilityReqBO abilityReqBO = new UccDealHandlerTaskJobAbilityReqBO();
            abilityReqBO.setAbPush(Boolean.valueOf(true));
            this.uccDealHandlerTaskJobBusiService.dealHandlerTaskJob(abilityReqBO);
        }
    }

    private void syncEs(List<BrandESBO> brandInfoList) {
        if (!CollectionUtils.isEmpty(brandInfoList)) {
            brandInfoList.forEach(esbo -> {
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBo = new SyncSceneCommodityToEsReqBO();
                UccMallEsUpdateReqBo uccMallEsUpdateReqBo = new UccMallEsUpdateReqBo();
                uccMallEsUpdateReqBo.setBrandId(esbo.getBrandIdList());
                uccMallEsUpdateReqBo.setOriginBrandId(esbo.getOriginBrandIdList());
                uccMallEsUpdateReqBo.setUpdateMap(esbo.getBrandMap());
                syncSceneCommodityToEsReqBo.setUccMallEsUpdateReqBo(uccMallEsUpdateReqBo);
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBo)));
            });
        }
    }

    private static void isCheck(UccUpdateBrandRelApproveAuditListReqBo reqBo) {
        if (CollectionUtils.isEmpty((Collection)reqBo.getApproveIds())) {
            throw new BusinessException("8888", "\u5165\u53c2\u3010approveIds\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getAuditType() == null) {
            throw new BusinessException("8888", "\u5165\u53c2\u3010\u5ba1\u6279\u7ed3\u679c\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

