/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccBrandRelApproveBo;
import com.tydic.commodity.common.ability.bo.UccMallBrandUpdateAbilityBo;
import com.tydic.commodity.common.ability.bo.UccMallBrandUpdateAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccMallBrandUpdateAbilityRspBo;
import com.tydic.commodity.common.ability.bo.UccUpdateBrandRelApproveAuditListReqBo;
import com.tydic.commodity.common.ability.bo.UccUpdateBrandRelApproveAuditListRspBo;
import com.tydic.commodity.common.atom.api.UccDealApprovalAuditAtomService;
import com.tydic.commodity.common.atom.bo.UccDealApprovalAuditAtomReqBO;
import com.tydic.commodity.common.atom.bo.UccDealApprovalAuditAtomRspBO;
import com.tydic.commodity.common.busi.api.UccMallBrandUpdateBusiService;
import com.tydic.commodity.common.busi.api.UccUpdateBrandRelApproveAuditListBusiService;
import com.tydic.commodity.dao.UccBrandRelApproveMapper;
import com.tydic.commodity.po.UccBrandRelApprovePO;
import com.tydic.commodity.task.TaskTodoWaitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccUpdateBrandRelApproveAuditListBusiServiceImpl
implements UccUpdateBrandRelApproveAuditListBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccUpdateBrandRelApproveAuditListBusiServiceImpl.class);
    public static final Integer BRAND_REL_SOURCE_POOL = 1;
    public static final Integer BRAND_REL_SOURCE_SIMILAR = 2;
    public static final Integer BRAND_OPER_TYPE = 1;
    @Autowired
    private UccDealApprovalAuditAtomService uccDealApprovalAuditAtomService;
    @Autowired
    private UccBrandRelApproveMapper uccBrandRelApproveMapper;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private UccMallBrandUpdateBusiService uccMallBrandUpdateBusiService;

    @Override
    public UccUpdateBrandRelApproveAuditListRspBo updateBrandRelApproveAuditList(UccUpdateBrandRelApproveAuditListReqBo reqBo) {
        UccUpdateBrandRelApproveAuditListRspBo rspBo = new UccUpdateBrandRelApproveAuditListRspBo();
        Map<Long, Boolean> finishMap = this.dealAudit(reqBo, rspBo);
        this.dealMainInfo(reqBo, finishMap, rspBo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void dealMainInfo(UccUpdateBrandRelApproveAuditListReqBo reqBo, Map<Long, Boolean> finishMap, UccUpdateBrandRelApproveAuditListRspBo rspBo) {
        if (!CollectionUtils.isEmpty((Collection)reqBo.getApproveIds())) {
            if (reqBo.getAuditType() == 0) {
                List<Long> finistList = reqBo.getApproveIds().stream().filter(a -> finishMap.containsKey(a) && (Boolean)finishMap.get(a) != false).collect(Collectors.toList());
                for (Long approveId : finistList) {
                    UccBrandRelApprovePO set = new UccBrandRelApprovePO();
                    set.setApproveOpinion(reqBo.getAuditAdvice());
                    set.setApproveStatus(UccConstants.UccBrandRelApproveStatus.APPROVAL_PASS);
                    set.setUpdateOperId(reqBo.getOccupation());
                    set.setUpdateOperName(reqBo.getName());
                    set.setUpdateTime(new Date());
                    set.setAuditOperId(reqBo.getOccupation());
                    set.setAuditOperName(reqBo.getName());
                    set.setAuditTime(new Date());
                    UccBrandRelApprovePO where = new UccBrandRelApprovePO();
                    where.setApproveId(approveId);
                    this.uccBrandRelApproveMapper.updateBy(set, where);
                }
                this.syncRel(finistList, reqBo, rspBo);
            } else {
                for (Long approveId : reqBo.getApproveIds()) {
                    UccBrandRelApprovePO set = new UccBrandRelApprovePO();
                    set.setApproveOpinion(reqBo.getAuditAdvice());
                    set.setApproveStatus(UccConstants.UccBrandRelApproveStatus.APPROVAL_REJECTED);
                    set.setUpdateOperId(reqBo.getOccupation());
                    set.setUpdateOperName(reqBo.getName());
                    set.setUpdateTime(new Date());
                    set.setAuditOperId(reqBo.getOccupation());
                    set.setAuditOperName(reqBo.getName());
                    set.setAuditTime(new Date());
                    UccBrandRelApprovePO where = new UccBrandRelApprovePO();
                    where.setApproveId(approveId);
                    this.uccBrandRelApproveMapper.updateBy(set, where);
                }
            }
        }
    }

    private void syncRel(List<Long> approveIds, UccUpdateBrandRelApproveAuditListReqBo reqBo, UccUpdateBrandRelApproveAuditListRspBo rspBo) {
        UccBrandRelApprovePO qryUccBrandRelApproveP0 = new UccBrandRelApprovePO();
        qryUccBrandRelApproveP0.setApproveIds(approveIds);
        List uccBrandRelApprovePos = this.uccBrandRelApproveMapper.getList(qryUccBrandRelApproveP0);
        if (CollectionUtils.isEmpty((Collection)uccBrandRelApprovePos)) {
            throw new BusinessException("8888", "\u7533\u8bf7\u5355\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a");
        }
        ArrayList<UccMallBrandUpdateAbilityBo> brandInfos = new ArrayList<UccMallBrandUpdateAbilityBo>();
        for (UccBrandRelApprovePO each : uccBrandRelApprovePos) {
            UccMallBrandUpdateAbilityBo uccMallBrandUpdateAbilityBo = new UccMallBrandUpdateAbilityBo();
            uccMallBrandUpdateAbilityBo.setMallBrandId(each.getBrandId());
            uccMallBrandUpdateAbilityBo.setMallBrandName(each.getBrandName());
            if (BRAND_OPER_TYPE.equals(each.getBrandOperType())) {
                uccMallBrandUpdateAbilityBo.setType(UccConstants.BrandRelOperType.CREATE);
            } else {
                uccMallBrandUpdateAbilityBo.setType(UccConstants.BrandRelOperType.CANCEL);
            }
            uccMallBrandUpdateAbilityBo.setBrandName(each.getExtBrandName());
            if (StringUtils.isEmpty((Object)each.getCreateOperId())) {
                each.setCreateOperId("OL");
                each.setCreateOperName("\u7cfb\u7edf");
            }
            uccMallBrandUpdateAbilityBo.setUpdateOperId(each.getCreateOperId());
            uccMallBrandUpdateAbilityBo.setCreateOperId(each.getCreateOperId());
            uccMallBrandUpdateAbilityBo.setCreateOperName(each.getCreateOperName());
            brandInfos.add(uccMallBrandUpdateAbilityBo);
        }
        UccMallBrandUpdateAbilityReqBo uccMallBrandUpdateAbilityReqBo = (UccMallBrandUpdateAbilityReqBo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), UccMallBrandUpdateAbilityReqBo.class);
        uccMallBrandUpdateAbilityReqBo.setBrandInfo(brandInfos);
        UccMallBrandUpdateAbilityRspBo uccMallBrandUpdateAbilityRspBo = this.uccMallBrandUpdateBusiService.updateBrandInfo(uccMallBrandUpdateAbilityReqBo);
        if (!"0000".equals(uccMallBrandUpdateAbilityRspBo.getRespCode())) {
            throw new BusinessException("8888", "\u8c03\u7528\u5546\u57ce\u54c1\u724c\u540d\u79f0\u5173\u8054\u66f4\u65b0\u63a5\u53e3\u5931\u8d25");
        }
        rspBo.setBrandList(uccMallBrandUpdateAbilityRspBo.getBrandList());
        rspBo.setUccMallBrandUpdateAbilityBos(brandInfos);
    }

    private Map<Long, Boolean> dealAudit(UccUpdateBrandRelApproveAuditListReqBo reqBo, UccUpdateBrandRelApproveAuditListRspBo rspBo) {
        HashMap<Long, Boolean> finishMap = new HashMap<Long, Boolean>();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getApproveIds())) {
            UccBrandRelApprovePO uccBrandRelApprovePo = new UccBrandRelApprovePO();
            uccBrandRelApprovePo.setApproveIds(reqBo.getApproveIds());
            List uccBrandRelApprovePos = this.uccBrandRelApproveMapper.getList(uccBrandRelApprovePo);
            Map<Object, Object> stepMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)uccBrandRelApprovePos)) {
                List uccBrandRelApproveBos = JSONObject.parseArray((String)JSONObject.toJSONString((Object)uccBrandRelApprovePos), UccBrandRelApproveBo.class);
                rspBo.setUccBrandRelApproveBos(uccBrandRelApproveBos);
                stepMap = uccBrandRelApprovePos.stream().filter(a -> !StringUtils.isEmpty((Object)a.getExtField1())).collect(Collectors.toMap(UccBrandRelApprovePO::getApproveId, UccBrandRelApprovePO::getExtField1));
            }
            UccDealApprovalAuditAtomReqBO bo = new UccDealApprovalAuditAtomReqBO();
            bo.setAuditAdvice(reqBo.getAuditAdvice());
            bo.setAuditResult(reqBo.getAuditType());
            bo.setUserId(reqBo.getUserId());
            bo.setUserName(reqBo.getName());
            bo.setObjType(1);
            bo.setOrgName(reqBo.getOrgName());
            for (Long approveId : reqBo.getApproveIds()) {
                bo.setStepId((String)stepMap.get(approveId));
                bo.setObjId(approveId);
                UccDealApprovalAuditAtomRspBO dealApprovalAtomRspBO = this.uccDealApprovalAuditAtomService.dealApproval(bo);
                if (!dealApprovalAtomRspBO.getRespCode().equals("0000")) {
                    throw new ZTBusinessException("\u5ba1\u6279\u5931\u8d25\uff1a" + dealApprovalAtomRspBO.getRespDesc());
                }
                if (!StringUtils.isEmpty((Object)dealApprovalAtomRspBO.getStepId())) {
                    UccBrandRelApprovePO set = new UccBrandRelApprovePO();
                    set.setExtField1(dealApprovalAtomRspBO.getStepId());
                    set.setUpdateTime(new Date());
                    set.setUpdateOperId(reqBo.getOccupation());
                    set.setUpdateOperName(reqBo.getName());
                    UccBrandRelApprovePO where = new UccBrandRelApprovePO();
                    where.setApproveId(approveId);
                    this.uccBrandRelApproveMapper.updateBy(set, where);
                }
                finishMap.put(approveId, dealApprovalAtomRspBO.getFinish());
            }
        }
        return finishMap;
    }
}

