/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.common.ability.api.UccGetSpecChangeListAbilityService;
import com.tydic.commodity.common.ability.bo.UccGetSpecChangeListReqBo;
import com.tydic.commodity.common.ability.bo.UccGetSpecChangeListRspBo;
import com.tydic.commodity.common.ability.bo.UccGetSpecChangeListRspBoRows;
import com.tydic.commodity.common.ability.bo.UccGetSpecChangeListRspBoRowsSpecList;
import com.tydic.commodity.dao.UccSkuSpecChangeDealMapper;
import com.tydic.commodity.dao.UccSkuSpecChangeDetailMapper;
import com.tydic.commodity.po.UccSkuSpecChangeDealPO;
import com.tydic.commodity.po.UccSkuSpecChangeDetailPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccGetSpecChangeListAbilityService"})
public class UccGetSpecChangeListAbilityServiceImpl
implements UccGetSpecChangeListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccGetSpecChangeListAbilityServiceImpl.class);
    @Autowired
    private UccSkuSpecChangeDetailMapper uccSkuSpecChangeDetailMapper;
    @Autowired
    private UccSkuSpecChangeDealMapper uccSkuSpecChangeDealMapper;

    @PostMapping(value={"getSpecChangeList"})
    public UccGetSpecChangeListRspBo getSpecChangeList(@RequestBody UccGetSpecChangeListReqBo reqBo) {
        log.error("getSpecChangeList\u67e5\u8be2\u5165\u53c2\u4e3a:{}", (Object)JSON.toJSONString((Object)reqBo));
        UccSkuSpecChangeDealPO skuSpecChangeDealPO = (UccSkuSpecChangeDealPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), UccSkuSpecChangeDealPO.class);
        String extSkuId = reqBo.getExtSkuId();
        if (!StringUtils.isEmpty((Object)extSkuId)) {
            String[] split = extSkuId.split(",");
            skuSpecChangeDealPO.setExtSkuIds(Arrays.asList(split));
            skuSpecChangeDealPO.setExtSkuId(null);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityType())) {
            skuSpecChangeDealPO.setExt1(reqBo.getCommodityType());
        }
        if (reqBo.getDealType() == 0) {
            skuSpecChangeDealPO.setOrderBy(" create_time desc");
        } else {
            skuSpecChangeDealPO.setOrderBy(" deal_time desc");
        }
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        List list = this.uccSkuSpecChangeDealMapper.getListPage(skuSpecChangeDealPO, page);
        log.error("\u4e3b\u8868\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)list));
        List rows = JSON.parseArray((String)JSON.toJSONString((Object)list), UccGetSpecChangeListRspBoRows.class);
        log.error("\u4e3b\u8868\u8f6c\u6362\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)rows));
        for (UccGetSpecChangeListRspBoRows row : rows) {
            Long id = row.getId();
            UccSkuSpecChangeDetailPO uccSkuSpecChangeDetailPO = new UccSkuSpecChangeDetailPO();
            uccSkuSpecChangeDetailPO.setRelId(id);
            List detailList = this.uccSkuSpecChangeDetailMapper.getList(uccSkuSpecChangeDetailPO);
            log.error("\u5b50\u9879\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)detailList));
            List parseArray = JSON.parseArray((String)JSON.toJSONString((Object)detailList), UccGetSpecChangeListRspBoRowsSpecList.class);
            log.error("\u8f6c\u6362\u540e\u5b50\u9879\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)parseArray));
            row.setSpecList(parseArray);
        }
        UccGetSpecChangeListRspBo rspBo = new UccGetSpecChangeListRspBo();
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRows(rows);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        log.error("\u6700\u7ec8\u8fd4\u56de\u503c\uff1a{}", (Object)JSON.toJSONString((Object)rspBo));
        return rspBo;
    }

    @PostMapping(value={"getSpecChangeListExport"})
    public UccGetSpecChangeListRspBo getSpecChangeListExport(@RequestBody UccGetSpecChangeListReqBo reqBo) {
        UccGetSpecChangeListRspBo specChangeList = this.getSpecChangeList(reqBo);
        if (specChangeList.getRespCode().equals("0000")) {
            List rows = specChangeList.getRows();
            for (UccGetSpecChangeListRspBoRows row : rows) {
                List parseArray = row.getSpecList();
                Map<Long, List<UccGetSpecChangeListRspBoRowsSpecList>> collect = parseArray.stream().collect(Collectors.groupingBy(UccGetSpecChangeListRspBoRowsSpecList::getSpecType));
                List<UccGetSpecChangeListRspBoRowsSpecList> before = collect.get(1L);
                String beforeStr = this.splicingParameters(before);
                row.setBeforeSpec(beforeStr);
                List<UccGetSpecChangeListRspBoRowsSpecList> after = collect.get(2L);
                String afterStr = this.splicingParameters(after);
                row.setAfterSpec(afterStr);
                row.setSpecList(null);
            }
        }
        return specChangeList;
    }

    private String splicingParameters(List<UccGetSpecChangeListRspBoRowsSpecList> before) {
        if (CollectionUtils.isEmpty(before)) {
            return null;
        }
        ArrayList<String> specStrings = new ArrayList<String>();
        for (UccGetSpecChangeListRspBoRowsSpecList spec : before) {
            String propShowName = spec.getPropShowName();
            String propValue = spec.getPropValue();
            String str = propShowName + "\uff08" + propValue + "\uff09";
            specStrings.add(str);
        }
        return String.join((CharSequence)"\uff0c", specStrings);
    }
}

