/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.enumType.Brand;
import com.tydic.commodity.common.ability.api.UccQryBrandRelApproveAuditPageListAbilityService;
import com.tydic.commodity.common.ability.bo.UccBrandRelApproveBo;
import com.tydic.commodity.common.ability.bo.UccBrandRelCatalogLevelBO;
import com.tydic.commodity.common.ability.bo.UccQryBrandRelApproveAuditPageListAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccQryBrandRelApproveAuditPageListAbilityRspBo;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccBrandRelApproveMapper;
import com.tydic.commodity.po.UccBrandRelApprovePO;
import com.tydic.commodity.po.UccBrandRelCatalogLevelPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccQryBrandRelApproveAuditPageListAbilityService"})
public class UccQryBrandRelApproveAuditPageListAbilityServiceImpl
implements UccQryBrandRelApproveAuditPageListAbilityService {
    public static final Integer PENDING_APPROVAL = 1;
    public static final Integer APPROVED = 2;
    @Autowired
    private UccBrandRelApproveMapper uccBrandRelApproveMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;

    @PostMapping(value={"qryBrandRelApproveAuditPageList"})
    public UccQryBrandRelApproveAuditPageListAbilityRspBo qryBrandRelApproveAuditPageList(@RequestBody UccQryBrandRelApproveAuditPageListAbilityReqBo reqBo) {
        List uccBrandRelApprovePos;
        UccQryBrandRelApproveAuditPageListAbilityRspBo rspBo = new UccQryBrandRelApproveAuditPageListAbilityRspBo();
        UccBrandRelApprovePO qryUccBrandRelApprovePo = new UccBrandRelApprovePO();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryUccBrandRelApprovePo);
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        if (reqBo.getAuditTable() != null) {
            if (reqBo.getAuditTable().equals("1")) {
                ArrayList stationIdList = new ArrayList();
                if (CollectionUtils.isEmpty((Collection)reqBo.getUmcStationsListWebExt())) {
                    rspBo.setRows(new ArrayList());
                    return rspBo;
                }
                reqBo.getUmcStationsListWebExt().forEach(busiCommonStationWebBO -> stationIdList.add(busiCommonStationWebBO.getStationId()));
                qryUccBrandRelApprovePo.setApprovalQryUserId(reqBo.getUserId());
                qryUccBrandRelApprovePo.setStationIdList(stationIdList);
            } else {
                if (reqBo.getUserId() == null) {
                    rspBo.setRows(new ArrayList());
                    return rspBo;
                }
                qryUccBrandRelApprovePo.setOwnOperId(reqBo.getUserId().toString());
            }
        }
        if (CollectionUtils.isEmpty((Collection)(uccBrandRelApprovePos = this.uccBrandRelApproveMapper.getListAuditPage(qryUccBrandRelApprovePo, page)))) {
            rspBo.setPageNo(reqBo.getPageNo());
            rspBo.setRecordsTotal(page.getTotalCount());
            rspBo.setTotal(page.getTotalPages());
            rspBo.setRows(new ArrayList(0));
            return rspBo;
        }
        List uccBrandRelApproveBos = JSONObject.parseArray((String)JSONObject.toJSONString((Object)uccBrandRelApprovePos), UccBrandRelApproveBo.class);
        this.translation(uccBrandRelApproveBos);
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRows(uccBrandRelApproveBos);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void translation(List<UccBrandRelApproveBo> uccBrandRelApproveBos) {
        Map<String, String> brandStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap(Brand.BRAND_STATUS.toString());
        Map<String, String> approveStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap(Brand.UCC_BRAND_REL_APPROVE_STATUS_DIC.toString());
        Map<Long, List<UccBrandRelCatalogLevelPo>> brandRelMap = this.collectRelCatalogInfo(uccBrandRelApproveBos);
        for (UccBrandRelApproveBo each : uccBrandRelApproveBos) {
            if (!MapUtil.isEmpty(brandRelMap) && brandRelMap.containsKey(each.getBrandId())) {
                each.setCatalogLevelBOS(JSON.parseArray((String)JSON.toJSONString(brandRelMap.get(each.getBrandId())), UccBrandRelCatalogLevelBO.class));
                each.setCatalogLevelSplitStr(each.getCatalogLevelBOS().stream().map(UccBrandRelCatalogLevelBO::getCatalogLevelNameStr).collect(Collectors.joining(",")));
            }
            if (brandStatusMap != null && each.getBrandStatus() != null && brandStatusMap.containsKey(each.getBrandStatus().toString())) {
                each.setBrandStatusStr(brandStatusMap.get(each.getBrandStatus().toString()));
            }
            if (approveStatusMap == null || each.getApproveStatus() == null || !approveStatusMap.containsKey(each.getApproveStatus().toString())) continue;
            each.setApproveStatusStr(approveStatusMap.get(each.getApproveStatus().toString()));
        }
    }

    private Map<Long, List<UccBrandRelCatalogLevelPo>> collectRelCatalogInfo(List<UccBrandRelApproveBo> getMallBrandDetailGroupList) {
        List brandIds = getMallBrandDetailGroupList.stream().map(UccBrandRelApproveBo::getBrandId).collect(Collectors.toList());
        List catalogLevelList = this.uccBrandDealMapper.queryCatalogTreeList(brandIds);
        if (!CollectionUtils.isEmpty((Collection)catalogLevelList)) {
            return catalogLevelList.stream().collect(Collectors.groupingBy(UccBrandRelCatalogLevelPo::getBrandId));
        }
        return null;
    }
}

