/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccWarehouseBusiEmpBO;
import com.tydic.commodity.common.busi.api.UccEnterpriseWarehouseUpdateBusiService;
import com.tydic.commodity.common.busi.bo.UccEnterpriseWarehouseUpdateBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccEnterpriseWarehouseUpdateBusiRspBO;
import com.tydic.commodity.dao.UccEnterpriseWarehouseMapper;
import com.tydic.commodity.dao.UccWarehouseBusiEmpMapper;
import com.tydic.commodity.po.UccEnterpriseWarehousePO;
import com.tydic.commodity.po.UccWarehouseBusiEmpPO;
import com.tydic.umc.general.ability.api.UmcDycMemberWarehouseEmpUpdateAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycMemberWarehouseEmpUpdateAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDycMemberWarehouseEmpUpdateAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccEnterpriseWarehouseUpdateBusiServiceImpl
implements UccEnterpriseWarehouseUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccEnterpriseWarehouseUpdateBusiServiceImpl.class);
    @Autowired
    private UccEnterpriseWarehouseMapper uccEnterpriseWarehouseMapper;
    @Autowired
    private UccWarehouseBusiEmpMapper uccWarehouseBusiEmpMapper;
    @Autowired
    private UmcDycMemberWarehouseEmpUpdateAbilityService umcDycMemberWarehouseEmpUpdateAbilityService;

    @Override
    public UccEnterpriseWarehouseUpdateBusiRspBO updateEnterpriseWarehouse(UccEnterpriseWarehouseUpdateBusiReqBO reqBO) {
        UccEnterpriseWarehousePO uccEnterpriseWarehousePO = new UccEnterpriseWarehousePO();
        uccEnterpriseWarehousePO.setWarehouseId(reqBO.getWarehouseId());
        uccEnterpriseWarehousePO = this.uccEnterpriseWarehouseMapper.getModelBy(uccEnterpriseWarehousePO);
        if (uccEnterpriseWarehousePO == null) {
            throw new BusinessException(RspConstantEnums.WAREHOUSE_UPDATE_FAIL.code(), "\u672a\u67e5\u8be2\u5230\u4f01\u914d\u4ed3\u4fe1\u606f");
        }
        if (reqBO.getStatus() != null) {
            if (UccConstants.WarehouseState.INVALID.equals(reqBO.getStatus())) {
                if (!UccConstants.WarehouseState.VALID.equals(uccEnterpriseWarehousePO.getStatus())) {
                    throw new BusinessException(RspConstantEnums.WAREHOUSE_UPDATE_FAIL.code(), "\u4e0d\u5728\u542f\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u505c\u7528");
                }
            } else if (!UccConstants.WarehouseState.INVALID.equals(uccEnterpriseWarehousePO.getStatus())) {
                throw new BusinessException(RspConstantEnums.WAREHOUSE_UPDATE_FAIL.code(), "\u4e0d\u5728\u505c\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u542f\u7528");
            }
            UccEnterpriseWarehousePO enterpriseWarehousePO = new UccEnterpriseWarehousePO();
            enterpriseWarehousePO.setWarehouseId(reqBO.getWarehouseId());
            enterpriseWarehousePO.setStatus(reqBO.getStatus());
            this.uccEnterpriseWarehouseMapper.updateById(enterpriseWarehousePO);
        } else {
            if (!uccEnterpriseWarehousePO.getWarehouseCode().equals(reqBO.getWarehouseCode())) {
                UccEnterpriseWarehousePO checkByPO = new UccEnterpriseWarehousePO();
                checkByPO.setWarehouseCode(reqBO.getWarehouseCode());
                int i = this.uccEnterpriseWarehouseMapper.getCheckBy(checkByPO);
                if (i > 0) {
                    throw new BusinessException(RspConstantEnums.WAREHOUSE_UPDATE_FAIL.code(), "\u4f01\u914d\u4ed3\u7f16\u7801\u5df2\u5b58\u5728\uff01");
                }
            }
            ArrayList<String> areaList = new ArrayList<String>();
            if (!StringUtils.isEmpty((Object)reqBO.getProvince())) {
                areaList.add(reqBO.getProvince());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getCity())) {
                areaList.add(reqBO.getCity());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getCounty())) {
                areaList.add(reqBO.getCounty());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getTown())) {
                areaList.add(reqBO.getTown());
            }
            String area = String.join((CharSequence)"/", areaList);
            UccEnterpriseWarehousePO enterpriseWarehousePO = (UccEnterpriseWarehousePO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), UccEnterpriseWarehousePO.class);
            enterpriseWarehousePO.setArea(area);
            Date nowTime = new Date();
            enterpriseWarehousePO.setUpdateTime(nowTime);
            enterpriseWarehousePO.setUpdateUserName(reqBO.getName());
            enterpriseWarehousePO.setUpdateUserId(reqBO.getUserId());
            enterpriseWarehousePO.setUpdateUserAccount(reqBO.getUsername());
            this.uccEnterpriseWarehouseMapper.updateAreaById(enterpriseWarehousePO);
            UccWarehouseBusiEmpPO uccWarehouseBusiEmpPO = new UccWarehouseBusiEmpPO();
            uccWarehouseBusiEmpPO.setWarehouseId(reqBO.getWarehouseId());
            List uccWarehouseBusiEmpPOList = this.uccWarehouseBusiEmpMapper.getList(uccWarehouseBusiEmpPO);
            Map<Object, Object> uccWarehouseBusiEmpPOMap = new HashMap(uccWarehouseBusiEmpPOList.size());
            if (!CollectionUtils.isEmpty((Collection)uccWarehouseBusiEmpPOList)) {
                uccWarehouseBusiEmpPOMap = uccWarehouseBusiEmpPOList.stream().collect(Collectors.toMap(UccWarehouseBusiEmpPO::getUserId, Function.identity()));
            }
            ArrayList<Long> enableUserList = new ArrayList<Long>();
            ArrayList<Long> stopUserList = new ArrayList<Long>();
            if (!CollectionUtils.isEmpty(reqBO.getWarehouseBusiEmpBOList())) {
                ArrayList uccWarehouseBusiEmpPOS = new ArrayList(reqBO.getWarehouseBusiEmpBOList().size());
                for (UccWarehouseBusiEmpBO busiEmpBO : reqBO.getWarehouseBusiEmpBOList()) {
                    UccWarehouseBusiEmpPO po = (UccWarehouseBusiEmpPO)JSON.parseObject((String)JSON.toJSONString((Object)busiEmpBO), UccWarehouseBusiEmpPO.class);
                    po.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    po.setWarehouseId(reqBO.getWarehouseId());
                    if (uccWarehouseBusiEmpPOMap.get(busiEmpBO.getUserId()) != null) {
                        po.setCreateTime(((UccWarehouseBusiEmpPO)uccWarehouseBusiEmpPOMap.get(busiEmpBO.getUserId())).getCreateTime());
                        po.setCreateUserId(((UccWarehouseBusiEmpPO)uccWarehouseBusiEmpPOMap.get(busiEmpBO.getUserId())).getUserId());
                        po.setCreateUserName(((UccWarehouseBusiEmpPO)uccWarehouseBusiEmpPOMap.get(busiEmpBO.getUserId())).getCreateUserName());
                        po.setCreateUserAccount(((UccWarehouseBusiEmpPO)uccWarehouseBusiEmpPOMap.get(busiEmpBO.getUserId())).getCreateUserAccount());
                        if (!busiEmpBO.getStopStatus().equals(((UccWarehouseBusiEmpPO)uccWarehouseBusiEmpPOMap.get(busiEmpBO.getUserId())).getStopStatus())) {
                            if (UccConstants.WarehouseBusiEmpStatus.VALID.equals(busiEmpBO.getStopStatus())) {
                                enableUserList.add(busiEmpBO.getUserId());
                            } else if (this.isAddStopUser(busiEmpBO.getUserId(), reqBO.getWarehouseId()).booleanValue()) {
                                stopUserList.add(busiEmpBO.getUserId());
                            }
                            po.setUpdateTime(((UccWarehouseBusiEmpPO)uccWarehouseBusiEmpPOMap.get(busiEmpBO.getUserId())).getUpdateTime());
                            po.setUpdateUserId(((UccWarehouseBusiEmpPO)uccWarehouseBusiEmpPOMap.get(busiEmpBO.getUserId())).getUserId());
                            po.setUpdateUserName(((UccWarehouseBusiEmpPO)uccWarehouseBusiEmpPOMap.get(busiEmpBO.getUserId())).getUpdateUserName());
                            po.setUpdateUserAccount(((UccWarehouseBusiEmpPO)uccWarehouseBusiEmpPOMap.get(busiEmpBO.getUserId())).getUpdateUserAccount());
                        }
                    } else {
                        if (UccConstants.WarehouseBusiEmpStatus.VALID.equals(busiEmpBO.getStopStatus())) {
                            enableUserList.add(busiEmpBO.getUserId());
                        }
                        po.setCreateTime(nowTime);
                        po.setUpdateTime(nowTime);
                        po.setCreateUserId(reqBO.getUserId());
                        po.setCreateUserName(reqBO.getName());
                        po.setCreateUserAccount(reqBO.getUsername());
                        po.setUpdateUserId(reqBO.getUserId());
                        po.setUpdateUserName(reqBO.getName());
                        po.setUpdateUserAccount(reqBO.getUsername());
                    }
                    uccWarehouseBusiEmpPOS.add(po);
                }
                for (UccWarehouseBusiEmpPO busiEmpPO : uccWarehouseBusiEmpPOList) {
                    List userIdList = reqBO.getWarehouseBusiEmpBOList().stream().map(UccWarehouseBusiEmpBO::getUserId).collect(Collectors.toList());
                    if (userIdList.contains(busiEmpPO.getUserId()) || !UccConstants.WarehouseBusiEmpStatus.VALID.equals(busiEmpPO.getStopStatus()) || !this.isAddStopUser(busiEmpPO.getUserId(), busiEmpPO.getWarehouseId()).booleanValue()) continue;
                    stopUserList.add(busiEmpPO.getUserId());
                }
                UccWarehouseBusiEmpPO deletePO = new UccWarehouseBusiEmpPO();
                deletePO.setWarehouseId(reqBO.getWarehouseId());
                this.uccWarehouseBusiEmpMapper.deleteBy(deletePO);
                this.uccWarehouseBusiEmpMapper.insertBatch((List)uccWarehouseBusiEmpPOS);
            } else {
                for (UccWarehouseBusiEmpPO busiEmpPO : uccWarehouseBusiEmpPOList) {
                    if (!UccConstants.WarehouseBusiEmpStatus.VALID.equals(busiEmpPO.getStopStatus()) || !this.isAddStopUser(busiEmpPO.getUserId(), busiEmpPO.getWarehouseId()).booleanValue()) continue;
                    stopUserList.add(busiEmpPO.getUserId());
                }
                UccWarehouseBusiEmpPO deletePO = new UccWarehouseBusiEmpPO();
                deletePO.setWarehouseId(reqBO.getWarehouseId());
                this.uccWarehouseBusiEmpMapper.deleteBy(deletePO);
            }
            if (!CollectionUtils.isEmpty(enableUserList) || !CollectionUtils.isEmpty(stopUserList)) {
                UmcDycMemberWarehouseEmpUpdateAbilityReqBO umcDycMemberWarehouseEmpUpdateAbilityReqBO = new UmcDycMemberWarehouseEmpUpdateAbilityReqBO();
                umcDycMemberWarehouseEmpUpdateAbilityReqBO.setEnableUserList(enableUserList);
                umcDycMemberWarehouseEmpUpdateAbilityReqBO.setStopUserIdList(stopUserList);
                log.debug("\u4f01\u914d\u4ed3\u6743\u9650\u540c\u6b65\u4f1a\u5458\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcDycMemberWarehouseEmpUpdateAbilityReqBO));
                UmcDycMemberWarehouseEmpUpdateAbilityRspBO umcDycMemberWarehouseEmpUpdateAbilityRspBO = this.umcDycMemberWarehouseEmpUpdateAbilityService.updateMemberWarehouseEmp(umcDycMemberWarehouseEmpUpdateAbilityReqBO);
                log.debug("\u4f01\u914d\u4ed3\u6743\u9650\u540c\u6b65\u4f1a\u5458\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcDycMemberWarehouseEmpUpdateAbilityRspBO));
                if (!"0000".equals(umcDycMemberWarehouseEmpUpdateAbilityRspBO.getRespCode())) {
                    throw new BusinessException(RspConstantEnums.WAREHOUSE_UPDATE_FAIL.code(), "\u540c\u6b65\u4f1a\u5458\u4f01\u914d\u4ed3\u6743\u9650\u5931\u8d25\uff01");
                }
            }
        }
        UccEnterpriseWarehouseUpdateBusiRspBO rspBO = new UccEnterpriseWarehouseUpdateBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Boolean isAddStopUser(Long userId, Long warehouseId) {
        UccWarehouseBusiEmpPO checkPO = new UccWarehouseBusiEmpPO();
        checkPO.setUserId(userId);
        checkPO.setStopStatus(UccConstants.WarehouseBusiEmpStatus.VALID);
        checkPO.setNoWarehouseId(warehouseId);
        int i = this.uccWarehouseBusiEmpMapper.getCheckBy(checkPO);
        if (i < 1) {
            return true;
        }
        return false;
    }
}

