/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.UccDealHandlerService;
import com.tydic.commodity.busibase.busi.bo.UccDealHandlerReqBO;
import com.tydic.commodity.common.ability.bo.UccUpdateCancelSkuApprovalAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccUpdateCancelSkuApprovalAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccUpdateCancelSkuApprovalBusiService;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.task.TaskTodoWaitService;
import com.tydic.commodity.task.bo.TodoUccWaitAbilityReqBO;
import com.tydic.uac.ability.UacNoTaskAuditCancelAbilityService;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelRspBO;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UccUpdateCancelSkuApprovalBusiServiceImpl
implements UccUpdateCancelSkuApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccUpdateCancelSkuApprovalBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UacNoTaskAuditCancelAbilityService uacNoTaskAuditCancelAbilityService;
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private UccDealHandlerService uccDealHandlerService;

    @Override
    public UccUpdateCancelSkuApprovalAbilityRspBO updateCancelSkuApproval(UccUpdateCancelSkuApprovalAbilityReqBO reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuBos())) {
            List<UccSkuPo> skuPos = reqBO.getSkuBos().stream().map(e -> (UccSkuPo)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccSkuPo.class)).collect(Collectors.toList());
            this.dealElcSku(skuPos);
        } else {
            List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(reqBO.getSkuIds());
            if (CollectionUtil.isEmpty((Collection)uccSkuPos)) {
                throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5355\u54c1\u4fe1\u606f");
            }
            this.dealElcSku(uccSkuPos);
        }
        UccUpdateCancelSkuApprovalAbilityRspBO rspBo = new UccUpdateCancelSkuApprovalAbilityRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void dealElcSku(List<UccSkuPo> uccSkuPos) {
        try {
            for (UccSkuPo uccSkuPo : uccSkuPos) {
                if (uccSkuPo.getApprovalStatus() == null) continue;
                switch (uccSkuPo.getApprovalStatus()) {
                    case 21: {
                        this.cancelWaitDone(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF, "2001", "\u7535\u5546\u5546\u54c1\u4e0a\u67b6");
                        this.cancelWaitDone(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_MAPPING_BRAND, "2018", "\u7535\u5546\u5546\u54c1\u4e0a\u67b6(\u76f4\u63a5\u4e0a\u67b6)");
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF);
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_MAPPING_BRAND);
                        break;
                    }
                    case 31: {
                        Long objId = uccSkuPo.getCommodityId() == null ? uccSkuPo.getSkuId() : uccSkuPo.getCommodityId();
                        this.cancelWaitDone(objId, ModelRuleConstant.UAC_APPROVAL_TYPE_EDIT, "2008", "\u65e0\u534f\u8bae\u5546\u54c1\u7f16\u8f91");
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_EDIT);
                        break;
                    }
                    case 41: {
                        this.cancelWaitDone(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN, "2002", "\u7535\u5546\u5546\u54c1\u4e0b\u67b6");
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN);
                        break;
                    }
                    case 51: {
                        this.cancelWaitDone(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_RECOVER, "2003", "\u7535\u5546\u5546\u54c1\u6062\u590d\u4e0a\u67b6");
                        this.cancelWaitDone(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_MAPPING_BRAND, "2019", "\u7535\u5546\u5546\u54c1\u6062\u590d\u4e0a\u67b6(\u76f4\u63a5\u4e0a\u67b6)");
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_RECOVER);
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_MAPPING_BRAND);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88\u5f85\u529e\u548c\u5ba1\u6279\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    private void cancelWaitDone(Long skuId, Integer objType, String busiCode, String busiName) {
        try {
            UacQryAuditLogReqBO reqStationBO = new UacQryAuditLogReqBO();
            reqStationBO.setObjType(objType);
            reqStationBO.setObjId(skuId + "");
            UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLastLog(reqStationBO);
            if (!"0000".equals(uacQryAuditLogRspBO.getRespCode())) {
                log.error("8888", (Object)"\u67e5\u8be2\u5f85\u529e\u4e0b\u4e00\u5ba1\u6279\u4eba\u5c97\u4f4d\u4e3a\u7a7a\uff01");
            }
            if (!ObjectUtils.isEmpty((Object)uacQryAuditLogRspBO)) {
                TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO = new TodoUccWaitAbilityReqBO();
                todoUccWaitAbilityReqBO.setBusiCode(busiCode);
                todoUccWaitAbilityReqBO.setBusiName(busiName);
                todoUccWaitAbilityReqBO.setCenterCode("commodity");
                todoUccWaitAbilityReqBO.setOperatorType("2");
                todoUccWaitAbilityReqBO.setObjId(skuId);
                todoUccWaitAbilityReqBO.setStationId(uacQryAuditLogRspBO.getLogInfo().getNextStationId());
                UccDealHandlerReqBO uccDealHandlerReqBO = (UccDealHandlerReqBO)JSON.parseObject((String)JSON.toJSONString((Object)todoUccWaitAbilityReqBO), UccDealHandlerReqBO.class);
                uccDealHandlerReqBO.setHandleName("handler");
                this.uccDealHandlerService.insertDealHandler(uccDealHandlerReqBO);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("\u53d6\u6d88\u5f85\u529e\u5931\u8d25\uff1a" + ex.getMessage());
        }
    }

    private void cancelAudit(Long skuId, Integer objType) {
        try {
            UacNoTaskAuditCancelReqBO uacNoTaskAuditCancelReqBO = new UacNoTaskAuditCancelReqBO();
            uacNoTaskAuditCancelReqBO.setObjId(skuId.toString());
            uacNoTaskAuditCancelReqBO.setObjType(objType);
            uacNoTaskAuditCancelReqBO.setOperDept("sys-mgc");
            uacNoTaskAuditCancelReqBO.setOperId("sys-mgc");
            uacNoTaskAuditCancelReqBO.setCancelOperId("sys-mgc");
            uacNoTaskAuditCancelReqBO.setCancelReason("\u5355\u54c1\u4fe1\u606f\u53d8\u66f4");
            UacNoTaskAuditCancelRspBO uacNoTaskAuditCancelRspBO = this.uacNoTaskAuditCancelAbilityService.auditCancel(uacNoTaskAuditCancelReqBO);
            if ("0000".equals(uacNoTaskAuditCancelRspBO.getRespCode())) {
                throw new BusinessException("8888", uacNoTaskAuditCancelRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u6cbb\u7406\u89e3\u7ed1\u53d6\u6d88\u5ba1\u6279\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

